/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_9;

import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.ChunkEntitySlices;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import com.fastasyncworldedit.bukkit.adapter.CachedBukkitAdapter;
import com.fastasyncworldedit.bukkit.adapter.DelegateSemaphore;
import com.fastasyncworldedit.bukkit.adapter.NMSAdapter;
import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.math.BitArrayUnstretched;
import com.fastasyncworldedit.core.math.IntPair;
import com.fastasyncworldedit.core.util.MathMan;
import com.fastasyncworldedit.core.util.TaskManager;
import com.mojang.serialization.DataResult;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.bukkit.adapter.Refraction;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_9.PaperweightBlockMaterial;
import com.sk89q.worldedit.bukkit.paperlib.PaperLib;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import io.papermc.paper.util.MCUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.function.IntFunction;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.ThreadingDetector;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.Strategy;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import org.apache.logging.log4j.Logger;
import org.bukkit.Chunk;
import org.bukkit.craftbukkit.v1_21_R6.CraftChunk;

public final class PaperweightPlatformAdapter
extends NMSAdapter {
    public static final Field fieldData;
    public static final Constructor<?> dataConstructor;
    public static final Field fieldStorage;
    public static final Field fieldPalette;
    private static final MethodHandle palettedContainerUnpackSpigot;
    private static final Field fieldTickingFluidCount;
    private static final Field fieldTickingBlockCount;
    private static final Field fieldBiomes;
    private static final MethodHandle methodGetVisibleChunk;
    private static final Field fieldThreadingDetector;
    private static final Field fieldLock;
    private static final MethodHandle methodRemoveGameEventListener;
    private static final MethodHandle methodremoveTickingBlockEntity;
    private static final Field fieldRemove;
    private static final Logger LOGGER;
    private static Field SERVER_LEVEL_ENTITY_MANAGER;
    static final MethodHandle PALETTED_CONTAINER_GET;
    private static final ThreadLocal<DelegateSemaphore> SEMAPHORE_THREAD_LOCAL;

    public static TagValueOutput createOutput() {
        return TagValueOutput.a((ProblemReporter)ProblemReporter.a, (HolderLookup.a)DedicatedServer.getServer().bg());
    }

    public static TagValueOutput createOutput(NBTTagCompound compoundTag) {
        return TagValueOutput.createWrappingWithContext((ProblemReporter)ProblemReporter.a, (HolderLookup.a)DedicatedServer.getServer().bg(), (NBTTagCompound)compoundTag);
    }

    public static ValueInput createInput(NBTTagCompound nativeTag) {
        return TagValueInput.a((ProblemReporter)ProblemReporter.a, (HolderLookup.a)DedicatedServer.getServer().bg(), (NBTTagCompound)nativeTag);
    }

    static boolean setSectionAtomic(String worldName, IntPair pair, ChunkSection[] sections, ChunkSection expected, ChunkSection value, int layer) {
        return NMSAdapter.setSectionAtomic(worldName, pair, sections, expected, value, layer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DelegateSemaphore applyLock(ChunkSection section) {
        if (PaperLib.isPaper()) {
            return SEMAPHORE_THREAD_LOCAL.get();
        }
        try {
            ChunkSection chunkSection = section;
            synchronized (chunkSection) {
                ThreadingDetector currentThreadingDetector;
                DataPaletteBlock blocks = section.h();
                ThreadingDetector threadingDetector = currentThreadingDetector = (ThreadingDetector)fieldThreadingDetector.get(blocks);
                synchronized (threadingDetector) {
                    Semaphore currentLock = (Semaphore)fieldLock.get(currentThreadingDetector);
                    if (currentLock instanceof DelegateSemaphore) {
                        DelegateSemaphore delegateSemaphore = (DelegateSemaphore)currentLock;
                        return delegateSemaphore;
                    }
                    DelegateSemaphore newLock = new DelegateSemaphore(1, currentLock);
                    fieldLock.set(currentThreadingDetector, newLock);
                    return newLock;
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("Error apply DelegateSemaphore", e);
            throw new RuntimeException(e);
        }
    }

    public static CompletableFuture<net.minecraft.world.level.chunk.Chunk> ensureLoaded(WorldServer serverLevel, int chunkX, int chunkZ) {
        net.minecraft.world.level.chunk.Chunk levelChunk = PaperweightPlatformAdapter.getChunkImmediatelyAsync(serverLevel, chunkX, chunkZ);
        if (levelChunk != null) {
            return CompletableFuture.completedFuture(levelChunk);
        }
        if (PaperLib.isPaper()) {
            CompletionStage future = serverLevel.getWorld().getChunkAtAsync(chunkX, chunkZ, true, true).thenApply(chunk -> {
                PaperweightPlatformAdapter.addTicket(serverLevel, chunkX, chunkZ);
                try {
                    return PaperweightPlatformAdapter.toLevelChunk(chunk);
                }
                catch (Throwable e) {
                    LOGGER.error("Could not asynchronously load chunk at {},{}", (Object)chunkX, (Object)chunkZ, (Object)e);
                    return null;
                }
            });
            try {
                if (!((CompletableFuture)future).isCompletedExceptionally() || ((CompletableFuture)future).isDone() && ((CompletableFuture)future).get() != null) {
                    return future;
                }
                Throwable t = ((CompletableFuture)future).exceptionNow();
                LOGGER.error("Asynchronous chunk load at {},{} exceptionally completed immediately", (Object)chunkX, (Object)chunkZ, (Object)t);
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("Unexpected error when getting completed future at chunk {},{}. Returning to default.", (Object)chunkX, (Object)chunkZ, (Object)e);
            }
        }
        return CompletableFuture.supplyAsync(() -> TaskManager.taskManager().sync(() -> serverLevel.d(chunkX, chunkZ)));
    }

    private static net.minecraft.world.level.chunk.Chunk toLevelChunk(Chunk chunk) {
        return (net.minecraft.world.level.chunk.Chunk)((CraftChunk)chunk).getHandle(ChunkStatus.n);
    }

    @Nullable
    public static net.minecraft.world.level.chunk.Chunk getChunkImmediatelyAsync(WorldServer serverLevel, int chunkX, int chunkZ) {
        if (!PaperLib.isPaper()) {
            net.minecraft.world.level.chunk.Chunk nmsChunk = serverLevel.n().a(chunkX, chunkZ, false);
            if (nmsChunk != null) {
                return nmsChunk;
            }
            if (Fawe.isMainThread()) {
                return serverLevel.d(chunkX, chunkZ);
            }
            return null;
        }
        net.minecraft.world.level.chunk.Chunk nmsChunk = serverLevel.n().getChunkAtIfCachedImmediately(chunkX, chunkZ);
        if (nmsChunk != null) {
            PaperweightPlatformAdapter.addTicket(serverLevel, chunkX, chunkZ);
            return nmsChunk;
        }
        nmsChunk = serverLevel.n().getChunkAtIfLoadedImmediately(chunkX, chunkZ);
        if (nmsChunk != null) {
            PaperweightPlatformAdapter.addTicket(serverLevel, chunkX, chunkZ);
            return nmsChunk;
        }
        if (Fawe.isMainThread()) {
            return serverLevel.d(chunkX, chunkZ);
        }
        return null;
    }

    private static void addTicket(WorldServer serverLevel, int chunkX, int chunkZ) {
        MCUtil.MAIN_EXECUTOR.execute(() -> serverLevel.n().b(ChunkHolderManager.UNLOAD_COOLDOWN, new ChunkCoordIntPair(chunkX, chunkZ), 0));
    }

    public static PlayerChunk getPlayerChunk(WorldServer nmsWorld, int chunkX, int chunkZ) {
        PlayerChunkMap chunkMap = nmsWorld.n().a;
        try {
            return methodGetVisibleChunk.invoke(chunkMap, ChunkCoordIntPair.c((int)chunkX, (int)chunkZ));
        }
        catch (Throwable thr) {
            throw new RuntimeException(thr);
        }
    }

    public static void sendChunk(IntPair pair, WorldServer nmsWorld, int chunkX, int chunkZ) {
        PlayerChunk chunkHolder = PaperweightPlatformAdapter.getPlayerChunk(nmsWorld, chunkX, chunkZ);
        if (chunkHolder == null) {
            return;
        }
        net.minecraft.world.level.chunk.Chunk levelChunk = PaperLib.isPaper() ? nmsWorld.n().getChunkAtIfLoadedImmediately(chunkX, chunkZ) : (net.minecraft.world.level.chunk.Chunk)chunkHolder.a().getNow(PlayerChunk.a).b(null);
        if (levelChunk == null) {
            return;
        }
        NMSAdapter.StampLockHolder lockHolder = new NMSAdapter.StampLockHolder();
        NMSAdapter.beginChunkPacketSend(nmsWorld.getWorld().getName(), pair, lockHolder);
        if (lockHolder.chunkLock == null) {
            return;
        }
        MinecraftServer.getServer().execute(() -> {
            try {
                ChunkCoordIntPair pos = levelChunk.f();
                ClientboundLevelChunkWithLightPacket packet = PaperLib.isPaper() ? new ClientboundLevelChunkWithLightPacket(levelChunk, nmsWorld.E_(), null, null, false) : new ClientboundLevelChunkWithLightPacket(levelChunk, nmsWorld.E_(), null, null);
                PaperweightPlatformAdapter.nearbyPlayers(nmsWorld, pos).forEach(p -> p.g.b((Packet)packet));
            }
            finally {
                NMSAdapter.endChunkPacketSend(nmsWorld.getWorld().getName(), pair, lockHolder);
            }
        });
    }

    private static List<EntityPlayer> nearbyPlayers(WorldServer serverLevel, ChunkCoordIntPair coordIntPair) {
        return serverLevel.n().a.a(coordIntPair, false);
    }

    public static ChunkSection newChunkSection(int layer, char[] blocks, CachedBukkitAdapter adapter, IRegistryCustom registryAccess, @Nullable DataPaletteBlock<Holder<BiomeBase>> biomes) {
        return PaperweightPlatformAdapter.newChunkSection(layer, null, blocks, adapter, registryAccess, biomes);
    }

    public static ChunkSection newChunkSection(int layer, IntFunction<char[]> get, char[] set, CachedBukkitAdapter adapter, IRegistryCustom registryAccess, @Nullable DataPaletteBlock<Holder<BiomeBase>> biomes) {
        if (set == null) {
            return PaperweightPlatformAdapter.newChunkSection(registryAccess, biomes);
        }
        int[] blockToPalette = (int[])FaweCache.INSTANCE.BLOCK_TO_PALETTE.get();
        int[] paletteToBlock = (int[])FaweCache.INSTANCE.PALETTE_TO_BLOCK.get();
        long[] blockStates = (long[])FaweCache.INSTANCE.BLOCK_STATES.get();
        int[] blocksCopy = (int[])FaweCache.INSTANCE.SECTION_BLOCKS.get();
        try {
            List<IBlockData> palette;
            int num_palette = get == null ? PaperweightPlatformAdapter.createPalette(blockToPalette, paletteToBlock, blocksCopy, set, adapter) : PaperweightPlatformAdapter.createPalette(layer, blockToPalette, paletteToBlock, blocksCopy, get, set, adapter);
            int bitsPerEntry = MathMan.log2nlz(num_palette - 1);
            if (bitsPerEntry > 0 && bitsPerEntry < 5) {
                bitsPerEntry = 4;
            } else if (bitsPerEntry > 8) {
                bitsPerEntry = MathMan.log2nlz(Block.k.d() - 1);
            }
            int bitsPerEntryNonZero = Math.max(bitsPerEntry, 1);
            int blockBitArrayEnd = MathMan.longArrayLength(bitsPerEntryNonZero, 4096);
            if (num_palette == 1) {
                for (int i = 0; i < blockBitArrayEnd; ++i) {
                    blockStates[i] = 0L;
                }
            } else {
                BitArrayUnstretched bitArray = new BitArrayUnstretched(bitsPerEntryNonZero, 4096, blockStates);
                bitArray.fromRaw(blocksCopy);
            }
            long[] bits = Arrays.copyOfRange(blockStates, 0, blockBitArrayEnd);
            if (bitsPerEntry < 9) {
                palette = new ArrayList();
                for (int i = 0; i < num_palette; ++i) {
                    int ordinal = paletteToBlock[i];
                    blockToPalette[ordinal] = Integer.MAX_VALUE;
                    BlockState state = BlockTypesCache.states[ordinal];
                    palette.add((IBlockData)((PaperweightBlockMaterial)state.getMaterial()).getState());
                }
            } else {
                palette = List.of();
            }
            Strategy strategy = Strategy.a((Registry)Block.k);
            PalettedContainerRO.a packedData = new PalettedContainerRO.a(palette, Optional.of(LongStream.of(bits)), bitsPerEntry);
            DataResult result = PaperLib.isPaper() ? DataPaletteBlock.unpack((Strategy)strategy, (PalettedContainerRO.a)packedData, (Object)Blocks.a.m(), null) : palettedContainerUnpackSpigot.invokeExact(strategy, packedData);
            if (biomes == null) {
                biomes = PalettedContainerFactory.a((IRegistryCustom)registryAccess).b();
            }
            ChunkSection chunkSection = new ChunkSection((DataPaletteBlock)result.getOrThrow(), biomes);
            return chunkSection;
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to create block palette", e);
        }
        finally {
            Arrays.fill(blockToPalette, Integer.MAX_VALUE);
            Arrays.fill(paletteToBlock, Integer.MAX_VALUE);
            Arrays.fill(blockStates, 0L);
            Arrays.fill(blocksCopy, 0);
        }
    }

    private static ChunkSection newChunkSection(IRegistryCustom registryAccess, @Nullable DataPaletteBlock<Holder<BiomeBase>> biomes) {
        PalettedContainerFactory factory = PalettedContainerFactory.a((IRegistryCustom)registryAccess);
        if (biomes == null) {
            return new ChunkSection(factory);
        }
        return new ChunkSection(factory.a(), biomes);
    }

    public static void setBiomesToChunkSection(ChunkSection section, DataPaletteBlock<Holder<BiomeBase>> biomes) {
        try {
            fieldBiomes.set(section, biomes);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Could not set biomes to chunk section", (Throwable)e);
        }
    }

    public static DataPaletteBlock<Holder<BiomeBase>> getBiomePalettedContainer(BiomeType[] biomes, Registry<Holder<BiomeBase>> biomeRegistry) {
        DataResult result;
        if (biomes == null) {
            return null;
        }
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        ArrayList<Holder> palette = new ArrayList<Holder>();
        for (BiomeType biomeType : new LinkedList<BiomeType>(Set.of(biomes))) {
            if (biomeType == null) {
                palette.add((Holder)biomeRegistry.a(adapter.getInternalBiomeId(BiomeTypes.PLAINS)));
                continue;
            }
            palette.add((Holder)biomeRegistry.a(adapter.getInternalBiomeId(biomeType)));
        }
        int biomeCount = palette.size();
        int bitsPerEntry = MathMan.log2nlz(biomeCount - 1);
        if (bitsPerEntry > 3) {
            bitsPerEntry = MathMan.log2nlz(biomeRegistry.d() - 1);
        }
        int bitsPerEntryNonZero = Math.max(bitsPerEntry, 1);
        int arrayLength = MathMan.longArrayLength(bitsPerEntryNonZero, 64);
        Strategy strategy = Strategy.b(biomeRegistry);
        PalettedContainerRO.a packedData = new PalettedContainerRO.a(palette, Optional.of(LongStream.of(new long[arrayLength])), bitsPerEntry);
        if (PaperLib.isPaper()) {
            result = DataPaletteBlock.unpack((Strategy)strategy, (PalettedContainerRO.a)packedData, (Object)((Holder)biomeRegistry.b(adapter.getInternalBiomeId(BiomeTypes.PLAINS))), null);
        } else {
            try {
                result = palettedContainerUnpackSpigot.invokeExact(strategy, packedData);
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to create biome palette for Spigot", e);
            }
        }
        DataPaletteBlock biomePalettedContainer = (DataPaletteBlock)result.getOrThrow();
        int index = 0;
        for (int y = 0; y < 4; ++y) {
            for (int z = 0; z < 4; ++z) {
                int x = 0;
                while (x < 4) {
                    Holder biome;
                    BiomeType biomeType = biomes[index];
                    if (biomeType != null && (biome = (Holder)biomeRegistry.a(WorldEditPlugin.getInstance().getBukkitImplAdapter().getInternalBiomeId(biomeType))) != null) {
                        biomePalettedContainer.c(x, y, z, (Object)biome);
                    }
                    ++x;
                    ++index;
                }
            }
        }
        return biomePalettedContainer;
    }

    public static void clearCounts(ChunkSection section) throws IllegalAccessException {
        fieldTickingFluidCount.setShort(section, (short)0);
        fieldTickingBlockCount.setShort(section, (short)0);
    }

    public static BiomeType adapt(Holder<BiomeBase> biome, GeneratorAccess levelAccessor) {
        IRegistry biomeRegistry = levelAccessor.L_().f(Registries.aN);
        int id = biomeRegistry.a((Object)((BiomeBase)biome.a()));
        if (id < 0) {
            return BiomeTypes.OCEAN;
        }
        return BiomeTypes.getLegacy(id);
    }

    static void removeBeacon(TileEntity beacon, net.minecraft.world.level.chunk.Chunk levelChunk) {
        try {
            TileEntity blockEntity;
            if ((levelChunk.p || levelChunk.q.D_()) && (blockEntity = (TileEntity)levelChunk.j.remove(beacon.aD_())) != null) {
                if (!levelChunk.q.D_()) {
                    methodRemoveGameEventListener.invoke(levelChunk, beacon, levelChunk.q);
                }
                fieldRemove.set(beacon, true);
            }
            methodremoveTickingBlockEntity.invoke(levelChunk, beacon.aD_());
        }
        catch (Throwable throwable) {
            LOGGER.error("Error removing beacon", throwable);
        }
    }

    static List<Entity> getEntities(net.minecraft.world.level.chunk.Chunk chunk) {
        if (PaperLib.isPaper()) {
            return Optional.ofNullable(chunk.q.moonrise$getEntityLookup().getChunk(chunk.locX, chunk.locZ)).map(ChunkEntitySlices::getAllEntities).orElse(Collections.emptyList());
        }
        try {
            return ((PersistentEntitySectionManager)SERVER_LEVEL_ENTITY_MANAGER.get(chunk.q)).getEntities(chunk.f());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to lookup entities [PAPER=false]", e);
        }
    }

    static {
        LOGGER = LogManagerCompat.getLogger();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Field tmpFieldBiomes;
            fieldData = DataPaletteBlock.class.getDeclaredField(Refraction.pickName("data", "b"));
            fieldData.setAccessible(true);
            Class<?> dataClazz = fieldData.getType();
            dataConstructor = dataClazz.getDeclaredConstructors()[0];
            dataConstructor.setAccessible(true);
            fieldStorage = dataClazz.getDeclaredField(Refraction.pickName("storage", "b"));
            fieldStorage.setAccessible(true);
            fieldPalette = dataClazz.getDeclaredField(Refraction.pickName("palette", "c"));
            fieldPalette.setAccessible(true);
            palettedContainerUnpackSpigot = PaperLib.isPaper() ? null : lookup.findStatic(DataPaletteBlock.class, "a", MethodType.methodType(DataResult.class, Strategy.class, PalettedContainerRO.a.class));
            fieldTickingFluidCount = ChunkSection.class.getDeclaredField(Refraction.pickName("tickingFluidCount", "g"));
            fieldTickingFluidCount.setAccessible(true);
            fieldTickingBlockCount = ChunkSection.class.getDeclaredField(Refraction.pickName("tickingBlockCount", "f"));
            fieldTickingBlockCount.setAccessible(true);
            try {
                tmpFieldBiomes = ChunkSection.class.getDeclaredField("biomes");
            }
            catch (NoSuchFieldException ignored) {
                tmpFieldBiomes = ChunkSection.class.getDeclaredField("i");
            }
            fieldBiomes = tmpFieldBiomes;
            fieldBiomes.setAccessible(true);
            Method getVisibleChunkIfPresent = PlayerChunkMap.class.getDeclaredMethod(Refraction.pickName("getVisibleChunkIfPresent", "b"), Long.TYPE);
            getVisibleChunkIfPresent.setAccessible(true);
            methodGetVisibleChunk = lookup.unreflect(getVisibleChunkIfPresent);
            if (!PaperLib.isPaper()) {
                fieldThreadingDetector = DataPaletteBlock.class.getDeclaredField(Refraction.pickName("threadingDetector", "d"));
                fieldThreadingDetector.setAccessible(true);
                fieldLock = ThreadingDetector.class.getDeclaredField(Refraction.pickName("lock", "c"));
                fieldLock.setAccessible(true);
                SERVER_LEVEL_ENTITY_MANAGER = WorldServer.class.getDeclaredField(Refraction.pickName("entityManager", "M"));
                SERVER_LEVEL_ENTITY_MANAGER.setAccessible(true);
            } else {
                fieldThreadingDetector = null;
                fieldLock = null;
            }
            Method removeGameEventListener = net.minecraft.world.level.chunk.Chunk.class.getDeclaredMethod(Refraction.pickName("removeGameEventListener", "a"), TileEntity.class, WorldServer.class);
            removeGameEventListener.setAccessible(true);
            methodRemoveGameEventListener = lookup.unreflect(removeGameEventListener);
            Method removeBlockEntityTicker = net.minecraft.world.level.chunk.Chunk.class.getDeclaredMethod(Refraction.pickName("removeBlockEntityTicker", "k"), BlockPosition.class);
            removeBlockEntityTicker.setAccessible(true);
            methodremoveTickingBlockEntity = lookup.unreflect(removeBlockEntityTicker);
            fieldRemove = TileEntity.class.getDeclaredField(Refraction.pickName("remove", "p"));
            fieldRemove.setAccessible(true);
            Method palettedContainerGet = DataPaletteBlock.class.getDeclaredMethod(Refraction.pickName("get", "a"), Integer.TYPE);
            palettedContainerGet.setAccessible(true);
            PALETTED_CONTAINER_GET = lookup.unreflect(palettedContainerGet);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SEMAPHORE_THREAD_LOCAL = ThreadLocal.withInitial(() -> new DelegateSemaphore(1, null));
    }
}

