/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.event.extent.ActorSaveClipboardEvent;
import com.fastasyncworldedit.core.extent.clipboard.MultiClipboardHolder;
import com.fastasyncworldedit.core.extent.clipboard.URIClipboardHolder;
import com.fastasyncworldedit.core.math.transform.MutatingOperationTransformHolder;
import com.fastasyncworldedit.core.util.MainUtil;
import com.fastasyncworldedit.core.util.ReflectionUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.UtilityCommands;
import com.sk89q.worldedit.command.argument.Arguments;
import com.sk89q.worldedit.command.util.AsyncCommandBuilder;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.extent.clipboard.io.share.ClipboardShareDestination;
import com.sk89q.worldedit.extent.clipboard.io.share.ClipboardShareMetadata;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.util.formatting.component.ErrorFormat;
import com.sk89q.worldedit.util.formatting.component.PaginationBox;
import com.sk89q.worldedit.util.formatting.component.TextComponentProducer;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import com.sk89q.worldedit.util.formatting.text.event.HoverEvent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import com.sk89q.worldedit.util.io.Closer;
import com.sk89q.worldedit.util.io.file.FilenameException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Arg;
import org.enginehub.piston.annotation.param.ArgFlag;
import org.enginehub.piston.annotation.param.Switch;
import org.enginehub.piston.exception.StopExecutionException;

@CommandContainer(superTypes={CommandPermissionsConditionGenerator.Registration.class})
public class SchematicCommands {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private final WorldEdit worldEdit;

    public SchematicCommands(WorldEdit worldEdit) {
        Preconditions.checkNotNull((Object)worldEdit);
        this.worldEdit = worldEdit;
    }

    private static List<File> getFiles(File root, String filter, ClipboardFormat format) {
        File[] files = root.listFiles();
        if (files == null) {
            return null;
        }
        if (format != null) {
            files = (File[])Arrays.stream(files).filter(format::isFormat).toArray(File[]::new);
        }
        ArrayList<File> fileList = new ArrayList<File>();
        for (File f : files) {
            if (f.isDirectory()) {
                List<File> subFiles = SchematicCommands.getFiles(f, filter, format);
                if (subFiles == null) continue;
                fileList.addAll(subFiles);
                continue;
            }
            fileList.add(f);
        }
        return fileList;
    }

    @Command(name="loadall", desc="Load multiple clipboards (paste will randomly choose one)")
    @Deprecated
    @CommandPermissions(value={"worldedit.clipboard.load", "worldedit.schematic.load", "worldedit.schematic.load.web", "worldedit.schematic.load.asset"})
    public void loadall(Actor actor, LocalSession session, @Arg(desc="Format name.", def={"fast"}) String formatName, @Arg(desc="File name.") String filename, @Switch(name=111, desc="Overwrite/replace existing clipboard(s)") boolean overwrite, @Switch(name=114, desc="Apply random rotation (static by default)") boolean randomRotate, @Switch(name=100, desc="Random rotation is dynamic, changing each use") boolean dynamicRandom) throws FilenameException {
        ClipboardFormat format = ClipboardFormats.findByAlias(formatName);
        if (format == null) {
            actor.print(Caption.of("fawe.worldedit.clipboard.clipboard.invalid.format", formatName));
            return;
        }
        try {
            MultiClipboardHolder all = ClipboardFormats.loadAllFromInput(actor, filename, null, true);
            if (all == null) {
                actor.print(Caption.of("fawe.worldedit.schematic.schematic.loaded", filename));
                return;
            }
            if (randomRotate) {
                for (ClipboardHolder holder : all) {
                    SchematicCommands.setRandomRotateTransform(dynamicRandom, holder);
                }
                SchematicCommands.setRandomRotateTransform(dynamicRandom, all);
            }
            if (overwrite) {
                session.setClipboard(all);
            } else {
                session.addClipboard(all);
            }
            actor.print(Caption.of("fawe.worldedit.schematic.schematic.loaded", filename));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setRandomRotateTransform(boolean dynamicRandom, ClipboardHolder holder) {
        if (dynamicRandom) {
            MutatingOperationTransformHolder<AffineTransform> mutating = new MutatingOperationTransformHolder<AffineTransform>(new AffineTransform(), t -> {
                int rotate = 90 * ThreadLocalRandom.current().nextInt(4);
                return t.rotateY(rotate);
            });
            holder.setTransform(mutating);
        } else {
            AffineTransform transform = new AffineTransform();
            int rotate = 90 * ThreadLocalRandom.current().nextInt(4);
            transform = transform.rotateY(rotate);
            holder.setTransform(transform);
        }
    }

    @Command(name="clear", desc="Clear your clipboard")
    @CommandPermissions(value={"worldedit.clipboard.clear", "worldedit.schematic.clear"})
    public void clear(Actor actor, LocalSession session) throws WorldEditException {
        session.setClipboard(null);
        actor.print(Caption.of("fawe.worldedit.clipboard.clipboard.cleared", new Object[0]));
    }

    @Command(name="unload", desc="Remove a clipboard from your multi-clipboard")
    @CommandPermissions(value={"worldedit.clipboard.clear", "worldedit.schematic.clear"})
    public void unload(Actor actor, LocalSession session, @Arg(desc="File name, requires extension.") String fileName) throws WorldEditException {
        URIClipboardHolder identifiable;
        URI uri;
        if (fileName.startsWith("file:/") || fileName.startsWith("http://") || fileName.startsWith("https://")) {
            uri = URI.create(fileName);
        } else {
            LocalConfiguration config = this.worldEdit.getConfiguration();
            File working = this.worldEdit.getWorkingDirectoryPath(config.saveDir).toFile();
            File root = Settings.settings().PATHS.PER_PLAYER_SCHEMATICS ? new File(working, actor.getUniqueId().toString()) : working;
            uri = new File(root, fileName).toURI();
        }
        ClipboardHolder clipboard = session.getClipboard();
        if (clipboard instanceof URIClipboardHolder && (identifiable = (URIClipboardHolder)clipboard).contains(uri)) {
            if (identifiable instanceof MultiClipboardHolder) {
                MultiClipboardHolder multi = (MultiClipboardHolder)identifiable;
                multi.remove(uri);
                if (multi.getHolders().isEmpty()) {
                    session.setClipboard(null);
                }
            } else {
                session.setClipboard(null);
            }
            actor.print(Caption.of("fawe.worldedit.clipboard.clipboard.cleared", new Object[0]));
            return;
        }
        actor.print(Caption.of("fawe.worldedit.clipboard.clipboard.uri.not.found", fileName));
    }

    @Command(name="move", aliases={"m"}, desc="Move your loaded schematic")
    @CommandPermissions(value={"worldedit.schematic.move", "worldedit.schematic.move.other"})
    public void move(Actor actor, LocalSession session, @Arg(desc="Directory.") String directory) throws WorldEditException, IOException {
        File dir;
        File destDir;
        LocalConfiguration config = this.worldEdit.getConfiguration();
        File working = this.worldEdit.getWorkingDirectoryPath(config.saveDir).toFile();
        if (!MainUtil.isInSubDirectory(working, destDir = new File(dir = Settings.settings().PATHS.PER_PLAYER_SCHEMATICS ? new File(working, actor.getUniqueId().toString()) : working, directory))) {
            actor.print(Caption.of("worldedit.schematic.directory-does-not-exist", TextComponent.of(String.valueOf(destDir))));
            return;
        }
        if (Settings.settings().PATHS.PER_PLAYER_SCHEMATICS && !MainUtil.isInSubDirectory(dir, destDir) && !actor.hasPermission("worldedit.schematic.move.other")) {
            actor.print(Caption.of("fawe.error.no-perm", "worldedit.schematic.move.other"));
            return;
        }
        ClipboardHolder clipboard = session.getClipboard();
        List<File> sources = this.getFiles(clipboard);
        if (sources.isEmpty()) {
            actor.print(Caption.of("fawe.worldedit.schematic.schematic.none", new Object[0]));
            return;
        }
        if (!destDir.exists() && !destDir.mkdirs()) {
            actor.print(Caption.of("worldedit.schematic.file-perm-fail", TextComponent.of(String.valueOf(destDir))));
            return;
        }
        for (File source : sources) {
            File destFile = new File(destDir, source.getName());
            if (destFile.exists()) {
                actor.print(Caption.of("fawe.worldedit.schematic.schematic.move.exists", destFile));
                continue;
            }
            if (!(!Settings.settings().PATHS.PER_PLAYER_SCHEMATICS || MainUtil.isInSubDirectory(dir, destFile) && MainUtil.isInSubDirectory(dir, source) || actor.hasPermission("worldedit.schematic.delete.other"))) {
                actor.print(Caption.of("fawe.worldedit.schematic.schematic.move.failed", destFile, Caption.of("fawe.error.no-perm", "worldedit.schematic.move.other")));
                continue;
            }
            try {
                File cached = new File(source.getParentFile(), "." + source.getName() + ".cached");
                Files.move(source.toPath(), destFile.toPath(), new CopyOption[0]);
                if (cached.exists()) {
                    Files.move(cached.toPath(), destFile.toPath(), new CopyOption[0]);
                }
                actor.print(Caption.of("fawe.worldedit.schematic.schematic.move.success", source, destFile));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private List<File> getFiles(ClipboardHolder clipboard) {
        Collection<Object> uris = Collections.emptyList();
        if (clipboard instanceof URIClipboardHolder) {
            uris = ((URIClipboardHolder)clipboard).getURIs();
        }
        ArrayList<File> files = new ArrayList<File>();
        for (URI uRI : uris) {
            File file = new File(uRI);
            if (!file.exists()) continue;
            files.add(file);
        }
        return files;
    }

    @Command(name="load", desc="Load a schematic into your clipboard")
    @CommandPermissions(value={"worldedit.clipboard.load", "worldedit.schematic.load", "worldedit.schematic.load.asset", "worldedit.schematic.load.web", "worldedit.schematic.load.other"})
    public void load(Actor actor, LocalSession session, @Arg(desc="File name.") String filename, @Arg(desc="Format name.", def={""}) String formatName, @Switch(name=114, desc="Apply random rotation to the clipboard") boolean randomRotate, @Switch(name=100, desc="Random rotation is dynamic, changing each use") boolean dynamicRandom) throws FilenameException {
        boolean noExplicitFormat;
        LocalConfiguration config = this.worldEdit.getConfiguration();
        boolean bl = noExplicitFormat = formatName == null;
        if (noExplicitFormat) {
            formatName = "fast";
        }
        try (Closer closer = Closer.create();){
            URI uri;
            FileInputStream in;
            ClipboardFormat format;
            if (formatName.startsWith("url:")) {
                String t = filename;
                filename = formatName;
                formatName = t;
            }
            if (filename.startsWith("url:")) {
                if (!actor.hasPermission("worldedit.schematic.load.web")) {
                    actor.print(Caption.of("fawe.error.no-perm", "worldedit.schematic.load.web"));
                    return;
                }
                UUID uuid = UUID.fromString(filename.substring(4));
                URL webUrl = new URL(Settings.settings().WEB.URL);
                format = ClipboardFormats.findByAlias(formatName);
                if (format == null) {
                    actor.print(Caption.of("worldedit.schematic.unknown-format", TextComponent.of(formatName)));
                    return;
                }
                URL url = new URL(webUrl, "uploads/" + String.valueOf(uuid) + "." + format.getPrimaryFileExtension());
                Path temp = Files.createTempFile("faweremoteschem", null, new FileAttribute[0]);
                File tempFile = temp.toFile();
                closer.register(() -> Files.deleteIfExists(temp));
                try (BufferedInputStream urlIn = new BufferedInputStream(url.openStream());
                     BufferedOutputStream tempOut = new BufferedOutputStream(new FileOutputStream(tempFile));){
                    ((InputStream)urlIn).transferTo(tempOut);
                }
                if (noExplicitFormat && (format = ClipboardFormats.findByFile(tempFile)) == null) {
                    actor.print(Caption.of("fawe.worldedit.schematic.schematic.load-failure", TextComponent.of(filename)));
                    return;
                }
                in = new FileInputStream(tempFile);
                uri = temp.toUri();
            } else {
                File file;
                File dir;
                File saveDir = this.worldEdit.getWorkingDirectoryPath(config.saveDir).toFile();
                File file2 = dir = Settings.settings().PATHS.PER_PLAYER_SCHEMATICS ? new File(saveDir, actor.getUniqueId().toString()) : saveDir;
                if (filename.startsWith("#")) {
                    format = noExplicitFormat ? null : ClipboardFormats.findByAlias(formatName);
                    String[] extensions = format != null ? format.getFileExtensions().toArray(new String[0]) : ClipboardFormats.getFileExtensionArray();
                    file = actor.openFileOpenDialog(extensions);
                    if (file == null || !file.exists()) {
                        actor.print(Caption.of("worldedit.schematic.load.does-not-exist", TextComponent.of(filename)));
                        return;
                    }
                } else {
                    if (Settings.settings().PATHS.PER_PLAYER_SCHEMATICS && !actor.hasPermission("worldedit.schematic.load.other") && Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}").matcher(filename).find()) {
                        actor.print(Caption.of("fawe.error.no-perm", "worldedit.schematic.load.other"));
                        return;
                    }
                    format = !noExplicitFormat ? ClipboardFormats.findByAlias(formatName) : (filename.matches(".*\\.\\w.*") ? ClipboardFormats.findByExplicitExtension(filename.substring(filename.lastIndexOf(46) + 1)) : null);
                    file = MainUtil.resolve(dir, filename, format, false);
                }
                if (!(file != null && file.exists() || filename.contains("../"))) {
                    dir = this.worldEdit.getWorkingDirectoryPath(config.saveDir).toFile();
                    file = MainUtil.resolve(dir, filename, format, false);
                }
                if (file == null || !file.exists() || !MainUtil.isInSubDirectory(saveDir, file)) {
                    actor.printError(TextComponent.of("Schematic " + filename + " does not exist! (" + (file != null && file.exists()) + "|" + String.valueOf(file) + "|" + (file != null && !MainUtil.isInSubDirectory(saveDir, file)) + ")"));
                    return;
                }
                if (format == null && (format = ClipboardFormats.findByFile(file)) == null) {
                    if (noExplicitFormat) {
                        actor.print(Caption.of("fawe.worldedit.schematic.schematic.load-failure", TextComponent.of(file.getName())));
                    } else {
                        actor.print(Caption.of("worldedit.schematic.unknown-format", TextComponent.of(formatName)));
                    }
                    return;
                }
                in = new FileInputStream(file);
                uri = file.toURI();
            }
            closer.register(in);
            format.hold(actor, uri, in);
            if (randomRotate) {
                SchematicCommands.setRandomRotateTransform(dynamicRandom, session.getClipboard());
            }
            actor.print(Caption.of("fawe.worldedit.schematic.schematic.loaded", filename));
        }
        catch (IllegalArgumentException e) {
            actor.print(Caption.of("worldedit.schematic.unknown-filename", TextComponent.of(filename)));
        }
        catch (EOFException e) {
            actor.print(Caption.of("fawe.worldedit.schematic.schematic.load-failure", TextComponent.of(e.getMessage() != null ? e.getMessage() : "EOFException")));
            LOGGER.error("Error loading a schematic", (Throwable)e);
        }
        catch (IOException e) {
            actor.print(Caption.of("worldedit.schematic.file-not-exist", TextComponent.of(Objects.toString(e.getMessage()))));
            LOGGER.warn("Failed to load a saved clipboard", (Throwable)e);
        }
        catch (Exception e) {
            actor.print(Caption.of("fawe.worldedit.schematic.schematic.load-failure", TextComponent.of(e.getMessage())));
            LOGGER.error("Error loading a schematic", (Throwable)e);
        }
    }

    @Command(name="save", desc="Save your clipboard into a schematic file")
    @CommandPermissions(value={"worldedit.clipboard.save", "worldedit.schematic.save", "worldedit.schematic.save.other", "worldedit.schematic.save.global"})
    public void save(Actor actor, LocalSession session, @Arg(desc="File name.") String filename, @Arg(desc="Format name.", def={"fast"}) ClipboardFormat format, @Switch(name=102, desc="Overwrite an existing file.") boolean allowOverwrite, @Switch(name=103, desc="Bypasses per-player-schematic folders") boolean global) throws WorldEditException {
        File parent;
        boolean overwrite;
        File f;
        int i;
        if (global && !actor.hasPermission("worldedit.schematic.save.global")) {
            actor.print(Caption.of("fawe.error.no-perm", "worldedit.schematic.save.global"));
            return;
        }
        if (this.worldEdit.getPlatformManager().queryCapability(Capability.GAME_HOOKS).getDataVersion() == -1) {
            actor.print(TranslatableComponent.of("worldedit.schematic.unsupported-minecraft-version"));
            return;
        }
        LocalConfiguration config = this.worldEdit.getConfiguration();
        File dir = this.worldEdit.getWorkingDirectoryPath(config.saveDir).toFile();
        if (!global && Settings.settings().PATHS.PER_PLAYER_SCHEMATICS) {
            dir = new File(dir, actor.getUniqueId().toString());
        }
        boolean other = false;
        if (((String)filename).contains("../")) {
            other = true;
            if (!actor.hasPermission("worldedit.schematic.save.other")) {
                actor.print(Caption.of("fawe.error.no-perm", "worldedit.schematic.save.other"));
                return;
            }
            if (((String)filename).startsWith("../")) {
                dir = this.worldEdit.getWorkingDirectoryPath(config.saveDir).toFile();
                filename = ((String)filename).substring(3);
            }
        }
        if ((i = (f = this.worldEdit.getSafeSaveFile(actor, dir, (String)filename, format.getPrimaryFileExtension(), new String[0])).getName().lastIndexOf(46)) == -1 && f.getName().isEmpty() || i == 0) {
            File directory = f.getParentFile();
            int fileNumber = directory.exists() ? MainUtil.getMaxFileId(directory) : 0;
            String extension = i == 0 ? f.getName().substring(i + 1) : format.getPrimaryFileExtension();
            String name = String.format("%s.%s", fileNumber, extension);
            f = new File(directory, name);
            filename = (String)filename + name;
        }
        if (overwrite = f.exists()) {
            if (!actor.hasPermission("worldedit.schematic.delete")) {
                throw new StopExecutionException(Caption.of("worldedit.schematic.already-exists", new Object[0]));
            }
            if (other && !actor.hasPermission("worldedit.schematic.delete.other")) {
                actor.print(Caption.of("fawe.error.no-perm", "worldedit.schematic.delete.other"));
                return;
            }
            if (!allowOverwrite) {
                actor.print(Caption.of("worldedit.schematic.save.already-exists", new Object[0]));
                return;
            }
        }
        if ((parent = f.getParentFile()) != null && !parent.exists() && !parent.mkdirs()) {
            throw new StopExecutionException(Caption.of("worldedit.schematic.save.failed-directory", new Object[0]));
        }
        ClipboardHolder holder = session.getClipboard();
        SchematicSaveTask task = new SchematicSaveTask(actor, f, dir, format, holder, overwrite);
        AsyncCommandBuilder.wrap(task, actor).registerWithSupervisor(this.worldEdit.getSupervisor(), "Saving schematic " + (String)filename).setDelayMessage(Caption.of("worldedit.schematic.save.saving", new Object[0])).onSuccess((String)filename + " saved" + (overwrite ? " (overwriting previous file)." : "."), null).onFailure(Caption.of("worldedit.schematic.failed-to-save", new Object[0]), this.worldEdit.getPlatformManager().getPlatformCommandManager().getExceptionConverter()).buildAndExec(this.worldEdit.getExecutorService());
    }

    @Command(name="share", desc="Share your clipboard as a schematic online")
    @CommandPermissions(value={"worldedit.clipboard.share", "worldedit.schematic.share"})
    public void share(Actor actor, LocalSession session, @Arg(desc="Schematic name. Defaults to name-millis", def={""}) String schematicName, @Arg(desc="Share location", def={"arkitektonika"}) ClipboardShareDestination destination, @Arg(desc="Format name", def={"fast"}) ClipboardFormat format) throws WorldEditException {
        if (this.worldEdit.getPlatformManager().queryCapability(Capability.GAME_HOOKS).getDataVersion() == -1) {
            actor.printError(TranslatableComponent.of("worldedit.schematic.unsupported-minecraft-version"));
            return;
        }
        if (format == null) {
            format = destination.getDefaultFormat();
        }
        if (!destination.supportsFormat(format)) {
            actor.printError(Caption.of("worldedit.schematic.share.unsupported-format", TextComponent.of(destination.getName()), TextComponent.of(format.getName())));
            return;
        }
        ClipboardHolder holder = session.getClipboard();
        SchematicShareTask task = new SchematicShareTask(actor, holder, destination, format, schematicName);
        AsyncCommandBuilder.wrap(task, actor).registerWithSupervisor(this.worldEdit.getSupervisor(), "Sharing schematic").setDelayMessage(TranslatableComponent.of("worldedit.schematic.save.saving")).setWorkingMessage(TranslatableComponent.of("worldedit.schematic.save.still-saving")).onSuccess("Shared", consumer -> consumer.accept(actor)).onFailure("Failed to share schematic", this.worldEdit.getPlatformManager().getPlatformCommandManager().getExceptionConverter()).buildAndExec(this.worldEdit.getExecutorService());
    }

    @Command(name="delete", aliases={"d"}, desc="Delete a saved schematic")
    @CommandPermissions(value={"worldedit.schematic.delete"})
    public void delete(Actor actor, LocalSession session, @Arg(desc="File name.") String filename) throws WorldEditException, IOException {
        LocalConfiguration config = this.worldEdit.getConfiguration();
        File working = this.worldEdit.getWorkingDirectoryPath(config.saveDir).toFile();
        File dir = Settings.settings().PATHS.PER_PLAYER_SCHEMATICS ? new File(working, actor.getUniqueId().toString()) : working;
        ArrayList<File> files = new ArrayList<File>();
        if (filename.equalsIgnoreCase("*")) {
            files.addAll(this.getFiles(session.getClipboard()));
        } else {
            File f = MainUtil.resolveRelative(new File(dir, filename));
            files.add(f);
        }
        if (files.isEmpty()) {
            actor.print(Caption.of("worldedit.schematic.delete.does-not-exist", TextComponent.of(filename)));
            return;
        }
        for (File f : files) {
            if (!MainUtil.isInSubDirectory(working, f) || !f.exists()) {
                actor.print(Caption.of("worldedit.schematic.delete.does-not-exist", TextComponent.of(filename)));
                continue;
            }
            if (Settings.settings().PATHS.PER_PLAYER_SCHEMATICS && !MainUtil.isInSubDirectory(dir, f) && !actor.hasPermission("worldedit.schematic.delete.other")) {
                actor.print(Caption.of("fawe.error.no-perm", "worldedit.schematic.delete.other"));
                continue;
            }
            if (!this.deleteFile(f)) {
                actor.print(Caption.of("worldedit.schematic.delete.failed", TextComponent.of(filename)));
                continue;
            }
            actor.print(Caption.of("worldedit.schematic.delete.deleted", filename));
        }
    }

    private boolean deleteFile(File file) {
        if (file.delete()) {
            new File(file.getParentFile(), "." + file.getName() + ".cached").delete();
            return true;
        }
        return false;
    }

    @Command(name="formats", aliases={"listformats", "f"}, desc="List available formats")
    @CommandPermissions(value={"worldedit.schematic.formats"}, queued=false)
    public void formats(Actor actor) {
        actor.print(Caption.of("worldedit.schematic.formats.title", new Object[0]));
        boolean first = true;
        for (ClipboardFormat format : ClipboardFormats.getAll()) {
            StringBuilder builder = new StringBuilder();
            builder.append(format.getName()).append(": ");
            for (String lookupName : format.getAliases()) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append(lookupName);
                first = false;
            }
            first = true;
            actor.print(TextComponent.of(builder.toString()));
        }
    }

    @Command(name="list", aliases={"all", "ls"}, desc="List saved schematics", descFooter="Note: Format is not fully verified until loading.")
    @CommandPermissions(value={"worldedit.schematic.list"}, queued=false)
    public void list(Actor actor, LocalSession session, @ArgFlag(name=112, desc="Page to view.", def={"1"}) int page, @Switch(name=100, desc="Sort by date, oldest first") boolean oldFirst, @Switch(name=110, desc="Sort by date, newest first") boolean newFirst, @ArgFlag(name=102, desc="Restricts by format.", def={""}) String formatName, @Arg(name="filter", desc="Filter for schematics", def={"all"}) String filter, Arguments arguments) throws WorldEditException {
        if (oldFirst && newFirst) {
            throw new StopExecutionException(Caption.of("worldedit.schematic.sorting-old-new", new Object[0]));
        }
        String pageCommand = "/" + arguments.get();
        LocalConfiguration config = this.worldEdit.getConfiguration();
        File dir = this.worldEdit.getWorkingDirectoryPath(config.saveDir).toFile();
        String schemCmd = "//schematic";
        String loadSingle = schemCmd + " load";
        String loadMulti = schemCmd + " loadall";
        String unload = schemCmd + " unload";
        String delete = schemCmd + " delete";
        String list = schemCmd + " list";
        String showCmd = schemCmd + " show";
        List<String> args = filter.isEmpty() ? Collections.emptyList() : Arrays.asList(filter.split(" "));
        URIClipboardHolder multi = ReflectionUtils.as(URIClipboardHolder.class, session.getExistingClipboard());
        boolean hasShow = false;
        boolean playerFolder = Settings.settings().PATHS.PER_PLAYER_SCHEMATICS;
        UUID uuid = playerFolder ? actor.getUniqueId() : null;
        List<File> files = UtilityCommands.getFiles(dir, actor, args, formatName, playerFolder, oldFirst, newFirst);
        List<Map.Entry<URI, String>> entries = UtilityCommands.filesToEntry(dir, files, uuid);
        Function<URI, Boolean> isLoaded = multi == null ? f -> false : multi::contains;
        List<Component> components = UtilityCommands.entryToComponent(dir, entries, isLoaded, (name, path, type, loaded) -> {
            TextComponentProducer msg = new TextComponentProducer();
            msg.append(Caption.of("worldedit.schematic.dash.symbol", new Object[0]));
            if (loaded.booleanValue()) {
                msg.append(((TranslatableComponent)Caption.of("worldedit.schematic.minus.symbol", new Object[0]).clickEvent(ClickEvent.of(ClickEvent.Action.SUGGEST_COMMAND, unload + " " + path))).hoverEvent(HoverEvent.of(HoverEvent.Action.SHOW_TEXT, Caption.of("worldedit.schematic.unload", new Object[0]))));
            } else {
                msg.append(((TranslatableComponent)Caption.of("worldedit.schematic.plus.symbol", new Object[0]).clickEvent(ClickEvent.of(ClickEvent.Action.SUGGEST_COMMAND, loadMulti + " " + path))).hoverEvent(HoverEvent.of(HoverEvent.Action.SHOW_TEXT, Caption.of("worldedit.schematic.clipboard", new Object[0]))));
            }
            if (type != UtilityCommands.URIType.DIRECTORY) {
                msg.append(((TranslatableComponent)Caption.of("worldedit.schematic.x.symbol", new Object[0]).clickEvent(ClickEvent.of(ClickEvent.Action.SUGGEST_COMMAND, delete + " " + path))).hoverEvent(HoverEvent.of(HoverEvent.Action.SHOW_TEXT, Caption.of("worldedit.schematic.delete", new Object[0]))));
            }
            TextComponent msgElem = TextComponent.of(name);
            if (type != UtilityCommands.URIType.DIRECTORY) {
                msgElem = (TextComponent)msgElem.clickEvent(ClickEvent.of(ClickEvent.Action.SUGGEST_COMMAND, loadSingle + " " + path));
                msgElem = (TextComponent)msgElem.hoverEvent(HoverEvent.of(HoverEvent.Action.SHOW_TEXT, Caption.of("worldedit.schematic.load", new Object[0])));
            } else {
                msgElem = (TextComponent)msgElem.clickEvent(ClickEvent.of(ClickEvent.Action.SUGGEST_COMMAND, list + " " + path));
                msgElem = (TextComponent)msgElem.hoverEvent(HoverEvent.of(HoverEvent.Action.SHOW_TEXT, Caption.of("worldedit.schematic.list", new Object[0])));
            }
            msg.append(msgElem);
            if (type == UtilityCommands.URIType.FILE) {
                long filesize = 0L;
                try {
                    filesize = Files.size(Paths.get(dir.getAbsolutePath() + File.separator + (String)(playerFolder ? uuid.toString() + File.separator : "") + path, new String[0]));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                TextComponent sizeElem = TextComponent.of(String.format(" (%.1f kb)", (double)filesize / 1000.0), TextColor.GRAY);
                msg.append(sizeElem);
            }
            return msg.create();
        });
        long totalBytes = 0L;
        File parentDir = new File(dir.getAbsolutePath() + (String)(playerFolder ? File.separator + uuid.toString() : ""));
        try {
            List<File> toAddUp = SchematicCommands.getFiles(parentDir, null, null);
            if (toAddUp != null && toAddUp.size() != 0) {
                for (File schem : toAddUp) {
                    if (!schem.getName().endsWith(".schem") && !schem.getName().endsWith(".schematic")) continue;
                    totalBytes += Files.size(Paths.get(schem.getAbsolutePath(), new String[0]));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Object headerBytesElem = String.format("%.1fkb", (double)totalBytes / 1000.0);
        if (Settings.settings().PATHS.PER_PLAYER_SCHEMATICS && actor.getLimit().SCHEM_FILE_SIZE_LIMIT > -1) {
            headerBytesElem = (String)headerBytesElem + String.format(" / %dkb", actor.getLimit().SCHEM_FILE_SIZE_LIMIT);
        }
        if (Settings.settings().PATHS.PER_PLAYER_SCHEMATICS) {
            fullHeader = "| My Schematics: " + (String)headerBytesElem + " |";
            paginationBox = PaginationBox.fromComponents(fullHeader, pageCommand, components);
            actor.print(paginationBox.create(page));
        } else {
            fullHeader = "| Schematics: " + (String)headerBytesElem + " |";
            paginationBox = PaginationBox.fromComponents(fullHeader, pageCommand, components);
            actor.print(paginationBox.create(page));
        }
    }

    private static class SchematicSaveTask
    extends SchematicOutputTask<Void> {
        private final Actor actor;
        private File file;
        private final boolean overwrite;
        private final File rootDir;

        SchematicSaveTask(Actor actor, File file, File rootDir, ClipboardFormat format, ClipboardHolder holder, boolean overwrite) {
            super(actor, format, holder);
            this.actor = actor;
            this.file = file;
            this.overwrite = overwrite;
            this.rootDir = rootDir;
        }

        @Override
        public Void call() throws Exception {
            List<File> toAddUp;
            Clipboard clipboard = this.holder.getClipboard();
            Transform transform = MutatingOperationTransformHolder.transform(this.holder.getTransform());
            boolean checkFilesize = Settings.settings().PATHS.PER_PLAYER_SCHEMATICS && this.actor.getLimit().SCHEM_FILE_SIZE_LIMIT > -1;
            double directorysizeKb = 0.0;
            String curFilepath = this.file.getAbsolutePath();
            String SCHEMATIC_NAME = this.file.getName();
            double oldKbOverwritten = 0.0;
            int numFiles = -1;
            if (checkFilesize) {
                toAddUp = SchematicCommands.getFiles(this.rootDir, null, null);
                if (toAddUp != null && toAddUp.size() != 0) {
                    for (File child : toAddUp) {
                        if (!child.getName().endsWith(".schem") && !child.getName().endsWith(".schematic")) continue;
                        directorysizeKb += (double)Files.size(Paths.get(child.getAbsolutePath(), new String[0])) / 1000.0;
                        ++numFiles;
                    }
                }
                if (this.overwrite) {
                    oldKbOverwritten = (double)Files.size(Paths.get(this.file.getAbsolutePath(), new String[0])) / 1000.0;
                    int iter = 1;
                    while (new File(curFilepath + "." + iter + "." + this.format.getPrimaryFileExtension()).exists()) {
                        ++iter;
                    }
                    this.file = new File(curFilepath + "." + iter + "." + this.format.getPrimaryFileExtension());
                }
            }
            if (Settings.settings().PATHS.PER_PLAYER_SCHEMATICS && this.actor.getLimit().SCHEM_FILE_NUM_LIMIT > -1) {
                int limit;
                if (numFiles == -1) {
                    numFiles = 0;
                    toAddUp = SchematicCommands.getFiles(this.rootDir, null, null);
                    if (toAddUp != null && toAddUp.size() != 0) {
                        for (File child : toAddUp) {
                            if (!child.getName().endsWith(".schem") && !child.getName().endsWith(".schematic")) continue;
                            ++numFiles;
                        }
                    }
                }
                if (numFiles >= (limit = this.actor.getLimit().SCHEM_FILE_NUM_LIMIT)) {
                    TextComponent noSlotsErr = TextComponent.of(String.format("You have " + numFiles + "/" + limit + " saved schematics. Delete some to save this one!", TextColor.RED));
                    LOGGER.info(this.actor.getName() + " failed to save " + this.file.getCanonicalPath() + " - too many schematics!");
                    throw new WorldEditException(noSlotsErr){};
                }
            }
            Clipboard target = transform.isIdentity() ? clipboard : clipboard.transform(transform);
            try (Closer closer = Closer.create();){
                FileOutputStream fos = closer.register(new FileOutputStream(this.file));
                BufferedOutputStream bos = closer.register(new BufferedOutputStream(fos));
                ClipboardWriter writer = closer.register(this.format.getWriter(bos));
                URI uri = null;
                if (this.holder instanceof URIClipboardHolder) {
                    uri = ((URIClipboardHolder)this.holder).getURI(clipboard);
                }
                if (new ActorSaveClipboardEvent(this.actor, clipboard, uri, this.file.toURI()).call()) {
                    writer.write(target);
                    closer.close();
                    double filesizeKb = (double)Files.size(Paths.get(this.file.getAbsolutePath(), new String[0])) / 1000.0;
                    TextComponent filesizeNotif = TextComponent.of(SCHEMATIC_NAME + " size: " + String.format("%.1f", filesizeKb) + "kb", TextColor.GRAY);
                    this.actor.print(filesizeNotif);
                    if (checkFilesize) {
                        double curKb = filesizeKb + directorysizeKb;
                        int allocatedKb = this.actor.getLimit().SCHEM_FILE_SIZE_LIMIT;
                        if (this.overwrite) {
                            curKb -= oldKbOverwritten;
                        }
                        if (curKb > (double)allocatedKb) {
                            this.file.delete();
                            TextComponent notEnoughKbErr = TextComponent.of("You're about to be at " + String.format("%.1f", curKb) + "kb of schematics. (" + String.format("%dkb", allocatedKb) + " available) Delete some first to save this one!", TextColor.RED);
                            LOGGER.info(this.actor.getName() + " failed to save " + SCHEMATIC_NAME + " - not enough space!");
                            throw new WorldEditException(notEnoughKbErr){};
                        }
                        if (this.overwrite) {
                            new File(curFilepath).delete();
                            this.file.renameTo(new File(curFilepath));
                        } else {
                            ++numFiles;
                        }
                        TextComponent kbRemainingNotif = TextComponent.of("You have " + String.format("%.1f", (double)allocatedKb - curKb) + "kb left for schematics.", TextColor.GRAY);
                        this.actor.print(kbRemainingNotif);
                    }
                    if (Settings.settings().PATHS.PER_PLAYER_SCHEMATICS && this.actor.getLimit().SCHEM_FILE_NUM_LIMIT > -1) {
                        TextComponent slotsRemainingNotif = TextComponent.of("You have " + (this.actor.getLimit().SCHEM_FILE_NUM_LIMIT - numFiles) + " schematic file slots left.", TextColor.GRAY);
                        this.actor.print(slotsRemainingNotif);
                    }
                    LOGGER.info(this.actor.getName() + " saved " + this.file.getCanonicalPath());
                } else {
                    this.actor.print(Caption.of("fawe.cancel.reason.manual", new Object[0]));
                }
            }
            return null;
        }
    }

    private static class SchematicShareTask
    extends SchematicOutputTask<Consumer<Actor>> {
        private final Actor actor;
        private final String name;
        private final ClipboardShareDestination destination;

        SchematicShareTask(Actor actor, ClipboardHolder holder, ClipboardShareDestination destination, ClipboardFormat format, String name) {
            super(actor, format, holder);
            this.actor = actor;
            this.name = name;
            this.destination = destination;
        }

        @Override
        public Consumer<Actor> call() throws Exception {
            ClipboardShareMetadata metadata = new ClipboardShareMetadata(this.format, this.actor.getName(), (String)(this.name == null ? this.actor.getName() + "-" + System.currentTimeMillis() : this.name));
            return this.destination.share(metadata, this::writeToOutputStream);
        }
    }

    private static class SchematicPaginationBox
    extends PaginationBox {
        private final String prefix;
        private final File[] files;

        SchematicPaginationBox(String rootDir, File[] files, String pageCommand) {
            super("worldedit.schematic.available", pageCommand);
            this.prefix = rootDir == null ? "" : rootDir;
            this.files = files;
        }

        @Override
        public Component getComponent(int number) {
            Preconditions.checkArgument((number < this.files.length && number >= 0 ? 1 : 0) != 0);
            File file = this.files[number];
            Multimap<String, ClipboardFormat> exts = ClipboardFormats.getFileExtensionMap();
            String format = exts.get((Object)com.google.common.io.Files.getFileExtension((String)file.getName())).stream().findFirst().map(ClipboardFormat::getName).orElse("Unknown");
            boolean inRoot = file.getParentFile().getName().equals(this.prefix);
            String path = inRoot ? file.getName() : file.getPath().split(Pattern.quote(this.prefix + File.separator))[1];
            return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder().content("").append(((TranslatableComponent)TranslatableComponent.of("worldedit.schematic.load.symbol").clickEvent(ClickEvent.of(ClickEvent.Action.RUN_COMMAND, "/schem load \"" + path + "\""))).hoverEvent(HoverEvent.of(HoverEvent.Action.SHOW_TEXT, TranslatableComponent.of("worldedit.schematic.click-to-load"))))).append((Component)TextComponent.space())).append(TextComponent.of(path).hoverEvent(HoverEvent.of(HoverEvent.Action.SHOW_TEXT, TextComponent.of(format))))).build();
        }

        @Override
        public int getComponentsSize() {
            return this.files.length;
        }
    }

    private static class SchematicListTask
    implements Callable<Component> {
        private final String prefix;
        private final int sortType;
        private final int page;
        private final File rootDir;
        private final String pageCommand;
        private final String filter;
        private final String formatName;

        SchematicListTask(String prefix, int sortType, int page, String pageCommand, String filter, String formatName) {
            this.prefix = prefix;
            this.sortType = sortType;
            this.page = page;
            this.rootDir = WorldEdit.getInstance().getWorkingDirectoryFile(prefix);
            this.pageCommand = pageCommand;
            this.filter = filter;
            this.formatName = formatName;
        }

        @Override
        public Component call() throws Exception {
            ClipboardFormat format = ClipboardFormats.findByAlias(this.formatName);
            List<File> fileList = SchematicCommands.getFiles(this.rootDir, this.filter, format);
            if (fileList == null || fileList.isEmpty()) {
                return ErrorFormat.wrap("No schematics found.");
            }
            File[] files = new File[fileList.size()];
            fileList.toArray(files);
            Arrays.sort(files, (f1, f2) -> {
                int res;
                if (this.sortType == 0) {
                    int p = f1.getParent().compareTo(f2.getParent());
                    res = p == 0 ? f1.getName().compareTo(f2.getName()) : p;
                } else {
                    res = Long.compare(f1.lastModified(), f2.lastModified());
                    if (this.sortType == 1) {
                        res = -res;
                    }
                }
                return res;
            });
            SchematicPaginationBox paginationBox = new SchematicPaginationBox(this.prefix, files, this.pageCommand);
            return paginationBox.create(this.page);
        }
    }

    private static abstract class SchematicOutputTask<T>
    implements Callable<T> {
        protected final Actor actor;
        protected final ClipboardFormat format;
        protected final ClipboardHolder holder;

        SchematicOutputTask(Actor actor, ClipboardFormat format, ClipboardHolder holder) {
            this.actor = actor;
            this.format = format;
            this.holder = holder;
        }

        protected void writeToOutputStream(OutputStream outputStream) throws IOException, WorldEditException {
            Clipboard clipboard = this.holder.getClipboard();
            Transform transform = MutatingOperationTransformHolder.transform(this.holder.getTransform());
            Clipboard target = clipboard.transform(transform);
            try (Closer closer = Closer.create();){
                OutputStream stream = closer.register(outputStream);
                BufferedOutputStream bos = closer.register(new BufferedOutputStream(stream));
                ClipboardWriter writer = closer.register(this.format.getWriter(bos));
                writer.write(target);
            }
        }
    }

    private static class SchematicLoadTask
    implements Callable<ClipboardHolder> {
        private final Actor actor;
        private final File file;
        private final ClipboardFormat format;

        SchematicLoadTask(Actor actor, File file, ClipboardFormat format) {
            this.actor = actor;
            this.file = file;
            this.format = format;
        }

        @Override
        public ClipboardHolder call() throws Exception {
            try (Closer closer = Closer.create();){
                FileInputStream fis = closer.register(new FileInputStream(this.file));
                BufferedInputStream bis = closer.register(new BufferedInputStream(fis));
                ClipboardReader reader = closer.register(this.format.getReader(bis));
                Clipboard clipboard = reader.read();
                LOGGER.info(this.actor.getName() + " loaded " + this.file.getCanonicalPath());
                ClipboardHolder clipboardHolder = new ClipboardHolder(clipboard);
                return clipboardHolder;
            }
        }
    }
}

