/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.storage;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.world.DataException;
import com.sk89q.worldedit.world.DataFixer;
import com.sk89q.worldedit.world.chunk.AnvilChunk;
import com.sk89q.worldedit.world.chunk.AnvilChunk13;
import com.sk89q.worldedit.world.chunk.AnvilChunk15;
import com.sk89q.worldedit.world.chunk.AnvilChunk16;
import com.sk89q.worldedit.world.chunk.AnvilChunk17;
import com.sk89q.worldedit.world.chunk.AnvilChunk18;
import com.sk89q.worldedit.world.chunk.Chunk;
import com.sk89q.worldedit.world.chunk.OldChunk;
import com.sk89q.worldedit.world.storage.ChunkStoreException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Supplier;
import org.enginehub.linbus.tree.LinCompoundTag;

public class ChunkStoreHelper {
    public static CompoundTag readCompoundTag(ChunkDataInputSupplier input) throws DataException, IOException {
        try (InputStream stream = input.openInputStream();){
            CompoundTag compoundTag;
            try (NBTInputStream nbt = new NBTInputStream(stream);){
                Tag<?, ?> tag = nbt.readNamedTag().getTag();
                if (!(tag instanceof CompoundTag)) {
                    throw new ChunkStoreException("CompoundTag expected for chunk; got " + tag.getClass().getName());
                }
                compoundTag = (CompoundTag)tag;
            }
            return compoundTag;
        }
    }

    public static Chunk getChunk(CompoundTag rootTag) throws DataException {
        return ChunkStoreHelper.getChunk(rootTag, () -> null);
    }

    public static Chunk getChunk(CompoundTag rootTag, Supplier<CompoundTag> entitiesTag) throws DataException {
        DataFixer dataFixer;
        int dataVersion = rootTag.getInt("DataVersion");
        if (dataVersion == 0) {
            dataVersion = -1;
        }
        Platform platform = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.WORLD_EDITING);
        int currentDataVersion = platform.getDataVersion();
        if ((dataVersion > 0 || ChunkStoreHelper.hasLevelSections(rootTag)) && dataVersion < currentDataVersion && (dataFixer = platform.getDataFixer()) != null) {
            rootTag = new CompoundTag(dataFixer.fixUp(DataFixer.FixTypes.CHUNK, (LinCompoundTag)rootTag.toLinTag(), dataVersion));
            dataVersion = currentDataVersion;
        }
        if (dataVersion >= 2860) {
            return new AnvilChunk18(rootTag, () -> {
                CompoundTag compoundTag = (CompoundTag)entitiesTag.get();
                if (compoundTag == null) {
                    return null;
                }
                return (LinCompoundTag)compoundTag.toLinTag();
            });
        }
        Object children = rootTag.getValue();
        CompoundTag tag = null;
        for (Map.Entry entry : children.entrySet()) {
            if (!((String)entry.getKey()).equals("Level")) continue;
            if (entry.getValue() instanceof CompoundTag) {
                tag = (CompoundTag)entry.getValue();
                break;
            }
            throw new ChunkStoreException("CompoundTag expected for 'Level'; got " + ((Tag)entry.getValue()).getClass().getName());
        }
        if (tag == null) {
            throw new ChunkStoreException("Missing root 'Level' tag");
        }
        if (dataVersion >= 2724) {
            return new AnvilChunk17(tag, entitiesTag);
        }
        if (dataVersion >= 2566) {
            return new AnvilChunk16(tag);
        }
        if (dataVersion >= 2225) {
            return new AnvilChunk15(tag);
        }
        if (dataVersion >= 1519) {
            return new AnvilChunk13(tag);
        }
        Object tags = tag.getValue();
        if (tags.containsKey("Sections")) {
            return new AnvilChunk(tag);
        }
        return new OldChunk(tag);
    }

    private static boolean hasLevelSections(CompoundTag rootTag) {
        Object children = rootTag.getValue();
        Tag levelTag = (Tag)children.get("Level");
        if (levelTag instanceof CompoundTag) {
            return ((CompoundTag)levelTag).getValue().containsKey("Sections");
        }
        return false;
    }

    private ChunkStoreHelper() {
    }

    @FunctionalInterface
    public static interface ChunkDataInputSupplier {
        public InputStream openInputStream() throws DataException, IOException;
    }
}

