/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.regions.plotsquared;

import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.regions.FaweMask;
import com.fastasyncworldedit.core.regions.FaweMaskManager;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.flag.implementations.NoWorldeditFlag;
import com.plotsquared.core.util.WEManager;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.AbstractRegion;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionIntersection;
import com.sk89q.worldedit.world.World;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;

public class PlotSquaredFeature
extends FaweMaskManager {
    private static final Logger LOGGER = LogManagerCompat.getLogger();

    public PlotSquaredFeature() {
        super("PlotSquared");
        LOGGER.info("Optimizing PlotSquared");
        if (Settings.FAWE_Components.FAWE_HOOK) {
            Settings.Enabled_Components.WORLDEDIT_RESTRICTIONS = false;
            if (Settings.PLATFORM.toLowerCase(Locale.ROOT).startsWith("bukkit")) {
                // empty if block
            }
        }
    }

    public boolean isAllowed(Player player, Plot plot, FaweMaskManager.MaskType type, boolean notify) {
        if (plot == null) {
            return false;
        }
        UUID uid = player.getUniqueId();
        if (((Boolean)plot.getFlag(NoWorldeditFlag.class)).booleanValue()) {
            if (notify) {
                player.print(Caption.of("fawe.cancel.reason.no.region.reason", Caption.of("fawe.cancel.reason.no.region.plot.noworldeditflag", new Object[0])));
            }
            return false;
        }
        if (plot.isOwner(uid) || player.hasPermission("fawe.plotsquared.admin")) {
            return true;
        }
        if (type != FaweMaskManager.MaskType.MEMBER) {
            if (notify) {
                player.print(Caption.of("fawe.cancel.reason.no.region.reason", Caption.of("fawe.cancel.reason.no.region.plot.owner.only", new Object[0])));
            }
            return false;
        }
        if (plot.getTrusted().contains(uid) || plot.getTrusted().contains(DBFunc.EVERYONE)) {
            return true;
        }
        if (plot.getMembers().contains(uid) || plot.getMembers().contains(DBFunc.EVERYONE)) {
            if (!player.hasPermission("fawe.plotsquared.member")) {
                if (notify) {
                    player.print(Caption.of("fawe.cancel.reason.no.region.reason", Caption.of("fawe.error.no-perm", "fawe.plotsquared.member")));
                }
                return false;
            }
            if (!plot.getOwners().isEmpty() && plot.getOwners().stream().anyMatch(this::playerOnline)) {
                return true;
            }
            if (notify) {
                player.print(Caption.of("fawe.cancel.reason.no.region.reason", Caption.of("fawe.cancel.reason.no.region.plot.owner.offline", new Object[0])));
            }
            return false;
        }
        if (notify) {
            player.print(Caption.of("fawe.cancel.reason.no.region.reason", Caption.of("fawe.cancel.reason.no.region.not.added", new Object[0])));
        }
        return false;
    }

    private boolean playerOnline(UUID uuid) {
        if (uuid == null) {
            return false;
        }
        org.bukkit.entity.Player player = Bukkit.getPlayer((UUID)uuid);
        return player != null && player.isOnline();
    }

    @Override
    public FaweMask getMask(Player player, FaweMaskManager.MaskType type, boolean isWhitelist) {
        return this.getMask(player, type, isWhitelist, true);
    }

    @Override
    public FaweMask getMask(Player player, FaweMaskManager.MaskType type, boolean isWhitelist, boolean notify) {
        AbstractRegion maskedRegion;
        int max;
        Set regions;
        PlotPlayer pp = PlotPlayer.from((Object)BukkitAdapter.adapt(player));
        if (pp == null) {
            return null;
        }
        Plot plot = pp.getCurrentPlot();
        if (this.isAllowed(player, plot, type, notify)) {
            regions = plot.getRegions();
        } else {
            CuboidRegion region;
            plot = null;
            regions = WEManager.getMask((PlotPlayer)pp);
            if (regions.size() == 1 && (region = (CuboidRegion)regions.iterator().next()).getMinimumPoint().x() == Integer.MIN_VALUE && region.getMaximumPoint().x() == Integer.MAX_VALUE) {
                regions.clear();
            }
        }
        if (regions.isEmpty()) {
            return null;
        }
        PlotArea area = pp.getApplicablePlotArea();
        Plot finalPlot = plot;
        if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone((Plot)finalPlot) || regions.isEmpty()) {
            return null;
        }
        World world = player.getWorld();
        int min = area != null ? area.getMinBuildHeight() : world.getMinY();
        int n = max = area != null ? Math.min(world.getMaxY(), area.getMaxBuildHeight() - 1) : world.getMaxY();
        if (regions.size() == 1) {
            CuboidRegion region = (CuboidRegion)regions.iterator().next();
            BlockVector3 pos1 = BlockVector3.at(region.getMinimumX(), min, region.getMinimumZ());
            BlockVector3 pos2 = BlockVector3.at(region.getMaximumX(), max, region.getMaximumZ());
            maskedRegion = new CuboidRegion(pos1, pos2);
        } else {
            List<Region> weRegions = regions.stream().map(r -> new CuboidRegion(world, BlockVector3.at(r.getMinimumX(), min, r.getMinimumZ()), BlockVector3.at(r.getMaximumX(), max, r.getMaximumZ()))).collect(Collectors.toList());
            maskedRegion = new RegionIntersection(world, weRegions);
        }
        if (plot == null) {
            return new FaweMask(maskedRegion);
        }
        return new PlotSquaredMask(maskedRegion, finalPlot);
    }

    private final class PlotSquaredMask
    extends FaweMask {
        private final Plot plot;
        private final WeakReference<Set<Plot>> connectedPlots;
        private final boolean singlePlot;

        private PlotSquaredMask(@Nonnull Region region, Plot plot) {
            super(region);
            this.plot = Objects.requireNonNull(plot);
            Set connected = plot.getConnectedPlots();
            this.connectedPlots = new WeakReference<Set>(connected);
            this.singlePlot = connected.size() == 1;
        }

        @Override
        public boolean isValid(Player player, FaweMaskManager.MaskType type, boolean notify) {
            if (!this.connectedPlots.refersTo(this.plot.getConnectedPlots()) && (!this.singlePlot || this.plot.getConnectedPlots().size() > 1) || Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone((Plot)this.plot)) {
                return false;
            }
            return PlotSquaredFeature.this.isAllowed(player, this.plot, type, notify);
        }
    }
}

