/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extension.factory.parser;

import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.extension.factory.parser.AliasedParser;
import com.fastasyncworldedit.core.util.StringMan;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.platform.PlatformCommandManager;
import com.sk89q.worldedit.internal.registry.InputParser;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class FaweParser<T>
extends InputParser<T>
implements AliasedParser {
    protected FaweParser(WorldEdit worldEdit) {
        super(worldEdit);
    }

    public static List<Map.Entry<ParseEntry, List<String>>> parse(String toParse) throws InputParseException {
        int i;
        ArrayList<Map.Entry<ParseEntry, List<String>>> keys = new ArrayList<Map.Entry<ParseEntry, List<String>>>();
        ArrayList<String> inputs = new ArrayList<String>();
        ArrayList<Boolean> and = new ArrayList<Boolean>();
        int last = 0;
        boolean expression = false;
        block4: for (i = 0; i < ((String)toParse).length(); ++i) {
            char c = ((String)toParse).charAt(i);
            switch (c) {
                case ' ': 
                case '&': 
                case ',': {
                    if (expression) continue block4;
                    String result = ((String)toParse).substring(last, i);
                    if (result.isEmpty()) {
                        throw new InputParseException(Caption.of("fawe.error.parse.invalid-dangling-character", Character.valueOf(c)));
                    }
                    inputs.add(result);
                    and.add(c == '&' || c == ' ');
                    last = i + 1;
                    continue block4;
                }
                case '=': {
                    expression = true;
                    continue block4;
                }
                default: {
                    if (c != '[') continue block4;
                    int next = StringMan.findMatchingBracket((CharSequence)toParse, i);
                    if (next != -1) {
                        i = next;
                    } else {
                        toParse = (String)toParse + "]";
                        i = ((String)toParse).length();
                    }
                    expression = false;
                }
            }
        }
        inputs.add(((String)toParse).substring(last));
        for (i = 0; i < inputs.size(); ++i) {
            int startPos;
            String full;
            String command = full = (String)inputs.get(i);
            ArrayList<String> args = new ArrayList<String>();
            while (!command.isEmpty() && command.charAt(command.length() - 1) == ']' && (startPos = StringMan.findMatchingBracket(command, command.length() - 1)) != -1) {
                String arg = command.substring(startPos + 1, command.length() - 1);
                args.add(arg);
                command = full.substring(0, startPos);
            }
            Collections.reverse(args);
            ParseEntry entry = new ParseEntry(full, command, i > 0 ? (Boolean)and.get(i - 1) : false);
            keys.add(new AbstractMap.SimpleEntry(entry, args));
        }
        return keys;
    }

    protected PlatformCommandManager getPlatform() {
        return PlatformCommandManager.getInstance();
    }

    public static class ParseEntry {
        private final boolean and;
        private final String input;
        private final String full;

        public ParseEntry(String full, String input, boolean type) {
            this.full = full;
            this.input = input;
            this.and = type;
        }

        public boolean isAnd() {
            return this.and;
        }

        public String getInput() {
            return this.input;
        }

        public String getFull() {
            return this.full;
        }

        public String toString() {
            return this.input + " | " + this.and;
        }
    }
}

