/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extent.filter;

import com.fastasyncworldedit.core.extent.filter.block.DelegateFilter;
import com.fastasyncworldedit.core.extent.filter.block.FilterBlock;
import com.fastasyncworldedit.core.internal.simd.SimdSupport;
import com.fastasyncworldedit.core.internal.simd.VectorFacade;
import com.fastasyncworldedit.core.internal.simd.VectorizedFilter;
import com.fastasyncworldedit.core.internal.simd.VectorizedMask;
import com.fastasyncworldedit.core.queue.Filter;
import com.sk89q.worldedit.function.mask.AbstractExtentMask;
import com.sk89q.worldedit.function.mask.Mask;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.incubator.vector.ShortVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorMask;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;

public class MaskFilter<T extends Filter>
extends DelegateFilter<T> {
    final Mask mask;
    final AtomicInteger changes;

    public MaskFilter(T other, Mask root) {
        this(other, root, new AtomicInteger());
    }

    public MaskFilter(T other, Mask root, AtomicInteger changes) {
        super(other);
        this.mask = root;
        this.changes = changes;
    }

    @Override
    public void applyBlock(FilterBlock block) {
        if (this.mask instanceof AbstractExtentMask) {
            if (((AbstractExtentMask)this.mask).test(block.getExtent(), block)) {
                this.getParent().applyBlock(block);
                this.changes.incrementAndGet();
            }
        } else if (this.mask.test(block)) {
            this.getParent().applyBlock(block);
            this.changes.incrementAndGet();
        }
    }

    public int getBlocksApplied() {
        return this.changes.get();
    }

    @Override
    public MaskFilter<?> newInstance(Filter other) {
        return new MaskFilter<Filter>(other, this.mask);
    }

    @Override
    public Filter fork() {
        return new MaskFilter<Filter>(this.getParent().fork(), this.mask.copy(), this.changes);
    }

    public static class VectorizedMaskFilter<T extends VectorizedFilter>
    extends MaskFilter<T>
    implements VectorizedFilter {
        private final VectorizedMask vectorizedMask;

        public VectorizedMaskFilter(T other, Mask root) {
            super(other, root);
            this.vectorizedMask = Objects.requireNonNull(SimdSupport.vectorizedTargetMask(root), "invalid vectorizable mask");
        }

        public VectorizedMaskFilter(T other, Mask root, AtomicInteger changes) {
            super(other, root, changes);
            this.vectorizedMask = Objects.requireNonNull(SimdSupport.vectorizedTargetMask(root), "invalid vectorizable mask");
        }

        @Override
        public void applyVector(VectorFacade get, VectorFacade set, VectorMask<Short> mask) {
            VectorizedFilter parent = (VectorizedFilter)this.getParent();
            VectorSpecies species = mask.vectorSpecies();
            VectorMask<Short> masked = this.vectorizedMask.compareVector(set, get, (VectorSpecies<Short>)species);
            ShortVector before = set.getOrZero((VectorSpecies<Short>)masked.vectorSpecies());
            parent.applyVector(get, set, (VectorMask<Short>)mask.and(masked));
            ShortVector after = set.getOrZero((VectorSpecies<Short>)masked.vectorSpecies());
            VectorMask changed = after.compare(VectorOperators.NE, (Vector)before);
            this.changes.getAndAdd(changed.trueCount());
        }

        @Override
        public MaskFilter<?> newInstance(Filter other) {
            if (other instanceof VectorizedFilter) {
                VectorizedFilter o = (VectorizedFilter)other;
                return new VectorizedMaskFilter<VectorizedFilter>(o, this.mask);
            }
            return super.newInstance(other);
        }

        @Override
        public Filter fork() {
            return new VectorizedMaskFilter<VectorizedFilter>((VectorizedFilter)((VectorizedFilter)this.getParent()).fork(), this.mask.copy(), this.changes);
        }
    }
}

