/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.history.change;

import com.sk89q.worldedit.history.change.Change;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface ChangePopulator<C extends Change> {
    public static <C extends Change> ChangePopulator<C> empty() {
        class Empty
        implements ChangePopulator<C> {
            private static final Empty EMPTY = new Empty();

            Empty() {
            }

            @Override
            @NotNull
            public C create() {
                throw new UnsupportedOperationException("empty");
            }

            @Override
            @Nullable
            public C populate(@NotNull C change) {
                return null;
            }

            @Override
            @Nullable
            public C updateOrCreate(@Nullable Change change) {
                return null;
            }

            @Override
            public boolean accepts(Change change) {
                return false;
            }
        }
        return Empty.EMPTY;
    }

    @NotNull
    default public C update(@Nullable Change before) {
        if (this.accepts(before)) {
            return (C)before;
        }
        return this.create();
    }

    @NotNull
    public C create();

    @Nullable
    default public C updateOrCreate(@Nullable Change change) {
        C u = this.update(change);
        return this.populate(u);
    }

    @Nullable
    public C populate(@NotNull C var1);

    @Contract(value="null->false")
    public boolean accepts(Change var1);
}

