/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.math.transform;

import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.transform.CombinedTransform;
import com.sk89q.worldedit.math.transform.Transform;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Function;

public class MutatingOperationTransformHolder<T extends Transform>
implements Transform {
    private final Function<? super T, ? extends T> operation;
    private T transform;

    public MutatingOperationTransformHolder(T transform, Function<? super T, ? extends T> operation) {
        this.transform = transform;
        this.operation = operation;
    }

    public static Transform transform(Transform transform) {
        return MutatingOperationTransformHolder.transform(transform, false);
    }

    public static Transform transform(Transform transform, boolean parallel) {
        MutatingOperationTransformHolder mutatingOperationTransformHolder = transform;
        Objects.requireNonNull(mutatingOperationTransformHolder);
        MutatingOperationTransformHolder mutatingOperationTransformHolder2 = mutatingOperationTransformHolder;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MutatingOperationTransformHolder.class, CombinedTransform.class}, (Object)mutatingOperationTransformHolder2, n)) {
            case 0 -> {
                MutatingOperationTransformHolder mutating = mutatingOperationTransformHolder2;
                if (parallel) {
                    yield mutating.copy().mutate();
                }
                yield mutating.mutate();
            }
            case 1 -> {
                CombinedTransform combined = (CombinedTransform)((Object)mutatingOperationTransformHolder2);
                if (!parallel) {
                    combined.getTransforms().forEach(t -> MutatingOperationTransformHolder.transform(t, false));
                    yield combined;
                }
                yield new CombinedTransform(combined.getTransforms().stream().map(t -> MutatingOperationTransformHolder.transform(t, true)).toList());
            }
            default -> transform;
        };
    }

    public MutatingOperationTransformHolder<T> mutate() {
        if (this.operation != null) {
            this.transform = (Transform)this.operation.apply(this.transform);
        }
        return this;
    }

    @Override
    public boolean isIdentity() {
        return this.transform.isIdentity();
    }

    @Override
    public Vector3 apply(Vector3 input) {
        return this.transform.apply(input);
    }

    @Override
    public Transform inverse() {
        return this.transform.inverse();
    }

    @Override
    public Transform combine(Transform other) {
        return this.transform.combine(other);
    }

    public MutatingOperationTransformHolder<T> copy() {
        Object object;
        T t = this.transform;
        if (t instanceof MutatingOperationTransformHolder) {
            MutatingOperationTransformHolder mutating = (MutatingOperationTransformHolder)t;
            object = mutating.copy();
        } else {
            object = this.transform;
        }
        T transform = object;
        return new MutatingOperationTransformHolder<T>(transform, this.operation);
    }
}

