/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.queue;

import com.fastasyncworldedit.core.extent.processor.heightmap.HeightMapType;
import com.fastasyncworldedit.core.nbt.FaweCompoundTag;
import com.fastasyncworldedit.core.queue.IBlocks;
import com.google.common.base.Supplier;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.OutputExtent;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.enginehub.linbus.tree.LinCompoundTag;

public interface IChunkSet
extends IBlocks,
OutputExtent {
    @Override
    public boolean setBiome(int var1, int var2, int var3, BiomeType var4);

    @Override
    default public boolean setBiome(BlockVector3 position, BiomeType biome) {
        return this.setBiome(position.x(), position.y(), position.z(), biome);
    }

    public <T extends BlockStateHolder<T>> boolean setBlock(int var1, int var2, int var3, T var4);

    public void setBlocks(int var1, char[] var2);

    public boolean isEmpty();

    @Override
    @Deprecated(forRemoval=true, since="2.11.2")
    default public boolean setTile(int x, int y, int z, CompoundTag tile) throws WorldEditException {
        return this.tile(x, y, z, FaweCompoundTag.of((LinCompoundTag)tile.toLinTag()));
    }

    @Override
    public boolean tile(int var1, int var2, int var3, FaweCompoundTag var4);

    @Override
    public void setBlockLight(int var1, int var2, int var3, int var4);

    @Override
    public void setSkyLight(int var1, int var2, int var3, int var4);

    @Override
    public void setHeightMap(HeightMapType var1, int[] var2);

    public void setLightLayer(int var1, char[] var2);

    public void setSkyLightLayer(int var1, char[] var2);

    public void setFullBright(int var1);

    @Deprecated(forRemoval=true, since="2.11.2")
    default public void setEntity(CompoundTag tag) {
        this.entity(FaweCompoundTag.of((Supplier<? extends LinCompoundTag>)((Supplier)tag::toLinTag)));
    }

    public void entity(FaweCompoundTag var1);

    public void removeEntity(UUID var1);

    public Set<UUID> getEntityRemoves();

    public BiomeType[][] getBiomes();

    default public boolean hasBiomes() {
        return this.getBiomes() != null;
    }

    public char[][] getLight();

    public char[][] getSkyLight();

    default public boolean hasLight() {
        return this.getLight() != null;
    }

    default public void setFastMode(boolean fastMode) {
    }

    default public boolean isFastMode() {
        return false;
    }

    default public void setBitMask(int bitMask) {
    }

    @Override
    default public int getBitMask() {
        return -1;
    }

    default public Map<HeightMapType, int[]> getHeightMaps() {
        return new EnumMap<HeightMapType, int[]>(HeightMapType.class);
    }

    @Override
    public IChunkSet reset();

    @Override
    @Nullable
    default public Operation commit() {
        return null;
    }

    public boolean hasBiomes(int var1);

    @Nonnull
    default public IChunkSet createCopy() {
        return this;
    }

    public void setSideEffectSet(@Nonnull SideEffectSet var1);

    @Nonnull
    public SideEffectSet getSideEffectSet();
}

