/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.util;

import com.fastasyncworldedit.core.queue.implementation.ParallelQueueExtent;
import com.fastasyncworldedit.core.queue.implementation.SingleThreadQueueExtent;
import com.fastasyncworldedit.core.util.ReflectionUtils;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.world.World;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;

public class ExtentTraverser<T extends Extent> {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private final T root;
    private final ExtentTraverser<T> parent;

    public ExtentTraverser(@Nonnull T root) {
        this(root, null);
    }

    public ExtentTraverser(@Nonnull T root, ExtentTraverser<T> parent) {
        this.root = root;
        this.parent = parent;
    }

    @Nullable
    public static World getWorldFromExtent(Extent extent) {
        if (extent.isWorld()) {
            return (World)extent;
        }
        if (extent instanceof EditSession) {
            EditSession session = (EditSession)extent;
            return session.getWorld();
        }
        if (extent instanceof SingleThreadQueueExtent) {
            SingleThreadQueueExtent stqe = (SingleThreadQueueExtent)extent;
            return stqe.getWorld();
        }
        if (extent instanceof ParallelQueueExtent) {
            ParallelQueueExtent pqe = (ParallelQueueExtent)extent;
            return ((SingleThreadQueueExtent)pqe.getExtent()).getWorld();
        }
        return new ExtentTraverser<Extent>(extent).findAndGet(World.class);
    }

    public boolean exists() {
        return this.root != null;
    }

    @Nullable
    public T get() {
        return this.root;
    }

    public boolean setNext(T next) {
        try {
            Field field = AbstractDelegateExtent.class.getDeclaredField("extent");
            ReflectionUtils.setFailsafeFieldValue(field, this.root, next);
            return true;
        }
        catch (Throwable e) {
            LOGGER.error((Object)e);
            return false;
        }
    }

    public ExtentTraverser<T> last() {
        ExtentTraverser<T> last = this;
        for (ExtentTraverser<T> traverser = this; traverser != null && traverser.get() instanceof AbstractDelegateExtent; traverser = traverser.next()) {
            last = traverser;
        }
        return last;
    }

    @Nullable
    public <U extends Extent> U findAndGet(Class<U> clazz) {
        ExtentTraverser<U> traverser = this.find(clazz);
        return traverser != null ? (U)traverser.get() : null;
    }

    public <U extends Extent> ExtentTraverser<U> find(Class<U> clazz) {
        try {
            for (ExtentTraverser<T> value = this; value != null; value = value.next()) {
                if (!clazz.isAssignableFrom(value.root.getClass())) continue;
                return value;
            }
            return null;
        }
        catch (Throwable e) {
            LOGGER.error((Object)e);
            return null;
        }
    }

    public <U extends Extent> ExtentTraverser<U> find(Object object) {
        try {
            for (ExtentTraverser<T> value = this; value != null; value = value.next()) {
                if (value.root != object) continue;
                return value;
            }
            return null;
        }
        catch (Throwable e) {
            LOGGER.error((Object)e);
            return null;
        }
    }

    public ExtentTraverser<T> previous() {
        return this.parent;
    }

    public ExtentTraverser<T> next() {
        try {
            T t = this.root;
            if (t instanceof AbstractDelegateExtent) {
                AbstractDelegateExtent abstractDelegateExtent = (AbstractDelegateExtent)t;
                Extent value = abstractDelegateExtent.getExtent();
                if (value == null) {
                    return null;
                }
                return new ExtentTraverser<Extent>(value, this);
            }
            return null;
        }
        catch (Throwable e) {
            LOGGER.error((Object)e);
            return null;
        }
    }

    public static void printNestedExtents(Extent extent) {
        String nested = ExtentTraverser.printNestedExtent(new StringBuilder("Extent tree:"), new ExtentTraverser<Extent>(extent), 0).toString();
        LOGGER.info(nested);
    }

    private static StringBuilder printNestedExtent(StringBuilder builder, ExtentTraverser<?> traverser, int depth) {
        if (traverser == null || !traverser.exists()) {
            return builder;
        }
        String indent = "  ".repeat(Math.max(0, depth));
        Object extent = traverser.get();
        builder.append("\n").append(indent).append("- ").append(extent.getClass().getSimpleName());
        ExtentTraverser.printNestedExtent(builder, traverser.next(), depth + 1);
        return builder;
    }
}

