/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.ext.fawe.v1_20_R2;

import com.fastasyncworldedit.core.internal.exception.FaweException;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.Refraction;
import com.sk89q.worldedit.bukkit.adapter.ext.fawe.v1_20_R2.PaperweightAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R2.PaperweightFaweAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import org.apache.logging.log4j.Logger;
import org.enginehub.linbus.tree.LinTag;
import org.jetbrains.annotations.Nullable;

public class PaperweightServerLevelDelegateProxy
implements InvocationHandler {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private final Extent editSession;
    private final WorldServer serverLevel;
    private final PaperweightFaweAdapter adapter = (PaperweightFaweAdapter)WorldEditPlugin.getInstance().getBukkitImplAdapter();
    private final boolean errorOnPassthrough;

    private PaperweightServerLevelDelegateProxy(EditSession editSession, WorldServer serverLevel, PaperweightAdapter adapter) {
        this.editSession = editSession;
        this.serverLevel = serverLevel;
        this.errorOnPassthrough = false;
    }

    public static GeneratorAccessSeed newInstance(EditSession editSession, WorldServer serverLevel, PaperweightAdapter adapter) {
        return (GeneratorAccessSeed)Proxy.newProxyInstance(serverLevel.getClass().getClassLoader(), serverLevel.getClass().getInterfaces(), (InvocationHandler)new PaperweightServerLevelDelegateProxy(editSession, serverLevel, adapter));
    }

    private PaperweightServerLevelDelegateProxy(Extent extent, WorldServer serverLevel, boolean errorOnPassthrough) {
        this.editSession = extent;
        this.serverLevel = serverLevel;
        this.errorOnPassthrough = errorOnPassthrough;
    }

    public static GeneratorAccessSeed newInstance(Extent extent, WorldServer serverLevel, boolean errorOnPassthrough) {
        return (GeneratorAccessSeed)Proxy.newProxyInstance(serverLevel.getClass().getClassLoader(), serverLevel.getClass().getInterfaces(), (InvocationHandler)new PaperweightServerLevelDelegateProxy(extent, serverLevel, errorOnPassthrough));
    }

    @Nullable
    private TileEntity getBlockEntity(BlockPosition blockPos) {
        TileEntity tileEntity = this.serverLevel.l(blockPos).c_(blockPos);
        if (tileEntity == null) {
            return null;
        }
        TileEntity newEntity = tileEntity.u().a(blockPos, this.getBlockState(blockPos));
        newEntity.a((NBTTagCompound)this.adapter.fromNativeLin((LinTag)this.editSession.getFullBlock(blockPos.u(), blockPos.v(), blockPos.w()).getNbtReference().getValue()));
        return newEntity;
    }

    private IBlockData getBlockState(BlockPosition blockPos) {
        return this.adapter.adapt(this.editSession.getBlock(blockPos.u(), blockPos.v(), blockPos.w()));
    }

    private boolean setBlock(BlockPosition blockPos, IBlockData blockState) {
        try {
            return this.editSession.setBlock(blockPos.u(), blockPos.v(), blockPos.w(), this.adapter.adapt(blockState));
        }
        catch (MaxChangedBlocksException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean removeBlock(BlockPosition blockPos, boolean bl) {
        try {
            return this.editSession.setBlock(blockPos.u(), blockPos.v(), blockPos.w(), BlockTypes.AIR.getDefaultState());
        }
        catch (MaxChangedBlocksException e) {
            throw new RuntimeException(e);
        }
    }

    private Fluid getFluidState(BlockPosition pos) {
        return this.getBlockState(pos).u();
    }

    private boolean isWaterAt(BlockPosition pos) {
        return this.getBlockState(pos).u().a(TagsFluid.a);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        BlockPosition blockPos;
        Object object;
        String methodName = method.getName();
        if (Refraction.pickName("getBlockState", "a_").equals(methodName) && args.length == 1 && (object = args[0]) instanceof BlockPosition) {
            BlockPosition blockPos2 = (BlockPosition)object;
            return this.getBlockState(blockPos2);
        }
        if (Refraction.pickName("getBlockEntity", "c_").equals(methodName) && args.length == 1 && (object = args[0]) instanceof BlockPosition) {
            BlockPosition blockPos3 = (BlockPosition)object;
            return this.getBlockEntity(blockPos3);
        }
        if ("a".equals(methodName) || "setBlock".equals(methodName) || "removeBlock".equals(methodName) || "destroyBlock".equals(methodName)) {
            Object object2;
            if (args.length >= 2 && (object2 = args[0]) instanceof BlockPosition) {
                blockPos = (BlockPosition)object2;
                object2 = args[1];
                if (object2 instanceof IBlockData) {
                    IBlockData blockState = (IBlockData)object2;
                    return this.setBlock(blockPos, blockState);
                }
            }
            if (args.length >= 2 && (object2 = args[0]) instanceof BlockPosition) {
                BlockPosition blockPos4 = (BlockPosition)object2;
                object2 = args[1];
                if (object2 instanceof Boolean) {
                    Boolean bl = (Boolean)object2;
                    return this.removeBlock(blockPos4, bl);
                }
            }
        }
        if (Refraction.pickName("getFluidState", "b_").equals(methodName) && args.length == 1 && (object = args[0]) instanceof BlockPosition) {
            blockPos = (BlockPosition)object;
            return this.getFluidState(blockPos);
        }
        if (Refraction.pickName("isWaterAt", "z").equals(methodName) && args.length == 1 && (object = args[0]) instanceof BlockPosition) {
            blockPos = (BlockPosition)object;
            return this.isWaterAt(blockPos);
        }
        if (Refraction.pickName("getEntities", "a_").equals(methodName) && args.length == 2 && args[0] instanceof Entity && args[1] instanceof AxisAlignedBB) {
            return new ArrayList();
        }
        if (Refraction.pickName("getRawBrightness", "b").equals(methodName)) {
            return method.invoke((Object)this.serverLevel, args);
        }
        if (Refraction.pickName("getMaxBuildHeight", "al").equals(methodName) && args.length == 0) {
            return method.invoke((Object)this.serverLevel, args);
        }
        if (Refraction.pickName("hasNeighborSignal", "C").equals(methodName) && args.length == 1 && args[0] instanceof BlockPosition) {
            return method.invoke((Object)this.serverLevel, args);
        }
        if (Refraction.pickName("getSignal", "c").equals(methodName) && args.length == 2 && args[0] instanceof BlockPosition && args[1] instanceof EnumDirection) {
            return method.invoke((Object)this.serverLevel, args);
        }
        if (Refraction.pickName("getControlInputSignal", "a").equals(methodName) && args.length == 3 && args[0] instanceof BlockPosition && args[1] instanceof EnumDirection && args[2] instanceof Boolean) {
            return method.invoke((Object)this.serverLevel, args);
        }
        if (Refraction.pickName("getDirectSignal", "a").equals(methodName) && args.length == 2 && args[0] instanceof BlockPosition && args[1] instanceof EnumDirection) {
            return method.invoke((Object)this.serverLevel, args);
        }
        if (this.errorOnPassthrough) {
            LOGGER.error("Attempted passthough of method {}.\nMethod argument types: {}\nMethod argument values: {}\n", (Object)method.getName(), Arrays.stream(args).map(a2 -> a2.getClass().getName()).toList(), Arrays.stream(args).map(Object::toString).toList());
            throw new FaweException("Method required passthrough.");
        }
        return method.invoke((Object)this.serverLevel, args);
    }
}

