/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R3;

import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.math.IntPair;
import com.fastasyncworldedit.core.util.TaskManager;
import com.fastasyncworldedit.core.util.task.RunnableVal;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R3.PaperweightFaweAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R3.PaperweightPlatformAdapter;
import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.internal.wna.WorldNativeAccess;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.world.block.BlockState;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.block.data.CraftBlockData;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.enginehub.linbus.tree.LinCompoundTag;
import org.enginehub.linbus.tree.LinTag;

public class PaperweightFaweWorldNativeAccess
implements WorldNativeAccess<Chunk, IBlockData, BlockPosition> {
    private static final int UPDATE = 1;
    private static final int NOTIFY = 2;
    private static final EnumDirection[] NEIGHBOUR_ORDER = new EnumDirection[]{EnumDirection.f, EnumDirection.e, EnumDirection.a, EnumDirection.b, EnumDirection.c, EnumDirection.d};
    private final PaperweightFaweAdapter paperweightFaweAdapter;
    private final WeakReference<World> level;
    private final AtomicInteger lastTick;
    private final Set<CachedChange> cachedChanges = new HashSet<CachedChange>();
    private final Set<IntPair> cachedChunksToSend = new HashSet<IntPair>();
    private SideEffectSet sideEffectSet;

    public PaperweightFaweWorldNativeAccess(PaperweightFaweAdapter paperweightFaweAdapter, WeakReference<World> level) {
        this.paperweightFaweAdapter = paperweightFaweAdapter;
        this.level = level;
        this.lastTick = new AtomicInteger(MinecraftServer.currentTick);
    }

    private World getLevel() {
        return Objects.requireNonNull((World)this.level.get(), "The reference to the world was lost");
    }

    @Override
    public void setCurrentSideEffectSet(SideEffectSet sideEffectSet) {
        this.sideEffectSet = sideEffectSet;
    }

    @Override
    public Chunk getChunk(int x, int z) {
        return this.getLevel().d(x, z);
    }

    @Override
    public IBlockData toNative(BlockState blockState) {
        int stateId = this.paperweightFaweAdapter.ordinalToIbdID(blockState.getOrdinalChar());
        return BlockStateIdAccess.isValidInternalId(stateId) ? Block.a((int)stateId) : ((CraftBlockData)BukkitAdapter.adapt(blockState)).getState();
    }

    @Override
    public IBlockData getBlockState(Chunk levelChunk, BlockPosition blockPos) {
        return levelChunk.a_(blockPos);
    }

    @Override
    @Nullable
    public synchronized IBlockData setBlockState(Chunk levelChunk, BlockPosition blockPos, IBlockData blockState) {
        boolean nextTick;
        int currentTick = MinecraftServer.currentTick;
        if (Fawe.isMainThread()) {
            return levelChunk.a(blockPos, blockState, this.sideEffectSet != null && this.sideEffectSet.shouldApply(SideEffect.UPDATE));
        }
        this.cachedChanges.add(new CachedChange(levelChunk, blockPos, blockState));
        this.cachedChunksToSend.add(new IntPair(levelChunk.locX, levelChunk.locZ));
        boolean bl = nextTick = this.lastTick.get() > currentTick;
        if (nextTick || this.cachedChanges.size() >= 1024) {
            if (nextTick) {
                this.lastTick.set(currentTick);
            }
            this.flushAsync(nextTick);
        }
        return blockState;
    }

    @Override
    public IBlockData getValidBlockForPosition(IBlockData blockState, BlockPosition blockPos) {
        return Block.b((IBlockData)blockState, (GeneratorAccess)this.getLevel(), (BlockPosition)blockPos);
    }

    @Override
    public BlockPosition getPosition(int x, int y, int z) {
        return new BlockPosition(x, y, z);
    }

    @Override
    public void updateLightingForBlock(BlockPosition blockPos) {
        this.getLevel().L().p().a(blockPos);
    }

    @Override
    public boolean updateTileEntity(BlockPosition blockPos, LinCompoundTag tag) {
        TileEntity blockEntity = this.getLevel().c_(blockPos);
        if (blockEntity == null) {
            return false;
        }
        NBTBase nativeTag = (NBTBase)this.paperweightFaweAdapter.fromNativeLin((LinTag)tag);
        blockEntity.a((NBTTagCompound)nativeTag);
        return true;
    }

    @Override
    public void notifyBlockUpdate(Chunk levelChunk, BlockPosition blockPos, IBlockData oldState, IBlockData newState) {
        if (levelChunk.d()[((World)this.level.get()).e(blockPos.v())] != null) {
            this.getLevel().a(blockPos, oldState, newState, 3);
        }
    }

    @Override
    public boolean isChunkTicking(Chunk levelChunk) {
        return levelChunk.D().a(FullChunkStatus.c);
    }

    @Override
    public void markBlockChanged(Chunk levelChunk, BlockPosition blockPos) {
        if (levelChunk.d()[((World)this.level.get()).e(blockPos.v())] != null) {
            ((ChunkProviderServer)this.getLevel().L()).a(blockPos);
        }
    }

    @Override
    public void notifyNeighbors(BlockPosition blockPos, IBlockData oldState, IBlockData newState) {
        World level = this.getLevel();
        if (this.sideEffectSet.shouldApply(SideEffect.EVENTS)) {
            level.b(blockPos, oldState.b());
        } else {
            for (EnumDirection direction : NEIGHBOUR_ORDER) {
                BlockPosition shifted = blockPos.a(direction);
                level.a_(shifted).a(level, shifted, oldState.b(), blockPos, false);
            }
        }
        if (newState.n()) {
            level.c(blockPos, newState.b());
        }
    }

    @Override
    public void updateNeighbors(BlockPosition blockPos, IBlockData oldState, IBlockData newState, int recursionLimit) {
        CraftWorld craftWorld;
        World level = this.getLevel();
        oldState.b((GeneratorAccess)level, blockPos, 2, recursionLimit);
        if (this.sideEffectSet.shouldApply(SideEffect.EVENTS) && (craftWorld = level.getWorld()) != null) {
            BlockPhysicsEvent event = new BlockPhysicsEvent(craftWorld.getBlockAt(blockPos.u(), blockPos.v(), blockPos.w()), (BlockData)CraftBlockData.fromData((IBlockData)newState));
            level.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
        }
        newState.a(level, blockPos, 2, recursionLimit);
        newState.b((GeneratorAccess)level, blockPos, 2, recursionLimit);
    }

    @Override
    public void updateBlock(BlockPosition pos, IBlockData oldState, IBlockData newState) {
        World world = this.getLevel();
        newState.a(world, pos, oldState, false);
    }

    @Override
    public void onBlockStateChange(BlockPosition blockPos, IBlockData oldState, IBlockData newState) {
        this.getLevel().a(blockPos, oldState, newState);
    }

    private synchronized void flushAsync(final boolean sendChunks) {
        Set<Object> toSend;
        final Set<CachedChange> changes = Set.copyOf(this.cachedChanges);
        this.cachedChanges.clear();
        if (sendChunks) {
            toSend = Set.copyOf(this.cachedChunksToSend);
            this.cachedChunksToSend.clear();
        } else {
            toSend = Collections.emptySet();
        }
        RunnableVal<Object> runnableVal = new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                changes.forEach(cc -> cc.levelChunk.a(cc.blockPos, cc.blockState, PaperweightFaweWorldNativeAccess.this.sideEffectSet != null && PaperweightFaweWorldNativeAccess.this.sideEffectSet.shouldApply(SideEffect.UPDATE)));
                if (!sendChunks) {
                    return;
                }
                for (IntPair chunk : toSend) {
                    PaperweightPlatformAdapter.sendChunk(chunk, PaperweightFaweWorldNativeAccess.this.getLevel().getWorld().getHandle(), chunk.x(), chunk.z());
                }
            }
        };
        TaskManager.taskManager().async(() -> TaskManager.taskManager().sync(runnableVal));
    }

    @Override
    public synchronized void flush() {
        RunnableVal<Object> runnableVal = new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                PaperweightFaweWorldNativeAccess.this.cachedChanges.forEach(cc -> cc.levelChunk.a(cc.blockPos, cc.blockState, PaperweightFaweWorldNativeAccess.this.sideEffectSet != null && PaperweightFaweWorldNativeAccess.this.sideEffectSet.shouldApply(SideEffect.UPDATE)));
                for (IntPair chunk : PaperweightFaweWorldNativeAccess.this.cachedChunksToSend) {
                    PaperweightPlatformAdapter.sendChunk(chunk, PaperweightFaweWorldNativeAccess.this.getLevel().getWorld().getHandle(), chunk.x(), chunk.z());
                }
            }
        };
        if (Fawe.isMainThread()) {
            runnableVal.run();
        } else {
            TaskManager.taskManager().sync(runnableVal);
        }
        this.cachedChanges.clear();
        this.cachedChunksToSend.clear();
    }

    private record CachedChange(Chunk levelChunk, BlockPosition blockPos, IBlockData blockState) {
    }
}

