/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R3;

import com.fastasyncworldedit.bukkit.adapter.AbstractBukkitGetBlocks;
import com.fastasyncworldedit.bukkit.adapter.DelegateSemaphore;
import com.fastasyncworldedit.bukkit.adapter.NativeEntityFunctionSet;
import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.extent.processor.heightmap.HeightMapType;
import com.fastasyncworldedit.core.internal.exception.FaweException;
import com.fastasyncworldedit.core.math.BitArrayUnstretched;
import com.fastasyncworldedit.core.math.IntPair;
import com.fastasyncworldedit.core.nbt.FaweCompoundTag;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.fastasyncworldedit.core.util.MathMan;
import com.fastasyncworldedit.core.util.NbtUtils;
import com.fastasyncworldedit.core.util.collection.AdaptedMap;
import com.google.common.base.Supplier;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitEntity;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R3.PaperweightFaweAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R3.PaperweightGetBlocks_Copy;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R3.PaperweightPlatformAdapter;
import com.sk89q.worldedit.bukkit.paperlib.PaperLib;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.internal.Constants;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import io.papermc.paper.event.block.BeaconDeactivatedEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.DataBits;
import net.minecraft.util.ZeroBitStorage;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeacon;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPalette;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.DataPaletteHash;
import net.minecraft.world.level.chunk.DataPaletteLinear;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.levelgen.HeightMap;
import org.apache.logging.log4j.Logger;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.enginehub.linbus.tree.LinCompoundTag;
import org.enginehub.linbus.tree.LinDoubleTag;
import org.enginehub.linbus.tree.LinFloatTag;
import org.enginehub.linbus.tree.LinListTag;
import org.enginehub.linbus.tree.LinStringTag;
import org.enginehub.linbus.tree.LinTag;
import org.enginehub.linbus.tree.LinTagType;

public class PaperweightGetBlocks
extends AbstractBukkitGetBlocks<WorldServer, Chunk> {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private static final Function<BlockPosition, BlockVector3> posNms2We = v -> BlockVector3.at(v.u(), v.v(), v.w());
    public static final Function<TileEntity, FaweCompoundTag> NMS_TO_TILE = ((PaperweightFaweAdapter)WorldEditPlugin.getInstance().getBukkitImplAdapter()).blockEntityToCompoundTag();
    private final PaperweightFaweAdapter adapter = (PaperweightFaweAdapter)WorldEditPlugin.getInstance().getBukkitImplAdapter();
    private final ReadWriteLock sectionLock = new ReentrantReadWriteLock();
    private final IRegistry<BiomeBase> biomeRegistry;
    private final Registry<Holder<BiomeBase>> biomeHolderIdMap;
    private final Object sendLock = new Object();
    private Chunk levelChunk;
    private ChunkSection[] sections;
    private NibbleArray[] blockLight;
    private NibbleArray[] skyLight = new NibbleArray[this.getSectionCount()];
    private boolean lightUpdate = false;

    public PaperweightGetBlocks(World world, int chunkX, int chunkZ) {
        this(((CraftWorld)world).getHandle(), chunkX, chunkZ);
    }

    public PaperweightGetBlocks(WorldServer serverLevel, int chunkX, int chunkZ) {
        super(serverLevel, chunkX, chunkZ, serverLevel.J_(), serverLevel.al() - 1);
        this.blockLight = new NibbleArray[this.getSectionCount()];
        this.biomeRegistry = serverLevel.I_().d(Registries.at);
        this.biomeHolderIdMap = this.biomeRegistry.t();
    }

    @Override
    public void setLightingToGet(char[][] light, int minSectionPosition, int maxSectionPosition) {
        if (light != null) {
            this.lightUpdate = true;
            try {
                this.fillLightNibble(light, EnumSkyBlock.b, minSectionPosition, maxSectionPosition);
            }
            catch (Throwable e) {
                LOGGER.error("Error setting lighting to get", e);
            }
        }
    }

    @Override
    public void setSkyLightingToGet(char[][] light, int minSectionPosition, int maxSectionPosition) {
        if (light != null) {
            this.lightUpdate = true;
            try {
                this.fillLightNibble(light, EnumSkyBlock.a, minSectionPosition, maxSectionPosition);
            }
            catch (Throwable e) {
                LOGGER.error("Error setting sky lighting to get", e);
            }
        }
    }

    @Override
    public void setHeightmapToGet(HeightMapType type, int[] data) {
        BitArrayUnstretched bitArray = new BitArrayUnstretched(MathMan.log2nlz(this.getChunk().K_() + 1), 256);
        bitArray.fromRaw(data);
        HeightMap.Type nativeType = HeightMap.Type.valueOf((String)type.name());
        HeightMap heightMap = (HeightMap)this.getChunk().h.get(nativeType);
        heightMap.a((IChunkAccess)this.getChunk(), nativeType, bitArray.getData());
    }

    @Override
    public BiomeType getBiomeType(int x, int y, int z) {
        ChunkSection section = this.getSections(false)[(y >> 4) - this.getMinSectionPosition()];
        Holder biomes = section.c(x >> 2, (y & 0xF) >> 2, z >> 2);
        return PaperweightPlatformAdapter.adapt((Holder<BiomeBase>)biomes, (GeneratorAccess)this.serverLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSectionLighting(int layer, boolean sky) {
        SectionPosition sectionPos = SectionPosition.a((ChunkCoordIntPair)this.getChunk().f(), (int)layer);
        NibbleArray dataLayer = ((WorldServer)this.serverLevel).l().a().a(EnumSkyBlock.b).a(sectionPos);
        if (dataLayer != null) {
            this.lightUpdate = true;
            NibbleArray nibbleArray = dataLayer;
            synchronized (nibbleArray) {
                byte[] bytes = dataLayer.a();
                Arrays.fill(bytes, (byte)0);
            }
        }
        if (sky) {
            SectionPosition sectionPos1 = SectionPosition.a((ChunkCoordIntPair)this.getChunk().f(), (int)layer);
            NibbleArray dataLayer1 = ((WorldServer)this.serverLevel).l().a().a(EnumSkyBlock.a).a(sectionPos1);
            if (dataLayer1 != null) {
                this.lightUpdate = true;
                NibbleArray nibbleArray = dataLayer1;
                synchronized (nibbleArray) {
                    byte[] bytes = dataLayer1.a();
                    Arrays.fill(bytes, (byte)0);
                }
            }
        }
    }

    @Override
    public FaweCompoundTag tile(int x, int y, int z) {
        TileEntity blockEntity = this.getChunk().c_(new BlockPosition((x & 0xF) + (this.chunkX << 4), y, (z & 0xF) + (this.chunkZ << 4)));
        if (blockEntity == null) {
            return null;
        }
        return NMS_TO_TILE.apply(blockEntity);
    }

    @Override
    public Map<BlockVector3, FaweCompoundTag> tiles() {
        Map nmsTiles = this.getChunk().G();
        if (nmsTiles.isEmpty()) {
            return Collections.emptyMap();
        }
        return AdaptedMap.immutable(nmsTiles, posNms2We, NMS_TO_TILE);
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        int layer = y >> 4;
        int alayer = layer - this.getMinSectionPosition();
        if (this.skyLight[alayer] == null) {
            SectionPosition sectionPos = SectionPosition.a((ChunkCoordIntPair)this.getChunk().f(), (int)layer);
            NibbleArray dataLayer = ((WorldServer)this.serverLevel).l().a().a(EnumSkyBlock.a).a(sectionPos);
            if (dataLayer == null) {
                byte[] LAYER_COUNT = new byte[2048];
                Arrays.fill(LAYER_COUNT, (byte)15);
                dataLayer = new NibbleArray(LAYER_COUNT);
                ((WorldServer)this.serverLevel).l().a().a(EnumSkyBlock.b, sectionPos, dataLayer);
            }
            this.skyLight[alayer] = dataLayer;
        }
        return this.skyLight[alayer].a(x & 0xF, y & 0xF, z & 0xF);
    }

    @Override
    public int getEmittedLight(int x, int y, int z) {
        int layer = y >> 4;
        int alayer = layer - this.getMinSectionPosition();
        if (this.blockLight[alayer] == null) {
            ((WorldServer)this.serverLevel).b(new BlockPosition(1, 1, 1), 5);
            SectionPosition sectionPos = SectionPosition.a((ChunkCoordIntPair)this.getChunk().f(), (int)layer);
            NibbleArray dataLayer = ((WorldServer)this.serverLevel).l().a().a(EnumSkyBlock.b).a(sectionPos);
            if (dataLayer == null) {
                byte[] LAYER_COUNT = new byte[2048];
                Arrays.fill(LAYER_COUNT, (byte)15);
                dataLayer = new NibbleArray(LAYER_COUNT);
                ((WorldServer)this.serverLevel).l().a().a(EnumSkyBlock.b, sectionPos, dataLayer);
            }
            this.blockLight[alayer] = dataLayer;
        }
        return this.blockLight[alayer].a(x & 0xF, y & 0xF, z & 0xF);
    }

    @Override
    public int[] getHeightMap(HeightMapType type) {
        long[] longArray = ((HeightMap)this.getChunk().h.get(HeightMap.Type.valueOf((String)type.name()))).a();
        BitArrayUnstretched bitArray = new BitArrayUnstretched(9, 256, longArray);
        return bitArray.toRaw(new int[256]);
    }

    @Override
    @Nullable
    public FaweCompoundTag entity(UUID uuid) {
        List<net.minecraft.world.entity.Entity> entities = PaperweightPlatformAdapter.getEntities(this.getChunk());
        net.minecraft.world.entity.Entity entity = null;
        for (net.minecraft.world.entity.Entity e : entities) {
            if (!e.cw().equals(uuid)) continue;
            entity = e;
            break;
        }
        if (entity != null) {
            CraftEntity bukkitEnt = entity.getBukkitEntity();
            return FaweCompoundTag.of(BukkitAdapter.adapt((org.bukkit.entity.Entity)bukkitEnt).getState().getNbt());
        }
        for (FaweCompoundTag tag : this.entities()) {
            if (!uuid.equals(NbtUtils.uuid(tag))) continue;
            return tag;
        }
        return null;
    }

    @Override
    public Collection<FaweCompoundTag> entities() {
        List<net.minecraft.world.entity.Entity> entities = PaperweightPlatformAdapter.getEntities(this.getChunk());
        if (entities.isEmpty()) {
            return Collections.emptyList();
        }
        return new NativeEntityFunctionSet<net.minecraft.world.entity.Entity, FaweCompoundTag>(entities, net.minecraft.world.entity.Entity::cw, e -> {
            NBTTagCompound tag = new NBTTagCompound();
            e.e(tag);
            return FaweCompoundTag.of((Supplier<? extends LinCompoundTag>)((Supplier)() -> (LinCompoundTag)this.adapter.toNativeLin(tag)));
        });
    }

    @Override
    public Set<Entity> getFullEntities() {
        List<net.minecraft.world.entity.Entity> entities = PaperweightPlatformAdapter.getEntities(this.getChunk());
        if (entities.isEmpty()) {
            return Collections.emptySet();
        }
        return new NativeEntityFunctionSet<net.minecraft.world.entity.Entity, Entity>(entities, net.minecraft.world.entity.Entity::cw, e -> new BukkitEntity((org.bukkit.entity.Entity)e.getBukkitEntity()));
    }

    private void removeEntity(net.minecraft.world.entity.Entity entity) {
        entity.am();
    }

    @Override
    public CompletableFuture<Chunk> ensureLoaded(WorldServer nmsWorld) {
        return PaperweightPlatformAdapter.ensureLoaded(nmsWorld, this.chunkX, this.chunkZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T extends Future<T>> T internalCall(IChunkSet set, Runnable finalizer, int copyKey, Chunk nmsChunk, WorldServer nmsWorld) throws Exception {
        PaperweightGetBlocks_Copy copy;
        PaperweightGetBlocks_Copy paperweightGetBlocks_Copy = copy = this.createCopy ? new PaperweightGetBlocks_Copy(nmsChunk) : null;
        if (this.createCopy) {
            if (this.copies.containsKey(copyKey)) {
                throw new IllegalStateException("Copy key already used.");
            }
            this.copies.put(copyKey, copy);
        }
        HashMap chunkTiles = new HashMap(nmsChunk.G());
        ArrayList<TileEntity> beacons = null;
        if (!chunkTiles.isEmpty()) {
            for (Map.Entry entry : chunkTiles.entrySet()) {
                int ordinal;
                BlockPosition pos = (BlockPosition)entry.getKey();
                int lx = pos.u() & 0xF;
                int ly = pos.v();
                int lz = pos.w() & 0xF;
                int layer = ly >> 4;
                if (!set.hasSection(layer) || (ordinal = set.getBlock(lx, ly, lz).getOrdinal()) == 0) continue;
                TileEntity tile = (TileEntity)entry.getValue();
                if (PaperLib.isPaper() && tile instanceof TileEntityBeacon) {
                    if (beacons == null) {
                        beacons = new ArrayList<TileEntity>();
                    }
                    beacons.add(tile);
                    PaperweightPlatformAdapter.removeBeacon(tile, nmsChunk);
                    continue;
                }
                nmsChunk.d(tile.aB_());
                if (!this.createCopy) continue;
                copy.storeTile(tile);
            }
        }
        BiomeType[][] biomes = set.getBiomes();
        int bitMask = 0;
        Chunk chunk = nmsChunk;
        synchronized (chunk) {
            Runnable callback;
            Map<BlockVector3, FaweCompoundTag> tiles;
            Collection<FaweCompoundTag> entities;
            Set<UUID> entityRemoves;
            ChunkSection[] levelChunkSections = nmsChunk.d();
            for (int layerNo = this.getMinSectionPosition(); layerNo <= this.getMaxSectionPosition(); ++layerNo) {
                DataPaletteBlock<Holder<BiomeBase>> paletteBiomes;
                ChunkSection newSection;
                int getSectionIndex = layerNo - this.getMinSectionPosition();
                int setSectionIndex = layerNo - set.getMinSectionPosition();
                if (!set.hasSection(layerNo)) {
                    if (biomes == null || layerNo < set.getMinSectionPosition() || layerNo > set.getMaxSectionPosition() || biomes[setSectionIndex] == null) continue;
                    Object ordinal = this.sectionLocks[getSectionIndex];
                    synchronized (ordinal) {
                        ChunkSection existingSection = levelChunkSections[getSectionIndex];
                        if (this.createCopy && existingSection != null) {
                            copy.storeBiomes(getSectionIndex, (PalettedContainerRO<Holder<BiomeBase>>)existingSection.i());
                        }
                        if (existingSection == null) {
                            DataPaletteBlock<Holder<BiomeBase>> biomeData = PaperweightPlatformAdapter.getBiomePalettedContainer(biomes[setSectionIndex], this.biomeHolderIdMap);
                            newSection = PaperweightPlatformAdapter.newChunkSection(layerNo, new char[4096], this.adapter, this.biomeRegistry, biomeData);
                            if (PaperweightPlatformAdapter.setSectionAtomic(nmsWorld.getWorld().getName(), this.chunkPos, levelChunkSections, null, newSection, getSectionIndex)) {
                                this.updateGet(nmsChunk, levelChunkSections, newSection, new char[4096], getSectionIndex);
                                continue;
                            }
                            existingSection = levelChunkSections[getSectionIndex];
                            if (existingSection == null) {
                                LOGGER.error("Skipping invalid null section. chunk: {}, {} layer: {}", (Object)this.chunkX, (Object)this.chunkZ, (Object)getSectionIndex);
                            }
                        } else {
                            paletteBiomes = this.setBiomesToPalettedContainer(biomes, setSectionIndex, (PalettedContainerRO<Holder<BiomeBase>>)existingSection.i());
                            if (paletteBiomes != null) {
                                PaperweightPlatformAdapter.setBiomesToChunkSection(existingSection, paletteBiomes);
                            }
                        }
                        continue;
                    }
                }
                bitMask |= 1 << getSectionIndex;
                char[] tmp = set.load(layerNo);
                char[] setArr = new char[tmp.length];
                System.arraycopy(tmp, 0, setArr, 0, tmp.length);
                paletteBiomes = this.sectionLocks[getSectionIndex];
                synchronized (paletteBiomes) {
                    DelegateSemaphore lock;
                    ChunkSection existingSection = levelChunkSections[getSectionIndex];
                    if (existingSection != null) {
                        PaperweightPlatformAdapter.clearCounts(existingSection);
                        if (PaperLib.isPaper()) {
                            existingSection.tickingList.clear();
                        }
                    }
                    if (this.createCopy) {
                        char[] tmpLoad = this.load(layerNo);
                        char[] copyArr = new char[4096];
                        System.arraycopy(tmpLoad, 0, copyArr, 0, 4096);
                        copy.storeSection(getSectionIndex, copyArr);
                        if (biomes != null && existingSection != null) {
                            copy.storeBiomes(getSectionIndex, (PalettedContainerRO<Holder<BiomeBase>>)existingSection.i());
                        }
                    }
                    if (existingSection == null) {
                        DataPaletteBlock biomeData = biomes == null ? new DataPaletteBlock(this.biomeHolderIdMap, (Object)((Holder)this.biomeHolderIdMap.b(this.adapter.getInternalBiomeId(BiomeTypes.PLAINS))), DataPaletteBlock.d.e) : PaperweightPlatformAdapter.getBiomePalettedContainer(biomes[setSectionIndex], this.biomeHolderIdMap);
                        newSection = PaperweightPlatformAdapter.newChunkSection(layerNo, setArr, this.adapter, this.biomeRegistry, (DataPaletteBlock<Holder<BiomeBase>>)biomeData);
                        if (PaperweightPlatformAdapter.setSectionAtomic(nmsWorld.getWorld().getName(), this.chunkPos, levelChunkSections, null, newSection, getSectionIndex)) {
                            this.updateGet(nmsChunk, levelChunkSections, newSection, setArr, getSectionIndex);
                            continue;
                        }
                        existingSection = levelChunkSections[getSectionIndex];
                        if (existingSection == null) {
                            LOGGER.error("Skipping invalid null section. chunk: {}, {} layer: {}", (Object)this.chunkX, (Object)this.chunkZ, (Object)getSectionIndex);
                            continue;
                        }
                    }
                    PaperweightPlatformAdapter.clearCounts(existingSection);
                    if (PaperLib.isPaper()) {
                        existingSection.tickingList.clear();
                    }
                    DelegateSemaphore delegateSemaphore = lock = PaperweightPlatformAdapter.applyLock(existingSection);
                    synchronized (delegateSemaphore) {
                        lock.acquire();
                        lock.release();
                        try {
                            this.sectionLock.writeLock().lock();
                            if (this.getChunk() != nmsChunk) {
                                this.levelChunk = nmsChunk;
                                this.sections = null;
                                this.reset();
                            } else if (existingSection != this.getSections(false)[getSectionIndex]) {
                                this.sections[getSectionIndex] = existingSection;
                                this.reset();
                            } else if (!Arrays.equals(this.update(getSectionIndex, new char[4096], true), this.load(layerNo))) {
                                this.reset(layerNo);
                            }
                        }
                        finally {
                            this.sectionLock.writeLock().unlock();
                        }
                        DataPaletteBlock biomeData = this.setBiomesToPalettedContainer(biomes, setSectionIndex, (PalettedContainerRO<Holder<BiomeBase>>)existingSection.i());
                        newSection = PaperweightPlatformAdapter.newChunkSection(layerNo, this::load, setArr, this.adapter, this.biomeRegistry, biomeData != null ? biomeData : (DataPaletteBlock)existingSection.i());
                        if (!PaperweightPlatformAdapter.setSectionAtomic(nmsWorld.getWorld().getName(), this.chunkPos, levelChunkSections, existingSection, newSection, getSectionIndex)) {
                            LOGGER.error("Skipping invalid null section. chunk: {}, {} layer: {}", (Object)this.chunkX, (Object)this.chunkZ, (Object)getSectionIndex);
                        } else {
                            this.updateGet(nmsChunk, levelChunkSections, newSection, setArr, getSectionIndex);
                        }
                    }
                }
            }
            Map<HeightMapType, int[]> heightMaps = set.getHeightMaps();
            for (Map.Entry<HeightMapType, int[]> entry : heightMaps.entrySet()) {
                this.setHeightmapToGet(entry.getKey(), entry.getValue());
            }
            this.setLightingToGet(set.getLight(), set.getMinSectionPosition(), set.getMaxSectionPosition());
            this.setSkyLightingToGet(set.getSkyLight(), set.getMinSectionPosition(), set.getMaxSectionPosition());
            ArrayList<Runnable> syncTasks = new ArrayList<Runnable>();
            int bx = this.chunkX << 4;
            int bz = this.chunkZ << 4;
            if (beacons != null && !beacons.isEmpty()) {
                ArrayList<TileEntity> finalBeacons = beacons;
                syncTasks.add(() -> {
                    for (TileEntity beacon : finalBeacons) {
                        TileEntityBeacon.a((net.minecraft.world.level.World)beacon.i(), (BlockPosition)beacon.aB_(), (SoundEffect)SoundEffects.bx);
                        new BeaconDeactivatedEvent((Block)CraftBlock.at((GeneratorAccess)beacon.i(), (BlockPosition)beacon.aB_())).callEvent();
                    }
                });
            }
            if ((entityRemoves = set.getEntityRemoves()) != null && !entityRemoves.isEmpty()) {
                syncTasks.add(() -> {
                    HashSet<UUID> entitiesRemoved = new HashSet<UUID>();
                    List<net.minecraft.world.entity.Entity> entities = PaperweightPlatformAdapter.getEntities(nmsChunk);
                    for (net.minecraft.world.entity.Entity entity : entities) {
                        UUID uuid = entity.cw();
                        if (!entityRemoves.contains(uuid)) continue;
                        if (this.createCopy) {
                            copy.storeEntity(entity);
                        }
                        this.removeEntity(entity);
                        entitiesRemoved.add(uuid);
                        entityRemoves.remove(uuid);
                    }
                    if (Settings.settings().EXPERIMENTAL.REMOVE_ENTITY_FROM_WORLD_ON_CHUNK_FAIL) {
                        for (UUID uuid : entityRemoves) {
                            net.minecraft.world.entity.Entity entity = (net.minecraft.world.entity.Entity)nmsWorld.G().a(uuid);
                            if (entity == null) continue;
                            this.removeEntity(entity);
                        }
                    }
                    set.getEntityRemoves().clear();
                    set.getEntityRemoves().addAll(entitiesRemoved);
                });
            }
            if ((entities = set.entities()) != null && !entities.isEmpty()) {
                syncTasks.add(() -> {
                    Iterator iterator = entities.iterator();
                    while (iterator.hasNext()) {
                        net.minecraft.world.entity.Entity entity;
                        FaweCompoundTag nativeTag = (FaweCompoundTag)iterator.next();
                        LinCompoundTag linTag = nativeTag.linTag();
                        LinStringTag idTag = linTag.findTag("Id", LinTagType.stringTag());
                        LinListTag<LinDoubleTag> posTag = linTag.findListTag("Pos", LinTagType.doubleTag());
                        LinListTag<LinFloatTag> rotTag = linTag.findListTag("Rotation", LinTagType.floatTag());
                        if (idTag == null || posTag == null || rotTag == null) {
                            LOGGER.error("Unknown entity tag: {}", (Object)nativeTag);
                            continue;
                        }
                        double x = posTag.get(0).valueAsDouble();
                        double y = posTag.get(1).valueAsDouble();
                        double z = posTag.get(2).valueAsDouble();
                        float yaw = rotTag.get(0).valueAsFloat();
                        float pitch = rotTag.get(1).valueAsFloat();
                        String id = idTag.value();
                        EntityTypes type = EntityTypes.a((String)id).orElse(null);
                        if (type == null || (entity = type.a((net.minecraft.world.level.World)nmsWorld)) == null) continue;
                        NBTTagCompound tag = (NBTTagCompound)this.adapter.fromNativeLin((LinTag)linTag);
                        for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
                            tag.r(name);
                        }
                        entity.g(tag);
                        entity.a(x, y, z, yaw, pitch);
                        entity.a_(NbtUtils.uuid(nativeTag));
                        if (nmsWorld.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.CUSTOM)) continue;
                        LOGGER.warn("Error creating entity of type `{}` in world `{}` at location `{},{},{}`", (Object)id, (Object)nmsWorld.getWorld().getName(), (Object)x, (Object)y, (Object)z);
                        iterator.remove();
                    }
                });
            }
            if ((tiles = set.tiles()) != null && !tiles.isEmpty()) {
                syncTasks.add(() -> {
                    for (Map.Entry entry : tiles.entrySet()) {
                        FaweCompoundTag nativeTag = (FaweCompoundTag)entry.getValue();
                        BlockVector3 blockHash = (BlockVector3)entry.getKey();
                        int x = blockHash.x() + bx;
                        int y = blockHash.y();
                        int z = blockHash.z() + bz;
                        BlockPosition pos = new BlockPosition(x, y, z);
                        WorldServer worldServer = nmsWorld;
                        synchronized (worldServer) {
                            TileEntity tileEntity = nmsWorld.c_(pos);
                            if (tileEntity == null || tileEntity.s()) {
                                nmsWorld.o(pos);
                                tileEntity = nmsWorld.c_(pos);
                            }
                            if (tileEntity != null) {
                                NBTTagCompound tag = (NBTTagCompound)this.adapter.fromNativeLin((LinTag)nativeTag.linTag());
                                tag.a("x", (NBTBase)NBTTagInt.a((int)x));
                                tag.a("y", (NBTBase)NBTTagInt.a((int)y));
                                tag.a("z", (NBTBase)NBTTagInt.a((int)z));
                                tileEntity.a(tag);
                            }
                        }
                    }
                });
            }
            if (bitMask == 0 && biomes == null && !this.lightUpdate) {
                callback = null;
            } else {
                int finalMask = bitMask != 0 ? bitMask : (this.lightUpdate ? set.getBitMask() : 0);
                syncTasks.add(() -> {
                    nmsChunk.b(true);
                    nmsChunk.mustNotSave = false;
                    nmsChunk.a(true);
                });
                callback = () -> {
                    if (!set.getSideEffectSet().shouldApply(SideEffect.LIGHTING) || !Settings.settings().LIGHTING.DELAY_PACKET_SENDING || finalMask == 0 && biomes != null) {
                        this.send();
                    }
                    if (finalizer != null) {
                        finalizer.run();
                    }
                };
            }
            return this.handleCallFinalizer(syncTasks, callback, finalizer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGet(Chunk nmsChunk, ChunkSection[] chunkSections, ChunkSection section, char[] arr, int layer) {
        try {
            this.sectionLock.writeLock().lock();
            if (this.getChunk() != nmsChunk) {
                this.levelChunk = nmsChunk;
                this.sections = new ChunkSection[chunkSections.length];
                System.arraycopy(chunkSections, 0, this.sections, 0, chunkSections.length);
                this.reset();
            }
            if (this.sections == null) {
                this.sections = new ChunkSection[chunkSections.length];
                System.arraycopy(chunkSections, 0, this.sections, 0, chunkSections.length);
            }
            if (this.sections[layer] != section) {
                this.sections[layer] = ((ChunkSection[])new ChunkSection[]{section}.clone())[0];
            }
        }
        finally {
            this.sectionLock.writeLock().unlock();
        }
        this.blocks[layer] = arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send() {
        Object object = this.sendLock;
        synchronized (object) {
            PaperweightPlatformAdapter.sendChunk(new IntPair(this.chunkX, this.chunkZ), (WorldServer)this.serverLevel, this.chunkX, this.chunkZ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public char[] update(int layer, char[] data, boolean aggressive) {
        DelegateSemaphore lock;
        ChunkSection section = this.getSections(aggressive)[layer];
        if (section == null) {
            data = new char[4096];
            Arrays.fill(data, '\u0001');
            return data;
        }
        if (data == null || data == FaweCache.INSTANCE.EMPTY_CHAR_4096 || data.length != 4096) {
            data = new char[4096];
        }
        DelegateSemaphore delegateSemaphore = lock = PaperweightPlatformAdapter.applyLock(section);
        // MONITORENTER : delegateSemaphore
        try {
            ((Semaphore)lock).acquire();
            DataPaletteBlock blocks = section.h();
            Object dataObject = PaperweightPlatformAdapter.fieldData.get(blocks);
            DataBits bits = (DataBits)PaperweightPlatformAdapter.fieldStorage.get(dataObject);
            if (bits instanceof ZeroBitStorage) {
                Arrays.fill(data, this.adapter.adaptToChar((IBlockData)blocks.a(0, 0, 0)));
                char[] cArray = data;
                return cArray;
            }
            DataPalette palette = (DataPalette)PaperweightPlatformAdapter.fieldPalette.get(dataObject);
            int bitsPerEntry = bits.c();
            long[] blockStates = bits.a();
            new BitArrayUnstretched(bitsPerEntry, 4096, blockStates).toRaw(data);
            if (!(palette instanceof DataPaletteLinear) && !(palette instanceof DataPaletteHash)) {
                this.adapter.mapFromGlobalPalette(data);
                char[] cArray = data;
                return cArray;
            }
            int num_palette = palette.b();
            char[] paletteToOrdinal = (char[])FaweCache.INSTANCE.PALETTE_TO_BLOCK_CHAR.get();
            try {
                if (num_palette == 1) {
                    char ordinal = this.ordinal((IBlockData)palette.a(0), this.adapter);
                    Arrays.fill(data, ordinal);
                } else {
                    for (int i = 0; i < num_palette; ++i) {
                        char ordinal;
                        paletteToOrdinal[i] = ordinal = this.ordinal((IBlockData)palette.a(i), this.adapter);
                    }
                    this.adapter.mapWithPalette(data, paletteToOrdinal);
                }
            }
            finally {
                Arrays.fill(paletteToOrdinal, 0, num_palette, '\uffff');
            }
            char[] cArray = data;
            return cArray;
        }
        catch (IllegalAccessException | InterruptedException e) {
            LOGGER.error("Could not read block data from palette", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            ((Semaphore)lock).release();
        }
    }

    private char ordinal(IBlockData ibd, PaperweightFaweAdapter adapter) {
        if (ibd == null) {
            return '\u0001';
        }
        return adapter.adaptToChar(ibd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkSection[] getSections(boolean force) {
        ChunkSection[] tmp = this.sections;
        if (tmp == null || (force &= this.forceLoadSections)) {
            try {
                this.sectionLock.writeLock().lock();
                tmp = this.sections;
                if (tmp == null || force) {
                    ChunkSection[] chunkSections = this.getChunk().d();
                    tmp = new ChunkSection[chunkSections.length];
                    System.arraycopy(chunkSections, 0, tmp, 0, chunkSections.length);
                    this.sections = tmp;
                }
            }
            finally {
                this.sectionLock.writeLock().unlock();
            }
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk getChunk() {
        Chunk levelChunk = this.levelChunk;
        if (levelChunk == null) {
            PaperweightGetBlocks paperweightGetBlocks = this;
            synchronized (paperweightGetBlocks) {
                levelChunk = this.levelChunk;
                if (levelChunk == null) {
                    try {
                        this.levelChunk = levelChunk = this.ensureLoaded((WorldServer)this.serverLevel).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        LOGGER.error("Could not get chunk at {},{}", (Object)this.chunkX, (Object)this.chunkZ, (Object)e);
                        throw new FaweException(TextComponent.of("Could not get chunk at " + this.chunkX + "," + this.chunkZ + ": " + e.getMessage()), FaweException.Type.OTHER, false);
                    }
                }
            }
        }
        return levelChunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillLightNibble(char[][] light, EnumSkyBlock lightLayer, int minSectionPosition, int maxSectionPosition) {
        for (int Y = 0; Y <= maxSectionPosition - minSectionPosition; ++Y) {
            if (light[Y] == null) continue;
            SectionPosition sectionPos = SectionPosition.a((ChunkCoordIntPair)this.levelChunk.f(), (int)(Y + minSectionPosition));
            NibbleArray dataLayer = ((WorldServer)this.serverLevel).l().a().a(lightLayer).a(sectionPos);
            if (dataLayer == null) {
                byte[] LAYER_COUNT = new byte[2048];
                Arrays.fill(LAYER_COUNT, lightLayer == EnumSkyBlock.a ? (byte)15 : 0);
                dataLayer = new NibbleArray(LAYER_COUNT);
                ((WorldServer)this.serverLevel).l().a().a(lightLayer, sectionPos, dataLayer);
            }
            NibbleArray nibbleArray = dataLayer;
            synchronized (nibbleArray) {
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            int i = y << 8 | z << 4 | x;
                            if (light[Y][i] >= '\u0010') continue;
                            dataLayer.a(x, y, z, (int)light[Y][i]);
                        }
                    }
                }
                continue;
            }
        }
    }

    private DataPaletteBlock<Holder<BiomeBase>> setBiomesToPalettedContainer(BiomeType[][] biomes, int sectionIndex, PalettedContainerRO<Holder<BiomeBase>> data) {
        BiomeType[] sectionBiomes;
        if (biomes == null || (sectionBiomes = biomes[sectionIndex]) == null) {
            return null;
        }
        DataPaletteBlock biomeData = data.e();
        int index = 0;
        for (int y = 0; y < 4; ++y) {
            for (int z = 0; z < 4; ++z) {
                int x = 0;
                while (x < 4) {
                    BiomeType biomeType = sectionBiomes[index];
                    if (biomeType == null) {
                        biomeData.c(x, y, z, (Object)((Holder)data.a(x, y, z)));
                    } else {
                        biomeData.c(x, y, z, (Object)((Holder)this.biomeHolderIdMap.b(this.adapter.getInternalBiomeId(biomeType))));
                    }
                    ++x;
                    ++index;
                }
            }
        }
        return biomeData;
    }

    @Override
    public boolean hasSection(int layer) {
        return this.getSections(false)[layer -= this.getMinSectionPosition()] != null;
    }

    @Override
    public boolean hasNonEmptySection(int layer) {
        ChunkSection section = this.getSections(false)[layer -= this.getMinSectionPosition()];
        return section != null && !section.c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean trim(boolean aggressive) {
        PaperweightGetBlocks paperweightGetBlocks = this;
        synchronized (paperweightGetBlocks) {
            if (!(this.sections != null || aggressive && this.levelChunk != null)) {
                this.skyLight = new NibbleArray[this.getSectionCount()];
                this.blockLight = new NibbleArray[this.getSectionCount()];
                return !aggressive || super.trim(true);
            }
        }
        if (aggressive) {
            this.sectionLock.writeLock().lock();
            try {
                paperweightGetBlocks = this;
                synchronized (paperweightGetBlocks) {
                    this.skyLight = new NibbleArray[this.getSectionCount()];
                    this.blockLight = new NibbleArray[this.getSectionCount()];
                    this.sections = null;
                    this.levelChunk = null;
                    boolean bl = super.trim(true);
                    return bl;
                }
            }
            finally {
                this.sectionLock.writeLock().unlock();
            }
        }
        paperweightGetBlocks = this;
        synchronized (paperweightGetBlocks) {
            for (int i = this.getMinSectionPosition(); i <= this.getMaxSectionPosition(); ++i) {
                int layer = i - this.getMinSectionPosition();
                if (!this.hasSection(i) || this.blocks[layer] == null) continue;
                ChunkSection existing = this.getSections(true)[layer];
                try {
                    DataPaletteBlock blocksExisting = existing.h();
                    Object dataObject = PaperweightPlatformAdapter.fieldData.get(blocksExisting);
                    DataPalette palette = (DataPalette)PaperweightPlatformAdapter.fieldPalette.get(dataObject);
                    if (!(palette instanceof DataPaletteLinear) && !(palette instanceof DataPaletteHash)) {
                        super.trim(false, i);
                        continue;
                    }
                    int paletteSize = palette.b();
                    if (paletteSize == 1) continue;
                    super.trim(false, i);
                    continue;
                }
                catch (IllegalAccessException ignored) {
                    super.trim(false, i);
                }
            }
            return true;
        }
    }
}

