/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R3;

import com.fastasyncworldedit.bukkit.adapter.StarlightRelighter;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.math.IntPair;
import com.fastasyncworldedit.core.queue.IQueueExtent;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R3.PaperweightPlatformAdapter;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.Unit;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.ChunkStatus;

public class PaperweightStarlightRelighter
extends StarlightRelighter<WorldServer, ChunkCoordIntPair> {
    private static final TicketType<Unit> FAWE_TICKET = TicketType.a((String)"fawe_ticket", (a2, b2) -> 0);
    private static final int LIGHT_LEVEL = 32 + ChunkStatus.a((ChunkStatus)ChunkStatus.l);

    public PaperweightStarlightRelighter(WorldServer serverLevel, IQueueExtent<?> queue) {
        super(serverLevel, queue);
    }

    @Override
    protected ChunkCoordIntPair createChunkPos(long chunkKey) {
        return new ChunkCoordIntPair(chunkKey);
    }

    @Override
    protected long asLong(int chunkX, int chunkZ) {
        return ChunkCoordIntPair.c((int)chunkX, (int)chunkZ);
    }

    @Override
    protected CompletableFuture<?> chunkLoadFuture(ChunkCoordIntPair chunkPos) {
        return ((WorldServer)this.serverLevel).getWorld().getChunkAtAsync(chunkPos.e, chunkPos.f).thenAccept(c2 -> ((WorldServer)this.serverLevel).l().addTicketAtLevel(FAWE_TICKET, chunkPos, LIGHT_LEVEL, (Object)Unit.a));
    }

    @Override
    protected void invokeRelight(Set<ChunkCoordIntPair> coords, Consumer<ChunkCoordIntPair> chunkCallback, IntConsumer processCallback) {
        try {
            ((WorldServer)this.serverLevel).l().a().relight(coords, chunkCallback, processCallback);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred on relighting", (Throwable)e);
        }
    }

    @Override
    protected void postProcessChunks(Set<ChunkCoordIntPair> coords) {
        boolean delay = Settings.settings().LIGHTING.DELAY_PACKET_SENDING;
        for (ChunkCoordIntPair pos : coords) {
            int x = pos.e;
            int z = pos.f;
            if (delay) {
                PaperweightPlatformAdapter.sendChunk(new IntPair(x, z), (WorldServer)this.serverLevel, x, z);
            }
            ((WorldServer)this.serverLevel).l().removeTicketAtLevel(FAWE_TICKET, pos, LIGHT_LEVEL, (Object)Unit.a);
        }
    }
}

