/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R4;

import com.fastasyncworldedit.core.extent.processor.heightmap.HeightMapType;
import com.fastasyncworldedit.core.nbt.FaweCompoundTag;
import com.fastasyncworldedit.core.queue.IBlocks;
import com.fastasyncworldedit.core.queue.IChunk;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.fastasyncworldedit.core.queue.IQueueExtent;
import com.fastasyncworldedit.core.util.NbtUtils;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R4.PaperweightPlatformAdapter;
import com.sk89q.worldedit.bukkit.paperlib.PaperLib;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import org.apache.logging.log4j.Logger;
import org.enginehub.linbus.tree.LinCompoundTag;

public class PaperweightGetBlocks_Copy
implements IChunkGet {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private final Map<BlockVector3, FaweCompoundTag> tiles = new HashMap<BlockVector3, FaweCompoundTag>();
    private final Set<FaweCompoundTag> entities = new HashSet<FaweCompoundTag>();
    private final char[][] blocks;
    private final int minHeight;
    private final int maxHeight;
    private final int chunkX;
    private final int chunkZ;
    final WorldServer serverLevel;
    final Chunk levelChunk;
    private Holder<BiomeBase>[][] biomes = null;

    protected PaperweightGetBlocks_Copy(Chunk levelChunk) {
        this.levelChunk = levelChunk;
        this.serverLevel = levelChunk.r;
        this.minHeight = this.serverLevel.I_();
        this.maxHeight = this.serverLevel.am() - 1;
        this.blocks = new char[this.getSectionCount()][];
        this.chunkX = levelChunk.f().e;
        this.chunkZ = levelChunk.f().f;
    }

    protected void storeTile(TileEntity blockEntity) {
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        this.tiles.put(BlockVector3.at(blockEntity.ay_().u(), blockEntity.ay_().v(), blockEntity.ay_().w()), FaweCompoundTag.of((LinCompoundTag)adapter.toNativeLin(blockEntity.c((HolderLookup.a)DedicatedServer.getServer().bc()))));
    }

    protected void storeEntity(net.minecraft.world.entity.Entity entity) {
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        NBTTagCompound compoundTag = new NBTTagCompound();
        entity.e(compoundTag);
        this.entities.add(FaweCompoundTag.of((LinCompoundTag)adapter.toNativeLin(compoundTag)));
    }

    @Override
    public Collection<FaweCompoundTag> entities() {
        return this.entities;
    }

    @Override
    @Nullable
    public FaweCompoundTag entity(UUID uuid) {
        for (FaweCompoundTag tag : this.entities) {
            if (!uuid.equals(NbtUtils.uuid(tag))) continue;
            return tag;
        }
        return null;
    }

    @Override
    public Set<Entity> getFullEntities() {
        throw new UnsupportedOperationException("Cannot get full entities from GET copy.");
    }

    @Override
    public boolean isCreateCopy() {
        return false;
    }

    @Override
    public int setCreateCopy(boolean createCopy) {
        return -1;
    }

    @Override
    public void setLightingToGet(char[][] lighting, int minSectionPosition, int maxSectionPosition) {
    }

    @Override
    public void setSkyLightingToGet(char[][] lighting, int minSectionPosition, int maxSectionPosition) {
    }

    @Override
    public void setHeightmapToGet(HeightMapType type, int[] data) {
    }

    @Override
    public int getMaxY() {
        return this.maxHeight;
    }

    @Override
    public int getMinY() {
        return this.minHeight;
    }

    @Override
    public int getMaxSectionPosition() {
        return this.maxHeight >> 4;
    }

    @Override
    public int getMinSectionPosition() {
        return this.minHeight >> 4;
    }

    @Override
    public int getX() {
        return this.chunkX;
    }

    @Override
    public int getZ() {
        return this.chunkZ;
    }

    @Override
    public BiomeType getBiomeType(int x, int y, int z) {
        Holder<BiomeBase> biome = this.biomes[(y >> 4) - this.getMinSectionPosition()][(y & 0xC) << 2 | z & 0xC | (x & 0xC) >> 2];
        return PaperweightPlatformAdapter.adapt(biome, (GeneratorAccess)this.serverLevel);
    }

    @Override
    public void removeSectionLighting(int layer, boolean sky) {
    }

    @Override
    public boolean trim(boolean aggressive, int layer) {
        return false;
    }

    @Override
    public IBlocks reset() {
        return null;
    }

    @Override
    public int getSectionCount() {
        return this.serverLevel.an();
    }

    protected void storeSection(int layer, char[] data) {
        this.blocks[layer] = data;
    }

    protected void storeBiomes(int layer, PalettedContainerRO<Holder<BiomeBase>> biomeData) {
        if (this.biomes == null) {
            this.biomes = new Holder[this.getSectionCount()][];
        }
        if (this.biomes[layer] == null) {
            this.biomes[layer] = new Holder[64];
        }
        if (biomeData instanceof DataPaletteBlock) {
            DataPaletteBlock palettedContainer = (DataPaletteBlock)biomeData;
            if (PaperLib.isPaper()) {
                for (int i = 0; i < 64; ++i) {
                    this.biomes[layer][i] = (Holder)palettedContainer.a(i);
                }
            } else {
                try {
                    for (int i = 0; i < 64; ++i) {
                        this.biomes[layer][i] = PaperweightPlatformAdapter.PALETTED_CONTAINER_GET.invoke(palettedContainer, i);
                    }
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            LOGGER.error("Cannot correctly save biomes to history. Expected class type {} but got {}", (Object)DataPaletteBlock.class.getSimpleName(), (Object)biomeData.getClass().getSimpleName());
        }
    }

    @Override
    public BaseBlock getFullBlock(int x, int y, int z) {
        BlockState state = BlockTypesCache.states[this.get(x, y, z)];
        return state.toBaseBlock(this, x, y, z);
    }

    @Override
    public boolean hasSection(int layer) {
        return this.blocks[layer -= this.getMinSectionPosition()] != null;
    }

    @Override
    public char[] load(int layer) {
        if (this.blocks[layer -= this.getMinSectionPosition()] == null) {
            this.blocks[layer] = new char[4096];
            Arrays.fill(this.blocks[layer], '\u0001');
        }
        return this.blocks[layer];
    }

    @Override
    public char[] loadIfPresent(int layer) {
        return this.blocks[layer -= this.getMinSectionPosition()];
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        return BlockTypesCache.states[this.get(x, y, z)];
    }

    @Override
    public Map<BlockVector3, FaweCompoundTag> tiles() {
        return this.tiles;
    }

    @Override
    @Nullable
    public FaweCompoundTag tile(int x, int y, int z) {
        return this.tiles.get(BlockVector3.at(x, y, z));
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        return 0;
    }

    @Override
    public int getEmittedLight(int x, int y, int z) {
        return 0;
    }

    @Override
    public int[] getHeightMap(HeightMapType type) {
        return new int[0];
    }

    @Override
    public <T extends Future<T>> T call(IQueueExtent<? extends IChunk> owner, IChunkSet set, Runnable finalize) {
        return null;
    }

    public char get(int x, int y, int z) {
        int layer = (y >> 4) - this.getMinSectionPosition();
        int index = (y & 0xF) << 8 | z << 4 | x;
        return this.blocks[layer][index];
    }

    @Override
    public boolean trim(boolean aggressive) {
        return false;
    }
}

