/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_4;

import com.fastasyncworldedit.core.extent.processor.PlacementStateProcessor;
import com.fastasyncworldedit.core.util.ExtentTraverser;
import com.fastasyncworldedit.core.wrappers.WorldWrapper;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_4.PaperweightBlockMaterial;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_4.PaperweightFaweAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_4.PaperweightFaweMutableBlockPlaceContext;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_4.PaperweightLevelProxy;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.BlockTypeMask;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;

public class PaperweightPlacementStateProcessor
extends PlacementStateProcessor {
    private final PaperweightFaweAdapter adapter = (PaperweightFaweAdapter)WorldEditPlugin.getInstance().getBukkitImplAdapter();
    private final PaperweightFaweMutableBlockPlaceContext mutableBlockPlaceContext;
    private final PaperweightLevelProxy proxyLevel;

    public PaperweightPlacementStateProcessor(Extent extent, BlockTypeMask mask, Region region) {
        super(extent, mask, region);
        BukkitWorld bukkitWorld;
        World world = ExtentTraverser.getWorldFromExtent(extent);
        if (world == null) {
            throw new UnsupportedOperationException("World is required for PlacementStateProcessor but none found in given extent.");
        }
        if (world instanceof WorldWrapper) {
            WorldWrapper wrapper = (WorldWrapper)world;
            bukkitWorld = (BukkitWorld)wrapper.getParent();
        } else {
            bukkitWorld = (BukkitWorld)world;
        }
        this.proxyLevel = PaperweightLevelProxy.getInstance(((CraftWorld)bukkitWorld.getWorld()).getHandle(), this);
        this.mutableBlockPlaceContext = new PaperweightFaweMutableBlockPlaceContext(this.proxyLevel);
    }

    private PaperweightPlacementStateProcessor(Extent extent, BlockTypeMask mask, Map<PlacementStateProcessor.SecondPass, Character> crossChunkSecondPasses, WorldServer serverLevel, ThreadLocal<PlacementStateProcessor> threadProcessors, Region region, AtomicBoolean finished) {
        super(extent, mask, crossChunkSecondPasses, threadProcessors, region, finished);
        this.proxyLevel = PaperweightLevelProxy.getInstance(serverLevel, this);
        this.mutableBlockPlaceContext = new PaperweightFaweMutableBlockPlaceContext(this.proxyLevel);
    }

    @Override
    protected char getStateAtFor(int x, int y, int z, BlockState state, Vector3 clickPos, Direction clickedFaceDirection, BlockVector3 clickedBlock) {
        BlockPosition blockPos;
        EnumDirection side;
        Vec3D pos;
        Block block = (Block)((PaperweightBlockMaterial)state.getMaterial()).getBlock();
        IBlockData newState = block.a((BlockActionContext)this.mutableBlockPlaceContext.withSetting(new MovingObjectPositionBlock(pos = new Vec3D(clickPos.x(), clickPos.y(), clickPos.z()), side = EnumDirection.valueOf((String)clickedFaceDirection.toString()), blockPos = new BlockPosition(clickedBlock.x(), clickedBlock.y(), clickedBlock.z()), false), side.g()));
        return newState == null ? (char)'\u0001' : this.adapter.ibdIDToOrdinal(Block.q.a((Object)newState));
    }

    @Override
    @Nullable
    public Extent construct(Extent child) {
        if (child == this.getExtent()) {
            return this;
        }
        return new PaperweightPlacementStateProcessor(child, this.mask, this.region);
    }

    @Override
    public PlacementStateProcessor fork() {
        return new PaperweightPlacementStateProcessor(this.extent, this.mask, this.postCompleteSecondPasses, this.proxyLevel.serverLevel, this.threadProcessors, this.region, this.finished);
    }
}

