/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_R1;

import com.fastasyncworldedit.core.util.ReflectionUtils;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_R1.PaperweightFaweAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_R1.PaperweightPlacementStateProcessor;
import com.sk89q.worldedit.world.block.BlockState;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import org.enginehub.linbus.tree.LinCompoundTag;
import org.enginehub.linbus.tree.LinTag;
import sun.misc.Unsafe;

public class PaperweightLevelProxy
extends WorldServer {
    protected WorldServer serverLevel;
    private PaperweightPlacementStateProcessor processor;
    private PaperweightFaweAdapter adapter;

    private PaperweightLevelProxy() {
        super(null, null, null, null, null, null, null, true, 0L, null, true, null, null, null, null);
        throw new IllegalStateException("Cannot be instantiated");
    }

    public static PaperweightLevelProxy getInstance(WorldServer serverLevel, PaperweightPlacementStateProcessor processor) {
        PaperweightLevelProxy newLevel;
        Unsafe unsafe = ReflectionUtils.getUnsafe();
        try {
            newLevel = (PaperweightLevelProxy)((Object)unsafe.allocateInstance(PaperweightLevelProxy.class));
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        newLevel.processor = processor;
        newLevel.adapter = (PaperweightFaweAdapter)WorldEditPlugin.getInstance().getBukkitImplAdapter();
        newLevel.serverLevel = serverLevel;
        return newLevel;
    }

    @Nullable
    public TileEntity c_(@Nonnull BlockPosition blockPos) {
        if (blockPos.u() == Integer.MAX_VALUE) {
            return null;
        }
        LinCompoundTag tag = this.processor.getTileAt(blockPos.u(), blockPos.v(), blockPos.w());
        if (tag == null) {
            return null;
        }
        IBlockData state = this.adapter.adapt(this.processor.getBlockStateAt(blockPos.u(), blockPos.v(), blockPos.w()));
        Block block = state.b();
        if (!(block instanceof ITileEntity)) {
            return null;
        }
        ITileEntity entityBlock = (ITileEntity)block;
        TileEntity tileEntity = entityBlock.a(blockPos, state);
        tileEntity.c((NBTTagCompound)this.adapter.fromNativeLin((LinTag)tag), (HolderLookup.a)this.serverLevel.H_());
        return tileEntity;
    }

    @Nonnull
    public IBlockData a_(@Nonnull BlockPosition blockPos) {
        if (blockPos.u() == Integer.MAX_VALUE) {
            return Blocks.a.o();
        }
        BlockState state = this.processor.getBlockStateAt(blockPos.u(), blockPos.v(), blockPos.w());
        return this.adapter.adapt(state);
    }

    @Nonnull
    public Fluid b_(@Nonnull BlockPosition pos) {
        if (pos.u() == Integer.MAX_VALUE) {
            return FluidTypes.a.g();
        }
        return this.a_(pos).u();
    }

    public boolean z(@Nonnull BlockPosition pos) {
        if (pos.u() == Integer.MAX_VALUE) {
            return false;
        }
        return this.a_(pos).u().a(TagsFluid.a);
    }

    public int J_() {
        return this.serverLevel.J_();
    }

    public int I_() {
        return this.serverLevel.I_();
    }

    public WorldBorder C_() {
        return this.serverLevel.C_();
    }
}

