/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.fastasyncworldedit.core.command.tool.TargetMode;
import com.fastasyncworldedit.core.command.tool.brush.BrushSettings;
import com.fastasyncworldedit.core.command.tool.scroll.Scroll;
import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.extent.ResettableExtent;
import com.fastasyncworldedit.core.util.MathMan;
import com.fastasyncworldedit.core.util.StringMan;
import com.google.common.collect.Iterables;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.command.argument.Arguments;
import com.sk89q.worldedit.command.tool.BrushTool;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.platform.CommandEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.PlatformCommandManager;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.command.CommandArgParser;
import com.sk89q.worldedit.internal.util.Substring;
import com.sk89q.worldedit.util.HandSide;
import java.util.List;
import java.util.Locale;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Arg;
import org.enginehub.piston.annotation.param.Switch;

@CommandContainer(superTypes={CommandPermissionsConditionGenerator.Registration.class})
public class ToolUtilCommands {
    private final WorldEdit we;

    public ToolUtilCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(name="mask", aliases={"/mask"}, desc="Set the brush destination mask")
    @CommandPermissions(value={"worldedit.brush.options.mask", "worldedit.mask.brush"})
    public void mask(Player player, LocalSession session, @Switch(name=104, desc="Whether the offhand should be considered or not") boolean offHand, @Arg(desc="The destination mask", def={""}) Mask maskOpt, Arguments arguments) throws WorldEditException {
        BrushTool tool = session.getBrushTool(player, false);
        if (tool == null) {
            player.print(Caption.of("fawe.worldedit.brush.brush.none", new Object[0]));
            return;
        }
        if (maskOpt == null) {
            player.print(Caption.of("worldedit.tool.mask.disabled", new Object[0]));
            tool.setMask(null);
        } else {
            BrushSettings settings = offHand ? tool.getOffHand() : tool.getContext();
            String lastArg = ((Substring)Iterables.getLast(CommandArgParser.spaceSplit(arguments.get()))).getSubstring();
            settings.addSetting(BrushSettings.SettingType.MASK, lastArg);
            settings.setMask(maskOpt);
            tool.update();
            player.print(Caption.of("worldedit.tool.mask.set", new Object[0]));
        }
    }

    @Command(name="material", aliases={"mat", "/material", "pattern"}, desc="Set the brush material")
    @CommandPermissions(value={"worldedit.brush.options.material"})
    public void material(Player player, LocalSession session, @Arg(desc="The pattern of blocks to use") Pattern pattern, @Switch(name=104, desc="Whether the offhand should be considered or not") boolean offHand, Arguments arguments) throws WorldEditException {
        BrushTool tool = session.getBrushTool(player, false);
        if (tool == null) {
            player.print(Caption.of("fawe.worldedit.brush.brush.none", new Object[0]));
            return;
        }
        if (pattern == null) {
            tool.setFill(null);
        } else {
            BrushSettings settings = offHand ? tool.getOffHand() : tool.getContext();
            settings.setFill(pattern);
            String lastArg = ((Substring)Iterables.getLast(CommandArgParser.spaceSplit(arguments.get()))).getSubstring();
            settings.addSetting(BrushSettings.SettingType.FILL, lastArg);
            tool.update();
        }
        player.print(Caption.of("worldedit.tool.material.set", new Object[0]));
    }

    @Command(name="range", aliases={"/range"}, desc="Set the brush range")
    @CommandPermissions(value={"worldedit.brush.options.range"})
    public void range(Player player, LocalSession session, @Arg(desc="The range of the brush") int range) throws WorldEditException {
        session.getBrushTool(player).setRange(range);
        player.print(Caption.of("worldedit.tool.range.set", new Object[0]));
    }

    @Command(name="size", desc="Set the brush size")
    @CommandPermissions(value={"worldedit.brush.options.size"})
    public void size(Player player, LocalSession session, @Arg(desc="The size of the brush") int size) throws WorldEditException {
        this.we.checkMaxBrushRadius(size, (Actor)player);
        session.getBrushTool(player).setSize(size);
        player.print(Caption.of("worldedit.tool.size.set", new Object[0]));
    }

    @Command(name="tracemask", aliases={"tarmask", "tm", "targetmask"}, desc="Set the mask used to stop tool traces")
    @CommandPermissions(value={"worldedit.brush.options.tracemask"})
    public void traceMask(Player player, LocalSession session, @Arg(desc="The trace mask to set", def={""}) Mask maskOpt) throws WorldEditException {
        BrushTool brushTool = session.getBrushTool(player, false);
        if (brushTool == null) {
            player.print(Caption.of("worldedit.brush.none.equipped", new Object[0]));
            return;
        }
        brushTool.setTraceMask(maskOpt);
        if (maskOpt == null) {
            player.print(Caption.of("worldedit.tool.tracemask.disabled", new Object[0]));
        } else {
            player.print(Caption.of("worldedit.tool.tracemask.set", new Object[0]));
        }
    }

    @Command(name="/", aliases={","}, desc="Toggle the super pickaxe function")
    @CommandPermissions(value={"worldedit.superpickaxe"})
    public void togglePickaxe(Player player, LocalSession session, @Arg(desc="The new super pickaxe state", def={""}) Boolean superPickaxe) {
        boolean hasSuperPickAxe = session.hasSuperPickAxe();
        if (superPickaxe != null && superPickaxe == hasSuperPickAxe) {
            player.print(Caption.of(superPickaxe != false ? "worldedit.tool.superpickaxe.enabled.already" : "worldedit.tool.superpickaxe.disabled.already", new Object[0]));
            return;
        }
        if (hasSuperPickAxe) {
            session.disableSuperPickAxe();
            player.print(Caption.of("worldedit.tool.superpickaxe.disabled", new Object[0]));
        } else {
            session.enableSuperPickAxe();
            player.print(Caption.of("worldedit.tool.superpickaxe.enabled", new Object[0]));
        }
    }

    @Command(name="primary", aliases={"/primary"}, desc="Set the right click brush", descFooter="Set the right click brush")
    @CommandPermissions(value={"worldedit.brush.primary"})
    public void primary(Player player, LocalSession session, @Arg(desc="The brush command", variable=true) List<String> commandStr) throws WorldEditException {
        BaseItemStack item = player.getItemInHand(HandSide.MAIN_HAND);
        BrushTool tool = session.getBrushTool(player, false);
        session.setTool(item, null, player);
        String cmd = "brush " + StringMan.join(commandStr, " ");
        CommandEvent event = new CommandEvent(player, cmd);
        PlatformCommandManager.getInstance().handleCommandOnCurrentThread(event);
        BrushTool newTool = session.getBrushTool(item, player, false);
        if (newTool != null && tool != null) {
            newTool.setSecondary(tool.getSecondary());
        }
    }

    @Command(name="secondary", aliases={"/secondary"}, desc="Set the left click brush", descFooter="Set the left click brush")
    @CommandPermissions(value={"worldedit.brush.secondary"})
    public void secondary(Player player, LocalSession session, @Arg(desc="The brush command", variable=true) List<String> commandStr) throws WorldEditException {
        BaseItemStack item = player.getItemInHand(HandSide.MAIN_HAND);
        BrushTool tool = session.getBrushTool(player, false);
        session.setTool(item, null, player);
        String cmd = "brush " + StringMan.join(commandStr, " ");
        CommandEvent event = new CommandEvent(player, cmd);
        PlatformCommandManager.getInstance().handleCommandOnCurrentThread(event);
        BrushTool newTool = session.getBrushTool(item, player, false);
        if (newTool != null && tool != null) {
            newTool.setPrimary(tool.getPrimary());
        }
    }

    @Command(name="target", aliases={"tar", "/target", "/tar"}, desc="Toggle between different target modes")
    @CommandPermissions(value={"worldedit.brush.target"})
    public void target(Player player, LocalSession session, @Arg(name="mode", desc="int", def={"0"}) int mode) throws WorldEditException {
        BrushTool tool = session.getBrushTool(player, false);
        if (tool == null) {
            player.print(Caption.of("fawe.worldedit.brush.brush.none", new Object[0]));
            return;
        }
        TargetMode[] modes = TargetMode.values();
        TargetMode newMode = modes[MathMan.wrap(mode, 0, modes.length - 1)];
        tool.setTargetMode(newMode);
        player.print(Caption.of("fawe.worldedit.brush.brush.target.mode.set", new Object[]{newMode}));
    }

    @Command(name="targetoffset", aliases={"to"}, desc="Set the targeting mask")
    @CommandPermissions(value={"worldedit.brush.targetoffset"})
    public void targetOffset(Player player, EditSession editSession, LocalSession session, @Arg(name="offset", desc="offset", def={"0"}) int offset) throws WorldEditException {
        BrushTool tool = session.getBrushTool(player, false);
        if (tool == null) {
            player.print(Caption.of("fawe.worldedit.brush.brush.none", new Object[0]));
            return;
        }
        tool.setTargetOffset(offset);
        player.print(Caption.of("fawe.worldedit.brush.brush.target.offset.set", offset));
    }

    @Command(name="scroll", desc="Toggle between different target modes")
    @CommandPermissions(value={"worldedit.brush.scroll"})
    public void scroll(Player player, EditSession editSession, LocalSession session, @Switch(name=104, desc="Whether the offhand should be considered or not") boolean offHand, @Arg(desc="Target Modes", def={"none"}) Scroll.Action mode, @Arg(desc="The scroll action", variable=true) List<String> commandStr) throws WorldEditException {
        BrushTool bt = session.getBrushTool(player, false);
        if (bt == null) {
            player.print(Caption.of("fawe.worldedit.brush.brush.none", new Object[0]));
            return;
        }
        BrushSettings settings = offHand ? bt.getOffHand() : bt.getContext();
        Scroll action = Scroll.fromArguments(bt, player, session, mode, commandStr, true);
        settings.setScrollAction(action);
        if (mode == Scroll.Action.NONE) {
            player.print(Caption.of("fawe.worldedit.brush.brush.scroll.action.unset", new Object[0]));
        } else if (action != null) {
            String full = (mode.name().toLowerCase(Locale.ROOT) + " " + StringMan.join(commandStr, " ")).trim();
            settings.addSetting(BrushSettings.SettingType.SCROLL_ACTION, full);
            player.print(Caption.of("fawe.worldedit.brush.brush.scroll.action.set", new Object[]{mode}));
        }
        bt.update();
    }

    @Command(name="smask", aliases={"/smask", "/sourcemask", "sourcemask"}, desc="Set the brush source mask", descFooter="Set the brush source mask")
    @CommandPermissions(value={"worldedit.brush.options.mask", "worldedit.mask.brush"})
    public void smask(Player player, LocalSession session, EditSession editSession, @Arg(desc="The destination mask", def={""}) Mask maskArg, @Switch(name=104, desc="Whether the offhand should be considered or not") boolean offHand, Arguments arguments) throws WorldEditException {
        BrushTool tool = session.getBrushTool(player, false);
        if (tool == null) {
            player.print(Caption.of("fawe.worldedit.brush.brush.none", new Object[0]));
            return;
        }
        if (maskArg == null) {
            player.print(Caption.of("fawe.worldedit.brush.brush.source.mask.disabled", new Object[0]));
            tool.setSourceMask(null);
            return;
        }
        BrushSettings settings = offHand ? tool.getOffHand() : tool.getContext();
        String lastArg = ((Substring)Iterables.getLast(CommandArgParser.spaceSplit(arguments.get()))).getSubstring();
        settings.addSetting(BrushSettings.SettingType.SOURCE_MASK, lastArg);
        settings.setSourceMask(maskArg);
        tool.update();
        player.print(Caption.of("fawe.worldedit.brush.brush.source.mask", new Object[0]));
    }

    @Command(name="transform", aliases={"/transform"}, desc="Set the brush transform")
    @CommandPermissions(value={"worldedit.brush.options.transform", "worldedit.transform.brush"})
    public void transform(Player player, LocalSession session, EditSession editSession, @Arg(desc="The transform", def={""}) ResettableExtent transform, @Switch(name=104, desc="Whether the offhand should be considered or not") boolean offHand, Arguments arguments) throws WorldEditException {
        BrushTool tool = session.getBrushTool(player, false);
        if (tool == null) {
            player.print(Caption.of("fawe.worldedit.brush.brush.none", new Object[0]));
            return;
        }
        if (transform == null) {
            player.print(Caption.of("fawe.worldedit.brush.brush.transform.disabled", new Object[0]));
            tool.setTransform(null);
            return;
        }
        BrushSettings settings = offHand ? tool.getOffHand() : tool.getContext();
        String lastArg = ((Substring)Iterables.getLast(CommandArgParser.spaceSplit(arguments.get()))).getSubstring();
        settings.addSetting(BrushSettings.SettingType.TRANSFORM, lastArg);
        settings.setTransform(transform);
        tool.update();
        player.print(Caption.of("fawe.worldedit.brush.brush.transform", new Object[0]));
    }
}

