/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.entity;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.util.concurrency.LazyReference;
import com.sk89q.worldedit.world.NbtValued;
import com.sk89q.worldedit.world.entity.EntityType;
import com.sk89q.worldedit.world.entity.EntityTypes;
import java.util.UUID;
import javax.annotation.Nullable;
import org.enginehub.linbus.tree.LinCompoundTag;
import org.enginehub.linbus.tree.LinIntArrayTag;
import org.enginehub.linbus.tree.LinLongTag;

public class BaseEntity
implements NbtValued {
    private final EntityType type;
    @Nullable
    private LazyReference<LinCompoundTag> nbtData;

    @Deprecated
    public BaseEntity(EntityType type, CompoundTag nbtData) {
        this(type);
        this.setNbtData(nbtData);
    }

    public BaseEntity(EntityType type, LazyReference<LinCompoundTag> nbtData) {
        this(type);
        this.setNbtReference(nbtData);
    }

    public BaseEntity(EntityType type) {
        this.type = type;
    }

    public BaseEntity(BaseEntity other) {
        Preconditions.checkNotNull((Object)other);
        this.type = other.getType();
        this.setNbtReference(other.getNbtReference());
    }

    @Override
    @Nullable
    public LazyReference<LinCompoundTag> getNbtReference() {
        return this.nbtData;
    }

    @Override
    public void setNbtReference(@Nullable LazyReference<LinCompoundTag> nbtData) {
        this.nbtData = nbtData;
    }

    public EntityType getType() {
        return this.type;
    }

    public BaseEntity(CompoundTag tag) {
        this(EntityTypes.parse(tag.getString("Id")), tag);
    }

    @Nullable
    public UUID getUUID() {
        LinCompoundTag tag = this.getNbt();
        if (tag == null) {
            return null;
        }
        Object value = tag.value();
        Object v = value.get("UUID");
        if (v instanceof LinIntArrayTag) {
            LinIntArrayTag intArrayTag = (LinIntArrayTag)v;
            int[] arr = intArrayTag.value();
            return new UUID((long)arr[0] << 32 | (long)arr[1] & 0xFFFFFFFFL, (long)arr[2] << 32 | (long)arr[3] & 0xFFFFFFFFL);
        }
        v = value.get("UUIDMost");
        if (v instanceof LinLongTag) {
            LinLongTag longTag = (LinLongTag)v;
            return new UUID(longTag.value(), ((LinLongTag)value.get("UUIDLeast")).value());
        }
        v = value.get("WorldUUIDMost");
        if (v instanceof LinLongTag) {
            LinLongTag longTag = (LinLongTag)v;
            return new UUID(longTag.value(), ((LinLongTag)value.get("WorldUUIDLeast")).value());
        }
        v = value.get("PersistentIDMSB");
        if (v instanceof LinLongTag) {
            LinLongTag longTag = (LinLongTag)v;
            return new UUID(longTag.value(), ((LinLongTag)value.get("PersistentIDLSB")).value());
        }
        return null;
    }
}

