/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.adapter;

import com.fastasyncworldedit.bukkit.adapter.CachedBukkitAdapter;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;

public class SimpleBukkitAdapter
extends CachedBukkitAdapter {
    private BlockData[][] blockDataCache;

    private boolean init() {
        if (this.blockDataCache != null) {
            return false;
        }
        this.blockDataCache = new BlockData[BlockTypes.size()][];
        this.blockDataCache[0] = new BlockData[]{Material.AIR.createBlockData()};
        return true;
    }

    @Override
    protected int[] getIbdToOrdinal() {
        return new int[65536];
    }

    @Override
    protected int[] getOrdinalToIbdID() {
        return new int[65536];
    }

    @Override
    public <B extends BlockStateHolder<B>> BlockData adapt(B block) {
        try {
            int propId;
            BlockData blockData;
            Preconditions.checkNotNull(block);
            int typeId = block.getInternalBlockTypeId();
            BlockData[] dataCache = this.blockDataCache[typeId];
            if (dataCache == null) {
                BlockType type = BlockTypes.get(typeId);
                dataCache = new BlockData[type.getMaxStateId() + 1];
                this.blockDataCache[typeId] = dataCache;
            }
            if ((blockData = dataCache[propId = block.getInternalPropertiesId()]) == null) {
                dataCache[propId] = blockData = Bukkit.createBlockData((String)block.getAsString());
            }
            return blockData;
        }
        catch (NullPointerException e) {
            if (this.init()) {
                return this.adapt(block);
            }
            throw e;
        }
    }
}

