/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.configuration;

import com.fastasyncworldedit.core.configuration.ConfigOptComputation;
import com.fastasyncworldedit.core.configuration.MemorySection;
import com.fastasyncworldedit.core.configuration.file.YamlConfiguration;
import com.fastasyncworldedit.core.util.StringMan;
import com.sk89q.util.StringUtil;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;

public class Config {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private final Map<String, Object> removedKeyVals = new HashMap<String, Object>();
    @Nullable
    private Map<String, FromNode> copyTo = new HashMap<String, FromNode>();
    private boolean performCopyTo = false;
    private List<String> existingMigrateNodes = null;

    public Config() {
        this.save(new PrintWriter(new ByteArrayOutputStream(0)), this.getClass(), this, 0, null);
        this.performCopyTo = true;
    }

    private <T> T get(String key, Class<?> root) {
        Field field;
        String[] split = key.split("\\.");
        Object instance = this.getInstance(split, root);
        if (instance != null && (field = this.getField(split, instance)) != null) {
            try {
                return (T)field.get(instance);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Failed to get config option: {}", (Object)key, (Object)e);
                return null;
            }
        }
        LOGGER.error("Failed to get config option: {}", (Object)key);
        return null;
    }

    private void setLoadedNode(String key, Object value, Class<?> root) {
        Field field;
        String[] split = key.split("\\.");
        Object instance = this.getInstance(split, root);
        if (instance != null && (field = this.getField(split, instance)) != null) {
            try {
                Migrate migrate;
                if (field.getAnnotation(Final.class) != null) {
                    return;
                }
                if (this.copyTo != null) {
                    this.copyTo.remove(key);
                    Object finalValue = value;
                    this.copyTo.replaceAll((copyToNode, fromNode) -> {
                        if (!key.equals(fromNode.node())) {
                            return fromNode;
                        }
                        return new FromNode(key, fromNode.computation, finalValue);
                    });
                }
                if ((migrate = field.getAnnotation(Migrate.class)) != null) {
                    this.existingMigrateNodes.add(migrate.value());
                }
                if (field.getType() == String.class && !(value instanceof String)) {
                    value = String.valueOf(value);
                }
                field.set(instance, value);
                return;
            }
            catch (Throwable e) {
                LOGGER.error("Failed to set config option: {}", (Object)key);
            }
        }
        this.removedKeyVals.put(key, value);
        LOGGER.warn("Failed to set config option: {}: {} | {} | {}.yml. This is likely because it was removed or was set with an invalid value.", (Object)key, value, instance, (Object)root.getSimpleName());
    }

    public boolean load(File file) {
        if (!file.exists()) {
            return false;
        }
        this.existingMigrateNodes = new ArrayList<String>();
        YamlConfiguration yml = YamlConfiguration.loadConfiguration(file);
        for (String key : yml.getKeys(true)) {
            Object value = yml.get(key);
            if (value instanceof MemorySection) continue;
            this.setLoadedNode(key, value, this.getClass());
        }
        for (String node : this.existingMigrateNodes) {
            this.removedKeyVals.remove(node);
        }
        this.existingMigrateNodes = null;
        return true;
    }

    public void save(File file) {
        try {
            if (!file.exists()) {
                File parent = file.getParentFile();
                if (parent != null) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
            PrintWriter writer = new PrintWriter(file);
            Config instance = this;
            this.save(writer, this.getClass(), instance, 0, null);
            writer.close();
        }
        catch (Throwable e) {
            LOGGER.error("Failed to save config file: {}", (Object)file, (Object)e);
        }
    }

    private String toYamlString(Object value, String spacing) {
        if (value instanceof List) {
            Collection listValue = (Collection)value;
            if (listValue.isEmpty()) {
                return "[]";
            }
            StringBuilder m = new StringBuilder();
            for (Object obj : listValue) {
                m.append(System.lineSeparator()).append(spacing).append("- ").append(this.toYamlString(obj, spacing));
            }
            return m.toString();
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue.isEmpty()) {
                return "''";
            }
            return "\"" + stringValue + "\"";
        }
        return value != null ? value.toString() : "null";
    }

    private void save(PrintWriter writer, Class<?> clazz, Object instance, int indent, String parentNode) {
        try {
            String CTRF = System.lineSeparator();
            String spacing = StringMan.repeat(" ", indent);
            for (Field field : clazz.getFields()) {
                Create create;
                ComputedFrom computedFrom;
                CopiedFrom copiedFrom;
                Object value;
                Migrate migrate;
                if (field.getAnnotation(Ignore.class) != null) continue;
                Class current = field.getType();
                if (field.getAnnotation(Ignore.class) != null) continue;
                Comment comment = field.getAnnotation(Comment.class);
                if (comment != null) {
                    for (String commentLine : comment.value()) {
                        writer.write(spacing + "# " + commentLine + CTRF);
                    }
                }
                if (current == ConfigBlock.class) {
                    current = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                    this.handleConfigBlockSave(writer, instance, indent, field, spacing, CTRF, current, parentNode);
                    continue;
                }
                if (!this.removedKeyVals.isEmpty() && (migrate = field.getAnnotation(Migrate.class)) != null && (value = this.removedKeyVals.remove(migrate.value())) != null) {
                    field.set(instance, value);
                }
                if (this.copyTo != null && (copiedFrom = field.getAnnotation(CopiedFrom.class)) != null) {
                    Object node = this.toNodeName(field.getName());
                    node = parentNode == null ? node : parentNode + "." + (String)node;
                    FromNode entry = this.copyTo.remove(node);
                    if (entry == null) {
                        this.copyTo.put((String)node, new FromNode(copiedFrom.value(), null, null));
                    } else {
                        Object copiedVal = entry.val();
                        if (copiedVal != null) {
                            field.set(instance, copiedVal);
                        }
                    }
                }
                if (this.copyTo != null && (computedFrom = field.getAnnotation(ComputedFrom.class)) != null) {
                    Object node = this.toNodeName(field.getName());
                    node = parentNode == null ? node : parentNode + "." + (String)node;
                    FromNode entry = this.copyTo.remove(node);
                    if (entry == null) {
                        this.copyTo.put((String)node, new FromNode(computedFrom.node(), computedFrom.computer(), null));
                    } else {
                        Object object = entry.val();
                        if (object != null) {
                            ConfigOptComputation<?> computer = computedFrom.computer().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            field.set(instance, computer.apply(object));
                        }
                    }
                }
                if ((create = field.getAnnotation(Create.class)) != null) {
                    Object value2 = field.get(instance);
                    this.setAccessible(field);
                    if (indent == 0) {
                        writer.write(CTRF);
                    }
                    if ((comment = current.getAnnotation(Comment.class)) != null) {
                        for (String commentLine : comment.value()) {
                            writer.write(spacing + "# " + commentLine + CTRF);
                        }
                    }
                    String string = this.toNodeName(current.getSimpleName());
                    writer.write(spacing + string + ":" + CTRF);
                    if (value2 == null) {
                        value2 = current.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        field.set(instance, value2);
                    }
                    this.save(writer, current, value2, indent + 2, (String)(parentNode == null ? string : parentNode + "." + string));
                    continue;
                }
                writer.write(spacing + this.toNodeName(field.getName() + ": ") + this.toYamlString(field.get(instance), spacing) + CTRF);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Failed to save config file", e);
        }
        if (parentNode == null && this.performCopyTo) {
            this.performCopyTo = false;
            this.copyTo = null;
        }
    }

    private <T> void handleConfigBlockSave(PrintWriter writer, Object instance, int indent, Field field, String spacing, String CTRF, Class<T> current, String parentNode) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        BlockName blockNames;
        Comment comment = current.getAnnotation(Comment.class);
        if (comment != null) {
            for (String commentLine : comment.value()) {
                writer.write(spacing + "# " + commentLine + CTRF);
            }
        }
        if ((blockNames = current.getAnnotation(BlockName.class)) != null) {
            String node = this.toNodeName(current.getSimpleName());
            writer.write(spacing + this.toNodeName(current.getSimpleName()) + ":" + CTRF);
            ConfigBlock<T> configBlock = (ConfigBlock<T>)field.get(instance);
            if (configBlock == null || configBlock.getInstances().isEmpty()) {
                configBlock = new ConfigBlock<T>();
                field.set(instance, configBlock);
                for (String blockName : blockNames.value()) {
                    configBlock.put(blockName, current.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
            }
            for (Map.Entry entry : configBlock.getRaw().entrySet()) {
                String key = (String)entry.getKey();
                writer.write(spacing + "  " + this.toNodeName(key) + ":" + CTRF);
                this.save(writer, current, entry.getValue(), indent + 4, (String)(parentNode == null ? node : parentNode + "." + node));
            }
        }
    }

    private Field getField(String[] split, Object instance) {
        try {
            Field field = instance.getClass().getField(this.toFieldName(split[split.length - 1]));
            this.setAccessible(field);
            return field;
        }
        catch (Throwable ignored) {
            LOGGER.warn("Invalid config field: {} for {}. It is possible this is because it has been removed.", (Object)StringMan.join(split, "."), (Object)this.toNodeName(instance.getClass().getSimpleName()));
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getInstance(String[] split, Class<?> root) {
        try {
            Class<?> clazz = root == null ? MethodHandles.lookup().lookupClass() : root;
            Object instance = this;
            while (split.length > 0) {
                Class<?>[] classes;
                if (split.length == 1) {
                    return instance;
                }
                Class<?> found = null;
                for (Class<?> current : classes = clazz.getDeclaredClasses()) {
                    if (!StringMan.isEqual(current.getSimpleName(), this.toFieldName(split[0]))) continue;
                    found = current;
                    break;
                }
                try {
                    Field instanceField = clazz.getDeclaredField(this.toFieldName(split[0]));
                    this.setAccessible(instanceField);
                    if (instanceField.getType() != ConfigBlock.class) {
                        Object value = instanceField.get(instance);
                        if (value == null) {
                            value = found.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            instanceField.set(instance, value);
                        }
                        clazz = found;
                        instance = value;
                        split = Arrays.copyOfRange(split, 1, split.length);
                        continue;
                    }
                    ConfigBlock<Object> value = (ConfigBlock<Object>)instanceField.get(instance);
                    if (value == null) {
                        value = new ConfigBlock<Object>();
                        instanceField.set(instance, value);
                    }
                    if ((instance = value.get(split[1])) == null) {
                        instance = found.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        value.put(split[1], instance);
                    }
                    clazz = found;
                    split = Arrays.copyOfRange(split, 2, split.length);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    if (found == null) return null;
                    split = Arrays.copyOfRange(split, 1, split.length);
                    clazz = found;
                    instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    continue;
                    return null;
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("Failed retrieving instance for config node: {}", (Object)StringUtil.joinString(split, "."), (Object)e);
        }
        return null;
    }

    private String toFieldName(String node) {
        return node.toUpperCase(Locale.ROOT).replaceAll("-", "_");
    }

    private String toNodeName(String field) {
        return field.toLowerCase(Locale.ROOT).replace("_", "-");
    }

    private void setAccessible(Field field) throws NoSuchFieldException, IllegalAccessException {
        field.setAccessible(true);
        if (Modifier.isFinal(field.getModifiers())) {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Final {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Migrate {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.TYPE})
    public static @interface Ignore {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.TYPE})
    public static @interface Comment {
        public String[] value();
    }

    @Ignore
    public static class ConfigBlock<T> {
        private final HashMap<String, T> INSTANCES = new HashMap();

        public T remove(String key) {
            return this.INSTANCES.remove(key);
        }

        public T get(String key) {
            return this.INSTANCES.get(key);
        }

        public void put(String key, T value) {
            this.INSTANCES.put(key, value);
        }

        public Collection<T> getInstances() {
            return this.INSTANCES.values();
        }

        public Collection<String> getSections() {
            return this.INSTANCES.keySet();
        }

        private Map<String, T> getRaw() {
            return this.INSTANCES;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface CopiedFrom {
        public String value();
    }

    private record FromNode(String node, Class<? extends ConfigOptComputation<?>> computation, Object val) {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface ComputedFrom {
        public String node();

        public Class<? extends ConfigOptComputation<?>> computer();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Create {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.TYPE})
    public static @interface BlockName {
        public String[] value();
    }
}

