/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extent;

import com.fastasyncworldedit.core.extent.processor.ProcessorScope;
import com.fastasyncworldedit.core.math.LocalBlockVector2Set;
import com.fastasyncworldedit.core.queue.IBatchProcessor;
import com.fastasyncworldedit.core.queue.IChunk;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.fastasyncworldedit.core.queue.IQueueChunk;
import com.fastasyncworldedit.core.queue.IQueueExtent;
import com.fastasyncworldedit.core.util.ExtentTraverser;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.Nullable;

public class OncePerChunkExtent
extends AbstractDelegateExtent
implements IBatchProcessor {
    private final LocalBlockVector2Set set = new LocalBlockVector2Set();
    private final IQueueExtent<IQueueChunk> queue;
    private Consumer<IChunkGet> task;
    private volatile long lastPair = Long.MAX_VALUE;

    public OncePerChunkExtent(@Nonnull Extent extent, @Nonnull IQueueExtent<IQueueChunk> queue, @Nonnull Consumer<IChunkGet> task) {
        super(extent);
        this.queue = Objects.requireNonNull(queue);
        this.task = Objects.requireNonNull(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldRun(int chunkX, int chunkZ) {
        LocalBlockVector2Set localBlockVector2Set = this.set;
        synchronized (localBlockVector2Set) {
            long pair = (long)chunkX << 32 | (long)chunkZ & 0xFFFFFFFFL;
            if (pair == this.lastPair) {
                return false;
            }
            this.lastPair = pair;
            return this.set.add(chunkX, chunkZ);
        }
    }

    private void checkAndRun(int chunkX, int chunkZ) {
        if (this.shouldRun(chunkX, chunkZ)) {
            this.task.accept(this.queue.getCachedGet(chunkX, chunkZ));
        }
    }

    public Consumer<IChunkGet> getTask() {
        return this.task;
    }

    public void setTask(Consumer<IChunkGet> task) {
        this.task = task;
    }

    @Override
    public IChunkSet processSet(IChunk chunk, IChunkGet get, IChunkSet set) {
        return set;
    }

    @Override
    public IChunkGet processGet(IChunkGet get) {
        if (this.shouldRun(get.getX(), get.getZ())) {
            this.task.accept(get);
        }
        return get;
    }

    @Override
    @Nullable
    public Extent construct(Extent child) {
        if (this.getExtent() != child) {
            new ExtentTraverser<OncePerChunkExtent>(this).setNext((OncePerChunkExtent)child);
        }
        return this;
    }

    @Override
    public ProcessorScope getScope() {
        return ProcessorScope.READING_BLOCKS;
    }

    @Override
    public BlockState getBlock(BlockVector3 position) {
        this.checkAndRun(position.x() >> 4, position.z() >> 4);
        return super.getBlock(position);
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        this.checkAndRun(x >> 4, z >> 4);
        return super.getBlock(x, y, z);
    }

    @Override
    public BaseBlock getFullBlock(BlockVector3 position) {
        this.checkAndRun(position.x() >> 4, position.z() >> 4);
        return super.getFullBlock(position);
    }

    @Override
    public BaseBlock getFullBlock(int x, int y, int z) {
        this.checkAndRun(x >> 4, z >> 4);
        return super.getFullBlock(x, y, z);
    }

    @Override
    public BiomeType getBiomeType(int x, int y, int z) {
        this.checkAndRun(x >> 4, z >> 4);
        return super.getBiomeType(x, y, z);
    }

    @Override
    public BiomeType getBiome(BlockVector3 position) {
        this.checkAndRun(position.x() >> 4, position.z() >> 4);
        return super.getBiome(position);
    }

    @Override
    public int getEmittedLight(int x, int y, int z) {
        this.checkAndRun(x >> 4, z >> 4);
        return super.getEmittedLight(x, y, z);
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        this.checkAndRun(x >> 4, z >> 4);
        return super.getSkyLight(x, y, z);
    }

    @Override
    public int getBrightness(int x, int y, int z) {
        this.checkAndRun(x >> 4, z >> 4);
        return super.getBrightness(x, y, z);
    }

    @Override
    public boolean setBiome(int x, int y, int z, BiomeType biome) {
        this.checkAndRun(x >> 4, z >> 4);
        return super.setBiome(x, y, z, biome);
    }

    @Override
    public boolean setBiome(BlockVector3 position, BiomeType biome) {
        this.checkAndRun(position.x() >> 4, position.z() >> 4);
        return super.setBiome(position, biome);
    }

    @Override
    public void setBlockLight(int x, int y, int z, int value) {
        this.checkAndRun(x >> 4, z >> 4);
        super.setBlockLight(x, y, z, value);
    }

    @Override
    public void setSkyLight(int x, int y, int z, int value) {
        this.checkAndRun(x >> 4, z >> 4);
        super.setSkyLight(x, y, z, value);
    }

    public void reset() {
        this.lastPair = Long.MAX_VALUE;
        this.set.clear();
    }
}

