/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extent.clipboard;

import com.fastasyncworldedit.core.extent.clipboard.SimpleClipboard;
import com.fastasyncworldedit.core.extent.filter.block.AbstractFilterBlock;
import com.fastasyncworldedit.core.function.visitor.Order;
import com.fastasyncworldedit.core.jnbt.streamer.IntValueReader;
import com.google.common.collect.ForwardingIterator;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.NBTUtils;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class LinearClipboard
extends SimpleClipboard {
    protected final HashSet<BlockArrayClipboard.ClipboardEntity> entities = new HashSet();

    public LinearClipboard(BlockVector3 dimensions, BlockVector3 offset) {
        super(dimensions, offset);
    }

    public abstract <B extends BlockStateHolder<B>> boolean setBlock(int var1, B var2);

    public abstract BaseBlock getFullBlock(int var1);

    public abstract BlockState getBlock(int var1);

    public abstract void setBiome(int var1, BiomeType var2);

    public abstract BiomeType getBiome(int var1);

    public abstract void streamBiomes(IntValueReader var1);

    @Deprecated(forRemoval=true, since="2.12.0")
    public abstract Collection<CompoundTag> getTileEntities();

    protected void finalize() {
        this.close();
    }

    @Override
    @Nonnull
    public Iterator<BlockVector3> iterator() {
        return this.iterator(Order.YZX);
    }

    @Override
    public Iterator<BlockVector3> iterator(Order order) {
        Region region = this.getRegion();
        if (order == Order.YZX && region instanceof CuboidRegion) {
            final Iterator<BlockVector3> iter = ((CuboidRegion)region).iterator_old();
            final LinearFilter filter = new LinearFilter();
            return new ForwardingIterator<BlockVector3>(this){

                protected Iterator<BlockVector3> delegate() {
                    return iter;
                }

                public BlockVector3 next() {
                    return filter.next((BlockVector3)super.next());
                }
            };
        }
        return order.create(region);
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity entity) {
        BlockArrayClipboard.ClipboardEntity ret = new BlockArrayClipboard.ClipboardEntity(location, entity);
        this.entities.add(ret);
        return ret;
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity entity, UUID uuid) {
        HashMap map = new HashMap((Map<String, Tag<?, ?>>)entity.getNbtData().getValue());
        NBTUtils.addUUIDToMap(map, uuid);
        entity.setNbtData(new CompoundTag(map));
        BlockArrayClipboard.ClipboardEntity ret = new BlockArrayClipboard.ClipboardEntity(location, entity);
        this.entities.add(ret);
        return ret;
    }

    @Override
    public void removeEntity(int x, int y, int z, UUID uuid) {
        Iterator<BlockArrayClipboard.ClipboardEntity> iter = this.entities.iterator();
        while (iter.hasNext()) {
            BlockArrayClipboard.ClipboardEntity entity = iter.next();
            UUID entUUID = entity.getState().getUUID();
            if (!uuid.equals(entUUID)) continue;
            iter.remove();
            return;
        }
    }

    @Override
    public List<? extends Entity> getEntities() {
        return new ArrayList<BlockArrayClipboard.ClipboardEntity>(this.entities);
    }

    @Override
    public void removeEntity(Entity entity) {
        if (!(entity instanceof BlockArrayClipboard.ClipboardEntity)) {
            Location loc = entity.getLocation();
            this.removeEntity(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), entity.getState().getUUID());
        } else {
            this.entities.remove(entity);
        }
    }

    @Override
    public List<? extends Entity> getEntities(Region region) {
        return this.entities.stream().filter(e -> region.contains(e.getLocation().toBlockPoint())).collect(Collectors.toList());
    }

    private class LinearFilter
    extends AbstractFilterBlock {
        private int index = -1;
        private BlockVector3 position;

        private LinearFilter() {
        }

        private LinearFilter next(BlockVector3 position) {
            this.position = position;
            ++this.index;
            return this;
        }

        @Override
        public BaseBlock getFullBlock() {
            return LinearClipboard.this.getFullBlock(this.index);
        }

        @Override
        public void setFullBlock(BaseBlock block) {
            LinearClipboard.this.setBlock(this.index, block);
        }

        @Override
        public BiomeType getBiome() {
            return LinearClipboard.this.getBiome(this.position);
        }

        @Override
        public void setBiome(BiomeType type) {
            LinearClipboard.this.setBiome(this.position, type);
        }

        @Override
        public BlockVector3 getPosition() {
            return this.position;
        }

        @Override
        public Extent getExtent() {
            return LinearClipboard.this;
        }
    }
}

