/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extent.processor;

import com.fastasyncworldedit.core.extent.processor.ProcessorScope;
import com.fastasyncworldedit.core.queue.IBatchProcessor;
import com.fastasyncworldedit.core.queue.IChunk;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BlockTypes;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class EntityInBlockRemovingProcessor
implements IBatchProcessor {
    private static final Logger LOGGER = LogManagerCompat.getLogger();

    @Override
    public IChunkSet processSet(IChunk chunk, IChunkGet get, IChunkSet set) {
        try {
            for (CompoundTag tag : get.getEntities()) {
                if (tag.getList("Pos").size() == 0) continue;
                BlockVector3 pos = tag.getEntityPosition().toBlockPoint();
                int x = pos.x() & 0xF;
                int y = pos.y();
                int z = pos.z() & 0xF;
                if (!set.hasSection(y >> 4) || set.getBlock(x, y, z).getBlockType() == BlockTypes.__RESERVED__ || set.getBlock(x, y, z).getBlockType().getMaterial().isAir()) continue;
                set.removeEntity(tag.getUUID());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not remove entities in blocks in chunk {},{}", (Object)chunk.getX(), (Object)chunk.getZ(), (Object)e);
        }
        return set;
    }

    @Override
    @Nullable
    public Extent construct(Extent child) {
        throw new UnsupportedOperationException("Processing only");
    }

    @Override
    public ProcessorScope getScope() {
        return ProcessorScope.CUSTOM;
    }
}

