/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extent.processor;

import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.extent.NullExtent;
import com.fastasyncworldedit.core.extent.filter.block.FilterBlock;
import com.fastasyncworldedit.core.extent.processor.ProcessorScope;
import com.fastasyncworldedit.core.function.mask.AdjacentAny2DMask;
import com.fastasyncworldedit.core.math.BlockVector3ChunkMap;
import com.fastasyncworldedit.core.math.MutableBlockVector3;
import com.fastasyncworldedit.core.math.MutableVector3;
import com.fastasyncworldedit.core.nbt.FaweCompoundTag;
import com.fastasyncworldedit.core.queue.IBatchProcessor;
import com.fastasyncworldedit.core.queue.IChunk;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.fastasyncworldedit.core.registry.state.PropertyKey;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.BlockCategoryMask;
import com.sk89q.worldedit.function.mask.BlockTypeMask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockCategories;
import com.sk89q.worldedit.world.block.BlockCategory;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.enginehub.linbus.tree.LinCompoundTag;

public abstract class PlacementStateProcessor
extends AbstractDelegateExtent
implements IBatchProcessor,
Pattern {
    private static final Direction[] NESW = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private static final int CHUNK_BLOCK_POS_MASK = -16;
    private static volatile boolean SETUP = false;
    private static BlockTypeMask DEFAULT_MASK = null;
    private static BlockTypeMask IN_FIRST_PASS = null;
    private static BlockTypeMask REQUIRES_SECOND_PASS = null;
    private static BlockTypeMask IN_FIRST_PASS_WITHOUT_SECOND = null;
    private static AdjacentAny2DMask ADJACENT_STAIR_MASK = null;
    protected final Extent extent;
    protected final BlockTypeMask mask;
    protected final Region region;
    protected final Map<SecondPass, Character> postCompleteSecondPasses;
    protected final ThreadLocal<PlacementStateProcessor> threadProcessors;
    protected final AtomicBoolean finished;
    private final MutableVector3 clickPos = new MutableVector3();
    private final MutableBlockVector3 clickedBlock = new MutableBlockVector3();
    private final MutableBlockVector3 placedBlock = new MutableBlockVector3(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private IChunkGet processChunkGet = null;
    private IChunkSet processChunkSet = null;
    private int processChunkX;
    private int processChunkZ;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public PlacementStateProcessor(Extent extent, BlockTypeMask mask, Region region) {
        super(extent);
        if (!SETUP) {
            Class<PlacementStateProcessor> clazz = PlacementStateProcessor.class;
            // MONITORENTER : com.fastasyncworldedit.core.extent.processor.PlacementStateProcessor.class
            if (!SETUP) {
                PlacementStateProcessor.setup();
            }
            // MONITOREXIT : clazz
        }
        this.extent = extent;
        this.mask = mask == null ? DEFAULT_MASK : mask;
        this.region = region;
        this.postCompleteSecondPasses = new ConcurrentHashMap<SecondPass, Character>();
        this.threadProcessors = ThreadLocal.withInitial(this::fork);
        this.finished = new AtomicBoolean();
    }

    protected PlacementStateProcessor(Extent extent, BlockTypeMask mask, Map<SecondPass, Character> crossChunkSecondPasses, ThreadLocal<PlacementStateProcessor> threadProcessors, Region region, AtomicBoolean finished) {
        super(extent);
        this.extent = extent;
        this.mask = mask;
        this.region = region;
        this.postCompleteSecondPasses = crossChunkSecondPasses;
        this.threadProcessors = threadProcessors;
        this.finished = finished;
    }

    private static void setup() {
        BlockCategory[] categories;
        NullExtent nullExtent = new NullExtent((Extent)com.sk89q.worldedit.extent.NullExtent.INSTANCE, Caption.of("PlacementStateProcessor fell through to null extent", new Object[0]));
        IN_FIRST_PASS = new BlockTypeMask((Extent)nullExtent, new BlockType[0]);
        IN_FIRST_PASS.add(BlockTypes.CHEST, BlockTypes.TRAPPED_CHEST);
        IN_FIRST_PASS.add(BlockCategories.STAIRS.getAll());
        IN_FIRST_PASS_WITHOUT_SECOND = new BlockTypeMask((Extent)nullExtent, new BlockType[0]);
        IN_FIRST_PASS_WITHOUT_SECOND.add(BlockCategories.STAIRS.getAll());
        REQUIRES_SECOND_PASS = new BlockTypeMask((Extent)nullExtent, new BlockType[0]);
        REQUIRES_SECOND_PASS.add(BlockTypes.IRON_BARS, BlockTypes.GLASS_PANE, BlockTypes.BLACK_STAINED_GLASS_PANE, BlockTypes.BLUE_STAINED_GLASS_PANE, BlockTypes.BROWN_STAINED_GLASS_PANE, BlockTypes.LIGHT_BLUE_STAINED_GLASS_PANE, BlockTypes.PINK_STAINED_GLASS_PANE, BlockTypes.LIGHT_GRAY_STAINED_GLASS_PANE, BlockTypes.GRAY_STAINED_GLASS_PANE, BlockTypes.CYAN_STAINED_GLASS_PANE, BlockTypes.PURPLE_STAINED_GLASS_PANE, BlockTypes.GREEN_STAINED_GLASS_PANE, BlockTypes.LIME_STAINED_GLASS_PANE, BlockTypes.MAGENTA_STAINED_GLASS_PANE, BlockTypes.YELLOW_STAINED_GLASS_PANE, BlockTypes.ORANGE_STAINED_GLASS_PANE, BlockTypes.RED_STAINED_GLASS_PANE, BlockTypes.WHITE_STAINED_GLASS_PANE, BlockTypes.TRIPWIRE, BlockTypes.TWISTING_VINES_PLANT, BlockTypes.CAVE_VINES_PLANT, BlockTypes.WEEPING_VINES_PLANT, BlockTypes.VINE, BlockTypes.REDSTONE_WIRE);
        for (BlockCategory category : categories = new BlockCategory[]{BlockCategories.FENCES, BlockCategories.FENCE_GATES, BlockCategories.WALLS, BlockCategories.CAVE_VINES}) {
            if (category == null) continue;
            REQUIRES_SECOND_PASS.add(category.getAll());
        }
        DEFAULT_MASK = REQUIRES_SECOND_PASS.copy();
        DEFAULT_MASK.add(BlockTypes.CHORUS_PLANT, BlockTypes.DRIPSTONE_BLOCK, BlockTypes.POINTED_DRIPSTONE, BlockTypes.BIG_DRIPLEAF, BlockTypes.BIG_DRIPLEAF_STEM, BlockTypes.CAMPFIRE, BlockTypes.CHEST, BlockTypes.TRAPPED_CHEST, BlockTypes.CRAFTER, BlockTypes.MUSHROOM_STEM, BlockTypes.BROWN_MUSHROOM_BLOCK, BlockTypes.RED_MUSHROOM_BLOCK);
        for (BlockCategory category : categories = new BlockCategory[]{BlockCategories.STAIRS, BlockCategories.BAMBOO_BLOCKS, BlockCategories.TALL_FLOWERS}) {
            if (category == null) continue;
            DEFAULT_MASK.add(category.getAll());
        }
        ADJACENT_STAIR_MASK = new AdjacentAny2DMask(new BlockCategoryMask(nullExtent, BlockCategories.STAIRS), false);
        SETUP = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IChunkSet processSet(IChunk iChunk, IChunkGet chunkGet, IChunkSet chunkSet) {
        if (this.finished.get()) {
            return chunkSet;
        }
        PlacementStateProcessor threadProcessor = this.threadProcessors.get();
        try {
            threadProcessor.initProcess(iChunk, chunkGet, chunkSet);
            IChunkSet iChunkSet = threadProcessor.process();
            return iChunkSet;
        }
        finally {
            threadProcessor.uninit();
        }
    }

    private void initProcess(IChunk iChunk, IChunkGet chunkGet, IChunkSet chunkSet) {
        this.processChunkX = iChunk.getX() << 4;
        this.processChunkZ = iChunk.getZ() << 4;
        this.processChunkGet = chunkGet;
        this.processChunkSet = chunkSet;
    }

    private void uninit() {
        this.processChunkGet = null;
        this.processChunkSet = null;
    }

    private IChunkSet process() {
        Map<BlockVector3, FaweCompoundTag> setTiles = this.processChunkSet.tiles();
        for (int layer = this.processChunkGet.getMinSectionPosition(); layer <= this.processChunkGet.getMaxSectionPosition(); ++layer) {
            int layerY = layer << 4;
            char[] set = this.processChunkSet.loadIfPresent(layer);
            if (set == null) continue;
            int y = 0;
            int i = 0;
            while (y < 16) {
                int blockY = layerY + y;
                this.checkAndPerformUpdate(setTiles, set, i, blockY, true);
                this.checkAndPerformUpdate(setTiles, set, i, blockY, false);
                ++y;
                i += 256;
            }
        }
        return this.processChunkSet;
    }

    private void checkAndPerformUpdate(Map<BlockVector3, FaweCompoundTag> setTiles, char[] set, int index, int blockY, boolean firstPass) {
        for (int z = 0; z < 16; ++z) {
            int blockZ = this.processChunkZ + z;
            int x = 0;
            while (x < 16) {
                int blockX = this.processChunkX + x;
                char ordinal = set[index];
                BlockState state = BlockTypesCache.states[ordinal];
                if (!(!firstPass ? IN_FIRST_PASS_WITHOUT_SECOND.test(state) : !IN_FIRST_PASS.test(state)) && this.mask.test(state)) {
                    boolean atEdge;
                    boolean bl = atEdge = x == 0 || x == 15 || z == 0 || z == 15;
                    if (!firstPass && atEdge && REQUIRES_SECOND_PASS.test(state)) {
                        this.postCompleteSecondPasses.put(new SecondPass(blockX, blockY, blockZ, setTiles.isEmpty() ? null : (FaweCompoundTag)((BlockVector3ChunkMap)setTiles).remove(x, blockY, z)), Character.valueOf(ordinal));
                        set[index] = '\u0000';
                    } else {
                        if (state.getBlockType().equals(BlockTypes.CHEST) || state.getBlockType().equals(BlockTypes.TRAPPED_CHEST)) {
                            this.placedBlock.setComponents(blockX, blockY, blockZ);
                        } else {
                            this.placedBlock.setComponents(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
                        }
                        char newOrdinal = this.getBlockOrdinal(blockX, blockY, blockZ, state);
                        if (newOrdinal != ordinal) {
                            set[index] = newOrdinal;
                        }
                    }
                }
                ++x;
                ++index;
            }
        }
    }

    @Override
    public ProcessorScope getScope() {
        return ProcessorScope.CHANGING_BLOCKS;
    }

    @Override
    public void finish() {
        this.flush();
    }

    @Override
    public void flush() {
        this.finished.set(true);
        for (Map.Entry<SecondPass, Character> entry : this.postCompleteSecondPasses.entrySet()) {
            char ordinal = entry.getValue().charValue();
            SecondPass secondPass = entry.getKey();
            BlockState state = ordinal != '\u0000' ? BlockTypesCache.states[ordinal] : this.extent.getBlock(secondPass.x, secondPass.y, secondPass.z);
            char newOrdinal = this.getBlockOrdinal(secondPass.x, secondPass.y, secondPass.z, state);
            if (newOrdinal == state.getOrdinalChar() && ordinal == '\u0000') continue;
            if (secondPass.tile != null) {
                this.extent.tile(secondPass.x, secondPass.y, secondPass.z, secondPass.tile);
            }
            this.extent.setBlock(secondPass.x, secondPass.y, secondPass.z, BlockTypesCache.states[newOrdinal]);
        }
        this.postCompleteSecondPasses.clear();
    }

    @Override
    public abstract PlacementStateProcessor fork();

    protected abstract char getStateAtFor(int var1, int var2, int var3, BlockState var4, Vector3 var5, Direction var6, BlockVector3 var7);

    public BlockState getBlockStateAt(int x, int y, int z) {
        Direction right;
        int testZ;
        Direction facing;
        Direction left;
        int testX;
        String shape;
        Character ord = this.postCompleteSecondPasses.get(new SecondPass(x, y, z, null));
        if (ord != null && ord.charValue() != '\u0000') {
            return BlockTypesCache.states[ord.charValue()];
        }
        if (this.processChunkSet == null || (x & 0xFFFFFFF0) != this.processChunkX || (z & 0xFFFFFFF0) != this.processChunkZ) {
            return this.extent.getBlock(x, y, z);
        }
        char[] set = this.processChunkSet.loadIfPresent(y >> 4);
        if (set == null) {
            return this.processChunkGet.getBlock(x & 0xF, y, z & 0xF);
        }
        char ordinal = set[(y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF];
        if (ordinal == '\u0000') {
            return this.processChunkGet.getBlock(x & 0xF, y, z & 0xF);
        }
        BlockState state = BlockTypesCache.states[ordinal];
        if ((state.getBlockType().equals(BlockTypes.CHEST) || state.getBlockType().equals(BlockTypes.TRAPPED_CHEST)) && ((shape = state.getState(PropertyKey.TYPE).toString()).equals("right") ? this.placedBlock.isAt(testX = x + (left = (facing = (Direction)((Object)state.getState(PropertyKey.FACING))).getLeft()).getBlockX(), y, testZ = z + left.getBlockZ()) : shape.equals("left") && this.placedBlock.isAt(testX = x + (right = (facing = (Direction)((Object)state.getState(PropertyKey.FACING))).getRight()).getBlockX(), y, testZ = z + right.getBlockZ()))) {
            return state.with(PropertyKey.TYPE, (Object)"single");
        }
        return state;
    }

    public LinCompoundTag getTileAt(int x, int y, int z) {
        SecondPass secondPass = new SecondPass(x, y, z, null);
        Character ord = this.postCompleteSecondPasses.get(secondPass);
        if (ord != null && ord.charValue() != '\u0000') {
            for (SecondPass pass : this.postCompleteSecondPasses.keySet()) {
                if (pass.hashCode() != secondPass.hashCode()) continue;
                return pass.tile != null ? pass.tile.linTag() : BlockTypesCache.states[ord.charValue()].getNbt();
            }
            return BlockTypesCache.states[ord.charValue()].getNbt();
        }
        if (this.processChunkSet == null || (x & 0xFFFFFFF0) != this.processChunkX || (z & 0xFFFFFFF0) != this.processChunkZ) {
            return this.extent.getFullBlock(x, y, z).getNbt();
        }
        FaweCompoundTag tile = this.processChunkSet.tile(x & 0xF, y, z & 0xF);
        if (tile != null) {
            return tile.linTag();
        }
        char[] set = this.processChunkSet.loadIfPresent(y >> 4);
        if (set == null) {
            return this.processChunkGet.getFullBlock(x & 0xF, y, z & 0xF).getNbt();
        }
        char ordinal = set[(y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF];
        if (ordinal == '\u0000') {
            return this.processChunkGet.getFullBlock(x & 0xF, y, z & 0xF).getNbt();
        }
        return BlockTypesCache.states[ordinal].getNbt();
    }

    private char getBlockOrdinal(int blockX, int blockY, int blockZ, BlockState state) {
        char override = this.getOverrideBlockOrdinal(blockX, blockY, blockZ, state);
        if (override != '\u0000') {
            return override;
        }
        EnumSet<Direction> dirs = Direction.getDirections(state);
        Direction clickedFaceDirection = null;
        Set states = state.getStates().keySet().stream().map(Property::getName).collect(Collectors.toSet());
        if (dirs.isEmpty() || states.contains("NORTH") && states.contains("EAST")) {
            this.clickPos.setComponents((double)blockX + 0.5, (double)blockY, (double)blockZ + 0.5);
            clickedFaceDirection = Direction.UP;
            this.clickedBlock.setComponents(blockX, blockY - 1, blockZ);
        } else {
            boolean hadNesw = false;
            for (Direction dir : NESW) {
                if (!dirs.contains((Object)dir)) continue;
                clickedFaceDirection = dir.getLeft().getLeft();
                if (state.getBlockType() == BlockTypes.CHEST || state.getBlockType() == BlockTypes.TRAPPED_CHEST) {
                    Direction tmp = clickedFaceDirection;
                    clickedFaceDirection = dir;
                    dir = tmp;
                }
                this.clickPos.setComponents((double)blockX + 0.5 * (double)(1 + dir.getBlockX()), (double)blockY + 0.2, (double)blockZ + 0.5 * (double)(1 + dir.getBlockZ()));
                this.clickedBlock.setComponents(blockX, blockY, blockZ).add(dir.toBlockVector());
                hadNesw = true;
                break;
            }
            if (hadNesw) {
                if (dirs.contains((Object)Direction.UP)) {
                    this.clickPos.mutY((double)blockY + 0.6);
                }
            } else if (dirs.contains((Object)Direction.UP)) {
                clickedFaceDirection = Direction.DOWN;
                this.clickPos.setComponents((double)blockX + 0.5, (double)blockY + 1.0, (double)blockZ + 0.5);
                this.clickedBlock.setComponents(blockX, blockY + 1, blockZ);
            } else if (dirs.contains((Object)Direction.DOWN)) {
                clickedFaceDirection = Direction.UP;
                this.clickPos.setComponents((double)blockX + 0.5, (double)blockY - 1.0, (double)blockZ + 0.5);
                this.clickedBlock.setComponents(blockX, blockY - 1, blockZ);
            }
        }
        return this.getStateAtFor(blockX, blockY, blockZ, state, this.clickPos, clickedFaceDirection, this.clickedBlock);
    }

    protected char getOverrideBlockOrdinal(int blockX, int blockY, int blockZ, BlockState state) {
        if (BlockCategories.TALL_FLOWERS.contains(state)) {
            PropertyKey propertyKey = PropertyKey.HALF;
            BlockStateHolder plantState = this.extent.getBlock(blockX, blockY - 1, blockZ).getBlockType().equals(state.getBlockType()) ? state.with(propertyKey, (Object)"upper") : state.with(propertyKey, (Object)"lower");
            return ((BlockState)plantState).getOrdinalChar();
        }
        return '\u0000';
    }

    @Override
    public void applyBlock(FilterBlock block) {
        char newOrdinal;
        char ordinal;
        if (this.finished.get()) {
            return;
        }
        BlockState state = BlockTypesCache.states[block.getOrdinal()];
        if (!this.mask.test(state)) {
            return;
        }
        if (REQUIRES_SECOND_PASS.test(block.getBlock()) && ADJACENT_STAIR_MASK.test(this.extent, block)) {
            this.postCompleteSecondPasses.put(new SecondPass(block), Character.valueOf('\u0000'));
        }
        if ((ordinal = (char)block.getOrdinal()) != (newOrdinal = this.getBlockOrdinal(block.x(), block.y(), block.z(), block.getBlock()))) {
            block.setBlock(BlockTypesCache.states[newOrdinal]);
        }
    }

    @Override
    public boolean apply(Extent orDefault, BlockVector3 get, BlockVector3 set) throws WorldEditException {
        BaseBlock block;
        if (orDefault == null) {
            orDefault = this.extent;
        }
        if (!this.mask.test(block = orDefault.getFullBlock(get))) {
            return false;
        }
        if (REQUIRES_SECOND_PASS.test(block) && ADJACENT_STAIR_MASK.test(this.extent, set)) {
            this.postCompleteSecondPasses.put(new SecondPass(set), Character.valueOf('\u0000'));
            return false;
        }
        char newOrdinal = this.getBlockOrdinal(set.x(), set.y(), set.z(), block.toBlockState());
        if (block.getOrdinalChar() != newOrdinal) {
            BlockState newState = BlockTypesCache.states[newOrdinal];
            orDefault.setBlock(set.x(), set.y(), set.z(), newState);
            LinCompoundTag nbt = block.getNbt();
            if (nbt != null && newState.getBlockType() == block.getBlockType()) {
                orDefault.tile(set.x(), set.y(), set.z(), FaweCompoundTag.of(nbt));
            }
            return true;
        }
        return false;
    }

    @Override
    public BaseBlock applyBlock(BlockVector3 position) {
        BaseBlock block = this.extent.getFullBlock(position);
        if (this.finished.get() || !this.mask.test(block)) {
            return block;
        }
        if (REQUIRES_SECOND_PASS.test(block) && ADJACENT_STAIR_MASK.test(this.extent, position)) {
            this.postCompleteSecondPasses.put(new SecondPass(position), Character.valueOf('\u0000'));
            return block;
        }
        char newOrdinal = this.getBlockOrdinal(position.x(), position.y(), position.z(), block.toBlockState());
        if (block.getOrdinalChar() != newOrdinal) {
            BlockState state = BlockTypesCache.states[newOrdinal];
            LinCompoundTag nbt = block.getNbt();
            if (nbt != null && state.getBlockType() == block.getBlockType()) {
                state.toBaseBlock(nbt);
            }
            return state.toBaseBlock();
        }
        return block;
    }

    protected record SecondPass(int x, int y, int z, FaweCompoundTag tile) {
        private SecondPass(BlockVector3 pos) {
            this(pos.x(), pos.y(), pos.z(), null);
        }

        @Override
        public int hashCode() {
            return this.x ^ this.z << 12 ^ this.y << 24;
        }
    }
}

