/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.internal.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

public class VarIntStreamIterator
implements PrimitiveIterator.OfInt {
    private final InputStream parent;
    private final int limit;
    private int index;
    private boolean hasNextInt;
    private int nextInt;

    public VarIntStreamIterator(InputStream parent, int limit) {
        this.parent = parent;
        this.limit = limit;
    }

    @Override
    public boolean hasNext() {
        if (this.hasNextInt) {
            return true;
        }
        if (this.index >= this.limit) {
            return false;
        }
        try {
            this.nextInt = this.readNextInt();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.hasNextInt = true;
        return true;
    }

    @Override
    public int nextInt() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.hasNextInt = false;
        return this.nextInt;
    }

    private int readNextInt() throws IOException {
        int value = 0;
        int bitsRead = 0;
        while (true) {
            if (this.index >= this.limit) {
                throw new IllegalStateException("Ran out of bytes while reading VarInt (probably corrupted data)");
            }
            byte next = (byte)this.parent.read();
            ++this.index;
            value |= (next & 0x7F) << bitsRead;
            if (bitsRead > 35) {
                throw new IllegalStateException("VarInt too big (probably corrupted data)");
            }
            if ((next & 0x80) == 0) break;
            bitsRead += 7;
        }
        return value;
    }
}

