/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_5;

import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.ChunkEntitySlices;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import com.fastasyncworldedit.bukkit.adapter.CachedBukkitAdapter;
import com.fastasyncworldedit.bukkit.adapter.DelegateSemaphore;
import com.fastasyncworldedit.bukkit.adapter.NMSAdapter;
import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.math.BitArrayUnstretched;
import com.fastasyncworldedit.core.math.IntPair;
import com.fastasyncworldedit.core.util.MathMan;
import com.fastasyncworldedit.core.util.TaskManager;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.bukkit.adapter.Refraction;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_5.PaperweightBlockMaterial;
import com.sk89q.worldedit.bukkit.paperlib.PaperLib;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import io.papermc.paper.util.MCUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.DataBits;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.util.ThreadingDetector;
import net.minecraft.util.ZeroBitStorage;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.DataPaletteExpandable;
import net.minecraft.world.level.chunk.DataPaletteGlobal;
import net.minecraft.world.level.chunk.DataPaletteHash;
import net.minecraft.world.level.chunk.DataPaletteLinear;
import net.minecraft.world.level.chunk.SingleValuePalette;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Chunk;
import org.bukkit.craftbukkit.v1_21_R4.CraftChunk;

public final class PaperweightPlatformAdapter
extends NMSAdapter {
    public static final Field fieldData;
    public static final Constructor<?> dataConstructor;
    public static final Field fieldStorage;
    public static final Field fieldPalette;
    private static final Field fieldTickingFluidCount;
    private static final Field fieldTickingBlockCount;
    private static final Field fieldBiomes;
    private static final MethodHandle methodGetVisibleChunk;
    private static final Field fieldThreadingDetector;
    private static final Field fieldLock;
    private static final MethodHandle methodRemoveGameEventListener;
    private static final MethodHandle methodremoveTickingBlockEntity;
    private static final Field fieldRemove;
    private static final Logger LOGGER;
    private static Field SERVER_LEVEL_ENTITY_MANAGER;
    static final MethodHandle PALETTED_CONTAINER_GET;
    private static final ThreadLocal<DelegateSemaphore> SEMAPHORE_THREAD_LOCAL;

    static boolean setSectionAtomic(String worldName, IntPair pair, ChunkSection[] sections, ChunkSection expected, ChunkSection value, int layer) {
        return NMSAdapter.setSectionAtomic(worldName, pair, sections, expected, value, layer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DelegateSemaphore applyLock(ChunkSection section) {
        if (PaperLib.isPaper()) {
            return SEMAPHORE_THREAD_LOCAL.get();
        }
        try {
            ChunkSection chunkSection = section;
            synchronized (chunkSection) {
                ThreadingDetector currentThreadingDetector;
                DataPaletteBlock blocks = section.h();
                ThreadingDetector threadingDetector = currentThreadingDetector = (ThreadingDetector)fieldThreadingDetector.get(blocks);
                synchronized (threadingDetector) {
                    Semaphore currentLock = (Semaphore)fieldLock.get(currentThreadingDetector);
                    if (currentLock instanceof DelegateSemaphore) {
                        DelegateSemaphore delegateSemaphore = (DelegateSemaphore)currentLock;
                        return delegateSemaphore;
                    }
                    DelegateSemaphore newLock = new DelegateSemaphore(1, currentLock);
                    fieldLock.set(currentThreadingDetector, newLock);
                    return newLock;
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("Error apply DelegateSemaphore", e);
            throw new RuntimeException(e);
        }
    }

    public static CompletableFuture<net.minecraft.world.level.chunk.Chunk> ensureLoaded(WorldServer serverLevel, int chunkX, int chunkZ) {
        net.minecraft.world.level.chunk.Chunk levelChunk = PaperweightPlatformAdapter.getChunkImmediatelyAsync(serverLevel, chunkX, chunkZ);
        if (levelChunk != null) {
            return CompletableFuture.completedFuture(levelChunk);
        }
        if (PaperLib.isPaper()) {
            CompletionStage future = serverLevel.getWorld().getChunkAtAsync(chunkX, chunkZ, true, true).thenApply(chunk -> {
                PaperweightPlatformAdapter.addTicket(serverLevel, chunkX, chunkZ);
                try {
                    return PaperweightPlatformAdapter.toLevelChunk(chunk);
                }
                catch (Throwable e) {
                    LOGGER.error("Could not asynchronously load chunk at {},{}", (Object)chunkX, (Object)chunkZ, (Object)e);
                    return null;
                }
            });
            try {
                if (!((CompletableFuture)future).isCompletedExceptionally() || ((CompletableFuture)future).isDone() && ((CompletableFuture)future).get() != null) {
                    return future;
                }
                Throwable t = ((CompletableFuture)future).exceptionNow();
                LOGGER.error("Asynchronous chunk load at {},{} exceptionally completed immediately", (Object)chunkX, (Object)chunkZ, (Object)t);
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("Unexpected error when getting completed future at chunk {},{}. Returning to default.", (Object)chunkX, (Object)chunkZ, (Object)e);
            }
        }
        return CompletableFuture.supplyAsync(() -> TaskManager.taskManager().sync(() -> serverLevel.d(chunkX, chunkZ)));
    }

    private static net.minecraft.world.level.chunk.Chunk toLevelChunk(Chunk chunk) {
        return (net.minecraft.world.level.chunk.Chunk)((CraftChunk)chunk).getHandle(ChunkStatus.n);
    }

    @Nullable
    public static net.minecraft.world.level.chunk.Chunk getChunkImmediatelyAsync(WorldServer serverLevel, int chunkX, int chunkZ) {
        if (!PaperLib.isPaper()) {
            net.minecraft.world.level.chunk.Chunk nmsChunk = serverLevel.m().a(chunkX, chunkZ, false);
            if (nmsChunk != null) {
                return nmsChunk;
            }
            if (Fawe.isMainThread()) {
                return serverLevel.d(chunkX, chunkZ);
            }
            return null;
        }
        net.minecraft.world.level.chunk.Chunk nmsChunk = serverLevel.m().getChunkAtIfCachedImmediately(chunkX, chunkZ);
        if (nmsChunk != null) {
            PaperweightPlatformAdapter.addTicket(serverLevel, chunkX, chunkZ);
            return nmsChunk;
        }
        nmsChunk = serverLevel.m().getChunkAtIfLoadedImmediately(chunkX, chunkZ);
        if (nmsChunk != null) {
            PaperweightPlatformAdapter.addTicket(serverLevel, chunkX, chunkZ);
            return nmsChunk;
        }
        if (Fawe.isMainThread()) {
            return serverLevel.d(chunkX, chunkZ);
        }
        return null;
    }

    private static void addTicket(WorldServer serverLevel, int chunkX, int chunkZ) {
        MCUtil.MAIN_EXECUTOR.execute(() -> serverLevel.m().a(ChunkHolderManager.UNLOAD_COOLDOWN, new ChunkCoordIntPair(chunkX, chunkZ), 0));
    }

    public static PlayerChunk getPlayerChunk(WorldServer nmsWorld, int chunkX, int chunkZ) {
        PlayerChunkMap chunkMap = nmsWorld.m().a;
        try {
            return methodGetVisibleChunk.invoke(chunkMap, ChunkCoordIntPair.c((int)chunkX, (int)chunkZ));
        }
        catch (Throwable thr) {
            throw new RuntimeException(thr);
        }
    }

    public static void sendChunk(IntPair pair, WorldServer nmsWorld, int chunkX, int chunkZ) {
        PlayerChunk chunkHolder = PaperweightPlatformAdapter.getPlayerChunk(nmsWorld, chunkX, chunkZ);
        if (chunkHolder == null) {
            return;
        }
        net.minecraft.world.level.chunk.Chunk levelChunk = PaperLib.isPaper() ? nmsWorld.m().getChunkAtIfLoadedImmediately(chunkX, chunkZ) : (net.minecraft.world.level.chunk.Chunk)chunkHolder.a().getNow(PlayerChunk.a).b(null);
        if (levelChunk == null) {
            return;
        }
        NMSAdapter.StampLockHolder lockHolder = new NMSAdapter.StampLockHolder();
        NMSAdapter.beginChunkPacketSend(nmsWorld.getWorld().getName(), pair, lockHolder);
        if (lockHolder.chunkLock == null) {
            return;
        }
        MinecraftServer.getServer().execute(() -> {
            try {
                ChunkCoordIntPair pos = levelChunk.f();
                ClientboundLevelChunkWithLightPacket packet = PaperLib.isPaper() ? new ClientboundLevelChunkWithLightPacket(levelChunk, nmsWorld.B_(), null, null, false) : new ClientboundLevelChunkWithLightPacket(levelChunk, nmsWorld.B_(), null, null);
                PaperweightPlatformAdapter.nearbyPlayers(nmsWorld, pos).forEach(p -> p.f.b((Packet)packet));
            }
            finally {
                NMSAdapter.endChunkPacketSend(nmsWorld.getWorld().getName(), pair, lockHolder);
            }
        });
    }

    private static List<EntityPlayer> nearbyPlayers(WorldServer serverLevel, ChunkCoordIntPair coordIntPair) {
        return serverLevel.m().a.a(coordIntPair, false);
    }

    public static ChunkSection newChunkSection(int layer, char[] blocks, CachedBukkitAdapter adapter, IRegistry<BiomeBase> biomeRegistry, @Nullable DataPaletteBlock<Holder<BiomeBase>> biomes) {
        return PaperweightPlatformAdapter.newChunkSection(layer, null, blocks, adapter, biomeRegistry, biomes);
    }

    public static ChunkSection newChunkSection(int layer, IntFunction<char[]> get, char[] set, CachedBukkitAdapter adapter, IRegistry<BiomeBase> biomeRegistry, @Nullable DataPaletteBlock<Holder<BiomeBase>> biomes) {
        if (set == null) {
            return PaperweightPlatformAdapter.newChunkSection(biomeRegistry, biomes);
        }
        int[] blockToPalette = (int[])FaweCache.INSTANCE.BLOCK_TO_PALETTE.get();
        int[] paletteToBlock = (int[])FaweCache.INSTANCE.PALETTE_TO_BLOCK.get();
        long[] blockStates = (long[])FaweCache.INSTANCE.BLOCK_STATES.get();
        int[] blocksCopy = (int[])FaweCache.INSTANCE.SECTION_BLOCKS.get();
        try {
            List<IBlockData> palette;
            int num_palette = get == null ? PaperweightPlatformAdapter.createPalette(blockToPalette, paletteToBlock, blocksCopy, set, adapter) : PaperweightPlatformAdapter.createPalette(layer, blockToPalette, paletteToBlock, blocksCopy, get, set, adapter);
            int bitsPerEntry = MathMan.log2nlz(num_palette - 1);
            if (bitsPerEntry > 0 && bitsPerEntry < 5) {
                bitsPerEntry = 4;
            } else if (bitsPerEntry > 8) {
                bitsPerEntry = MathMan.log2nlz(Block.k.d() - 1);
            }
            int bitsPerEntryNonZero = Math.max(bitsPerEntry, 1);
            int blockBitArrayEnd = MathMan.longArrayLength(bitsPerEntryNonZero, 4096);
            if (num_palette == 1) {
                for (int i = 0; i < blockBitArrayEnd; ++i) {
                    blockStates[i] = 0L;
                }
            } else {
                BitArrayUnstretched bitArray = new BitArrayUnstretched(bitsPerEntryNonZero, 4096, blockStates);
                bitArray.fromRaw(blocksCopy);
            }
            long[] bits = Arrays.copyOfRange(blockStates, 0, blockBitArrayEnd);
            Object nmsBits = bitsPerEntry == 0 ? new ZeroBitStorage(4096) : new SimpleBitStorage(bitsPerEntry, 4096, bits);
            if (bitsPerEntry < 9) {
                palette = new ArrayList();
                for (int i = 0; i < num_palette; ++i) {
                    int ordinal = paletteToBlock[i];
                    blockToPalette[ordinal] = Integer.MAX_VALUE;
                    BlockState state = BlockTypesCache.states[ordinal];
                    palette.add((IBlockData)((PaperweightBlockMaterial)state.getMaterial()).getState());
                }
            } else {
                palette = List.of();
            }
            DataPaletteBlock blockStatePalettedContainer = new DataPaletteBlock((Registry)Block.k, DataPaletteBlock.d.d, DataPaletteBlock.d.d.a((Registry)Block.k, bitsPerEntry), (DataBits)nmsBits, palette);
            if (biomes == null) {
                Registry biomeHolderIdMap = biomeRegistry.t();
                biomes = new DataPaletteBlock(biomeHolderIdMap, (Object)((Holder)biomeHolderIdMap.b(WorldEditPlugin.getInstance().getBukkitImplAdapter().getInternalBiomeId(BiomeTypes.PLAINS))), DataPaletteBlock.d.e);
            }
            ChunkSection chunkSection = new ChunkSection(blockStatePalettedContainer, biomes);
            return chunkSection;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            Arrays.fill(blockToPalette, Integer.MAX_VALUE);
            Arrays.fill(paletteToBlock, Integer.MAX_VALUE);
            Arrays.fill(blockStates, 0L);
            Arrays.fill(blocksCopy, 0);
        }
    }

    private static ChunkSection newChunkSection(IRegistry<BiomeBase> biomeRegistry, @Nullable DataPaletteBlock<Holder<BiomeBase>> biomes) {
        if (biomes == null) {
            return new ChunkSection(biomeRegistry);
        }
        DataPaletteBlock dataPaletteBlocks = new DataPaletteBlock((Registry)Block.k, (Object)Blocks.a.m(), DataPaletteBlock.d.d);
        return new ChunkSection(dataPaletteBlocks, biomes);
    }

    public static void setBiomesToChunkSection(ChunkSection section, DataPaletteBlock<Holder<BiomeBase>> biomes) {
        try {
            fieldBiomes.set(section, biomes);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Could not set biomes to chunk section", (Throwable)e);
        }
    }

    public static DataPaletteBlock<Holder<BiomeBase>> getBiomePalettedContainer(BiomeType[] biomes, Registry<Holder<BiomeBase>> biomeRegistry) {
        if (biomes == null) {
            return null;
        }
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        HashMap<BiomeType, Holder> palette = new HashMap<BiomeType, Holder>();
        for (BiomeType biomeType : new LinkedList<BiomeType>(Arrays.asList(biomes))) {
            Holder biome = biomeType == null ? (Holder)biomeRegistry.a(adapter.getInternalBiomeId(BiomeTypes.PLAINS)) : (Holder)biomeRegistry.a(adapter.getInternalBiomeId(biomeType));
            palette.put(biomeType, biome);
        }
        int biomeCount = palette.size();
        int bitsPerEntry = MathMan.log2nlz(biomeCount - 1);
        DataPaletteBlock.a configuration = DataPaletteBlock.d.d.a((Registry)new FakeIdMapBiome(biomeCount), bitsPerEntry);
        if (bitsPerEntry > 3) {
            bitsPerEntry = MathMan.log2nlz(biomeRegistry.d() - 1);
        }
        DataPaletteBlock biomePalettedContainer = new DataPaletteBlock(biomeRegistry, (Object)((Holder)biomeRegistry.b(adapter.getInternalBiomeId(BiomeTypes.PLAINS))), DataPaletteBlock.d.e);
        Object biomePalette = bitsPerEntry == 0 ? new SingleValuePalette(biomePalettedContainer.c, (DataPaletteExpandable)biomePalettedContainer, new ArrayList(palette.values())) : (bitsPerEntry == 4 ? DataPaletteLinear.a((int)4, (Registry)biomePalettedContainer.c, (DataPaletteExpandable)biomePalettedContainer, new ArrayList(palette.values())) : (bitsPerEntry < 9 ? DataPaletteHash.a((int)bitsPerEntry, (Registry)biomePalettedContainer.c, (DataPaletteExpandable)biomePalettedContainer, new ArrayList(palette.values())) : DataPaletteGlobal.a((int)bitsPerEntry, (Registry)biomePalettedContainer.c, (DataPaletteExpandable)biomePalettedContainer, null)));
        int bitsPerEntryNonZero = Math.max(bitsPerEntry, 1);
        int arrayLength = MathMan.longArrayLength(bitsPerEntryNonZero, 64);
        ZeroBitStorage bitStorage = bitsPerEntry == 0 ? new ZeroBitStorage(64) : new SimpleBitStorage(bitsPerEntry, 64, new long[arrayLength]);
        try {
            Object data = dataConstructor.newInstance(configuration, bitStorage, biomePalette);
            fieldData.set(biomePalettedContainer, data);
            int index = 0;
            for (int y = 0; y < 4; ++y) {
                for (int z = 0; z < 4; ++z) {
                    int x = 0;
                    while (x < 4) {
                        Holder biome;
                        BiomeType biomeType = biomes[index];
                        if (biomeType != null && (biome = (Holder)biomeRegistry.a(WorldEditPlugin.getInstance().getBukkitImplAdapter().getInternalBiomeId(biomeType))) != null) {
                            biomePalettedContainer.c(x, y, z, (Object)biome);
                        }
                        ++x;
                        ++index;
                    }
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return biomePalettedContainer;
    }

    public static void clearCounts(ChunkSection section) throws IllegalAccessException {
        fieldTickingFluidCount.setShort(section, (short)0);
        fieldTickingBlockCount.setShort(section, (short)0);
    }

    public static BiomeType adapt(Holder<BiomeBase> biome, GeneratorAccess levelAccessor) {
        IRegistry biomeRegistry = levelAccessor.J_().f(Registries.aG);
        int id = biomeRegistry.a((Object)((BiomeBase)biome.a()));
        if (id < 0) {
            return BiomeTypes.OCEAN;
        }
        return BiomeTypes.getLegacy(id);
    }

    static void removeBeacon(TileEntity beacon, net.minecraft.world.level.chunk.Chunk levelChunk) {
        try {
            TileEntity blockEntity;
            if ((levelChunk.q || levelChunk.r.A_()) && (blockEntity = (TileEntity)levelChunk.k.remove(beacon.ax_())) != null) {
                if (!levelChunk.r.C) {
                    methodRemoveGameEventListener.invoke(levelChunk, beacon, levelChunk.r);
                }
                fieldRemove.set(beacon, true);
            }
            methodremoveTickingBlockEntity.invoke(levelChunk, beacon.ax_());
        }
        catch (Throwable throwable) {
            LOGGER.error("Error removing beacon", throwable);
        }
    }

    static List<Entity> getEntities(net.minecraft.world.level.chunk.Chunk chunk) {
        if (PaperLib.isPaper()) {
            return Optional.ofNullable(chunk.r.moonrise$getEntityLookup().getChunk(chunk.locX, chunk.locZ)).map(ChunkEntitySlices::getAllEntities).orElse(Collections.emptyList());
        }
        try {
            return ((PersistentEntitySectionManager)SERVER_LEVEL_ENTITY_MANAGER.get(chunk.r)).getEntities(chunk.f());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to lookup entities [PAPER=false]", e);
        }
    }

    static {
        LOGGER = LogManagerCompat.getLogger();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Field tmpFieldBiomes;
            fieldData = DataPaletteBlock.class.getDeclaredField(Refraction.pickName("data", "d"));
            fieldData.setAccessible(true);
            Class<?> dataClazz = fieldData.getType();
            dataConstructor = dataClazz.getDeclaredConstructors()[0];
            dataConstructor.setAccessible(true);
            fieldStorage = dataClazz.getDeclaredField(Refraction.pickName("storage", "b"));
            fieldStorage.setAccessible(true);
            fieldPalette = dataClazz.getDeclaredField(Refraction.pickName("palette", "c"));
            fieldPalette.setAccessible(true);
            fieldTickingFluidCount = ChunkSection.class.getDeclaredField(Refraction.pickName("tickingFluidCount", "g"));
            fieldTickingFluidCount.setAccessible(true);
            fieldTickingBlockCount = ChunkSection.class.getDeclaredField(Refraction.pickName("tickingBlockCount", "f"));
            fieldTickingBlockCount.setAccessible(true);
            try {
                tmpFieldBiomes = ChunkSection.class.getDeclaredField("biomes");
            }
            catch (NoSuchFieldException ignored) {
                tmpFieldBiomes = ChunkSection.class.getDeclaredField("i");
            }
            fieldBiomes = tmpFieldBiomes;
            fieldBiomes.setAccessible(true);
            Method getVisibleChunkIfPresent = PlayerChunkMap.class.getDeclaredMethod(Refraction.pickName("getVisibleChunkIfPresent", "b"), Long.TYPE);
            getVisibleChunkIfPresent.setAccessible(true);
            methodGetVisibleChunk = lookup.unreflect(getVisibleChunkIfPresent);
            if (!PaperLib.isPaper()) {
                fieldThreadingDetector = DataPaletteBlock.class.getDeclaredField(Refraction.pickName("threadingDetector", "f"));
                fieldThreadingDetector.setAccessible(true);
                fieldLock = ThreadingDetector.class.getDeclaredField(Refraction.pickName("lock", "c"));
                fieldLock.setAccessible(true);
                SERVER_LEVEL_ENTITY_MANAGER = WorldServer.class.getDeclaredField(Refraction.pickName("entityManager", "O"));
                SERVER_LEVEL_ENTITY_MANAGER.setAccessible(true);
            } else {
                fieldThreadingDetector = null;
                fieldLock = null;
            }
            Method removeGameEventListener = net.minecraft.world.level.chunk.Chunk.class.getDeclaredMethod(Refraction.pickName("removeGameEventListener", "a"), TileEntity.class, WorldServer.class);
            removeGameEventListener.setAccessible(true);
            methodRemoveGameEventListener = lookup.unreflect(removeGameEventListener);
            Method removeBlockEntityTicker = net.minecraft.world.level.chunk.Chunk.class.getDeclaredMethod(Refraction.pickName("removeBlockEntityTicker", "k"), BlockPosition.class);
            removeBlockEntityTicker.setAccessible(true);
            methodremoveTickingBlockEntity = lookup.unreflect(removeBlockEntityTicker);
            fieldRemove = TileEntity.class.getDeclaredField(Refraction.pickName("remove", "p"));
            fieldRemove.setAccessible(true);
            Method palettedContainerGet = DataPaletteBlock.class.getDeclaredMethod(Refraction.pickName("get", "a"), Integer.TYPE);
            palettedContainerGet.setAccessible(true);
            PALETTED_CONTAINER_GET = lookup.unreflect(palettedContainerGet);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SEMAPHORE_THREAD_LOCAL = ThreadLocal.withInitial(() -> new DelegateSemaphore(1, null));
    }

    static final class FakeIdMapBiome
    extends Record
    implements Registry<BiomeBase> {
        private final int size;

        FakeIdMapBiome(int size) {
            this.size = size;
        }

        public int getId(BiomeBase entry) {
            return 0;
        }

        @Nullable
        public BiomeBase byId(int index) {
            return null;
        }

        @Nonnull
        public Iterator<BiomeBase> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{FakeIdMapBiome.class, "size", "size"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FakeIdMapBiome.class, "size", "size"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FakeIdMapBiome.class, "size", "size"}, this, o);
        }

        public int d() {
            return this.size;
        }
    }

    static final class FakeIdMapBlock
    extends Record
    implements Registry<IBlockData> {
        private final int size;

        FakeIdMapBlock(int size) {
            this.size = size;
        }

        public int getId(IBlockData entry) {
            return 0;
        }

        @Nullable
        public IBlockData byId(int index) {
            return null;
        }

        @Nonnull
        public Iterator<IBlockData> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{FakeIdMapBlock.class, "size", "size"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FakeIdMapBlock.class, "size", "size"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FakeIdMapBlock.class, "size", "size"}, this, o);
        }

        public int d() {
            return this.size;
        }
    }
}

