/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_R1;

import com.fastasyncworldedit.bukkit.adapter.FaweAdapter;
import com.fastasyncworldedit.bukkit.adapter.NMSRelighterFactory;
import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.entity.LazyBaseEntity;
import com.fastasyncworldedit.core.extent.processor.PlacementStateProcessor;
import com.fastasyncworldedit.core.extent.processor.lighting.RelighterFactory;
import com.fastasyncworldedit.core.nbt.FaweCompoundTag;
import com.fastasyncworldedit.core.queue.IBatchProcessor;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.implementation.packet.ChunkPacket;
import com.fastasyncworldedit.core.util.NbtUtils;
import com.fastasyncworldedit.core.util.TaskManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.bukkit.adapter.ext.fawe.v1_21_R1.PaperweightAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_R1.FaweBlockStateListPopulator;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_R1.PaperweightBlockMaterial;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_R1.PaperweightFaweWorldNativeAccess;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_R1.PaperweightGetBlocks;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_R1.PaperweightMapChunkUtil;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_R1.PaperweightPlacementStateProcessor;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_R1.PaperweightPlatformAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_R1.PaperweightPostProcessor;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_R1.PaperweightStarlightRelighterFactory;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_R1.nbt.PaperweightLazyCompoundTag;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_R1.regen.PaperweightRegen;
import com.sk89q.worldedit.bukkit.paperlib.PaperLib;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.BlockTypeMask;
import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.internal.wna.WorldNativeAccess;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.registry.state.AbstractProperty;
import com.sk89q.worldedit.registry.state.BooleanProperty;
import com.sk89q.worldedit.registry.state.DirectionalProperty;
import com.sk89q.worldedit.registry.state.EnumProperty;
import com.sk89q.worldedit.registry.state.IntegerProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.concurrency.LazyReference;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.world.RegenOptions;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import com.sk89q.worldedit.world.entity.EntityType;
import com.sk89q.worldedit.world.generation.ConfiguredFeatureType;
import com.sk89q.worldedit.world.generation.StructureType;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.registry.BlockMaterial;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.AquaticFeatures;
import net.minecraft.data.worldgen.features.CaveFeatures;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.data.worldgen.features.NetherFeatures;
import net.minecraft.data.worldgen.features.PileFeatures;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.INamable;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.enginehub.linbus.tree.LinCompoundTag;
import org.enginehub.linbus.tree.LinStringTag;
import org.enginehub.linbus.tree.LinTag;

public final class PaperweightFaweAdapter
extends FaweAdapter<NBTBase, WorldServer> {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private static Method CHUNK_HOLDER_WAS_ACCESSIBLE_SINCE_LAST_SAVE;
    private static final Codec<DataComponentPatch> COMPONENTS_CODEC;
    private final PaperweightMapChunkUtil mapUtil = new PaperweightMapChunkUtil();
    private static final Set<SideEffect> SUPPORTED_SIDE_EFFECTS;

    public PaperweightFaweAdapter() throws NoSuchFieldException, NoSuchMethodException {
        super(new PaperweightAdapter());
    }

    public Function<TileEntity, FaweCompoundTag> blockEntityToCompoundTag() {
        return blockEntity -> FaweCompoundTag.of((com.google.common.base.Supplier<? extends LinCompoundTag>)((com.google.common.base.Supplier)() -> (LinCompoundTag)this.toNativeLin(blockEntity.c((HolderLookup.a)DedicatedServer.getServer().bc()))));
    }

    @Nullable
    private static String getEntityId(net.minecraft.world.entity.Entity entity) {
        MinecraftKey resourceLocation = EntityTypes.a((EntityTypes)entity.am());
        return resourceLocation == null ? null : resourceLocation.toString();
    }

    private static boolean readEntityIntoTag(net.minecraft.world.entity.Entity entity, NBTTagCompound compoundTag) {
        return entity.e(compoundTag);
    }

    @Override
    public BukkitImplAdapter<NBTBase> getParent() {
        return this.parent;
    }

    @Override
    protected void ensureInit() {
        if (!this.initialised) {
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean init() {
        if (this.ibdToOrdinal != null && this.ibdToOrdinal[1] != 0) {
            return false;
        }
        this.ibdToOrdinal = new int[BlockTypesCache.states.length];
        this.ordinalToIbdID = new int[this.ibdToOrdinal.length];
        for (int i = 0; i < this.ibdToOrdinal.length; ++i) {
            Field[] blockState = BlockTypesCache.states[i];
            PaperweightBlockMaterial material = (PaperweightBlockMaterial)blockState.getMaterial();
            int id = Block.q.a((Object)((IBlockData)material.getState()));
            char ordinal = blockState.getOrdinalChar();
            this.ibdToOrdinal[id] = ordinal;
            this.ordinalToIbdID[ordinal] = id;
        }
        HashMap<String, List> properties = new HashMap<String, List>();
        try {
            for (Field field : BlockProperties.class.getDeclaredFields()) {
                AbstractProperty property;
                Object obj = field.get(null);
                if (!(obj instanceof IBlockState)) continue;
                IBlockState state = (IBlockState)obj;
                if (state instanceof BlockStateBoolean) {
                    property = new BooleanProperty(state.f(), (List<Boolean>)ImmutableList.copyOf((Collection)state.a()));
                } else if (state instanceof BlockStateDirection) {
                    property = new DirectionalProperty(state.f(), state.a().stream().map(e -> Direction.valueOf(((INamable)e).c().toUpperCase())).collect(Collectors.toList()));
                } else if (state instanceof BlockStateEnum) {
                    property = new EnumProperty(state.f(), state.a().stream().map(e -> ((INamable)e).c()).collect(Collectors.toList()));
                } else if (state instanceof BlockStateInteger) {
                    property = new IntegerProperty(state.f(), (List<Integer>)ImmutableList.copyOf((Collection)state.a()));
                } else {
                    throw new IllegalArgumentException("FastAsyncWorldEdit needs an update to support " + state.getClass().getSimpleName());
                }
                properties.compute(property.getName().toLowerCase(Locale.ROOT), (k, v) -> {
                    if (v == null) {
                        v = new ArrayList<Property>(Collections.singletonList(property));
                    } else {
                        v.add(property);
                    }
                    return v;
                });
            }
        }
        catch (IllegalAccessException e2) {
            e2.printStackTrace();
        }
        finally {
            this.allBlockProperties = ImmutableMap.copyOf(properties);
        }
        this.initialised = true;
        return true;
    }

    @Override
    public Collection<String> getRegisteredDefaultBlockStates() {
        ArrayList<String> states = new ArrayList<String>();
        for (Block block : BuiltInRegistries.e) {
            states.add(CraftBlockData.fromData((IBlockData)block.o()).getAsString());
        }
        return states;
    }

    @Override
    public BlockMaterial getMaterial(BlockType blockType) {
        Block block = this.getBlock(blockType);
        return new PaperweightBlockMaterial(block);
    }

    @Override
    public synchronized BlockMaterial getMaterial(BlockState state) {
        IBlockData blockState = ((CraftBlockData)Bukkit.createBlockData((String)state.getAsString())).getState();
        return new PaperweightBlockMaterial(blockState.b(), blockState);
    }

    public Block getBlock(BlockType blockType) {
        return (Block)DedicatedServer.getServer().bc().d(Registries.f).a(MinecraftKey.a((String)blockType.getNamespace(), (String)blockType.getResource()));
    }

    @Override
    @Deprecated
    public BlockState getBlock(Location location) {
        Preconditions.checkNotNull((Object)location);
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        WorldServer handle = this.getServerLevel(location.getWorld());
        Chunk chunk = handle.d(x >> 4, z >> 4);
        BlockPosition blockPos = new BlockPosition(x, y, z);
        IBlockData blockData = chunk.a_(blockPos);
        BlockState state = this.adapt(blockData);
        if (state == null) {
            org.bukkit.block.Block bukkitBlock = location.getBlock();
            state = BukkitAdapter.adapt(bukkitBlock.getBlockData());
        }
        return state;
    }

    @Override
    public BaseBlock getFullBlock(Location location) {
        TileEntity blockEntity;
        Preconditions.checkNotNull((Object)location);
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        WorldServer handle = this.getServerLevel(location.getWorld());
        Chunk chunk = handle.d(x >> 4, z >> 4);
        BlockPosition blockPos = new BlockPosition(x, y, z);
        IBlockData blockData = chunk.a_(blockPos);
        BlockState state = this.adapt(blockData);
        if (state == null) {
            org.bukkit.block.Block bukkitBlock = location.getBlock();
            state = BukkitAdapter.adapt(bukkitBlock.getBlockData());
        }
        if (state.getBlockType().getMaterial().hasContainer() && (blockEntity = chunk.a(blockPos, Chunk.EnumTileEntityState.c)) != null) {
            NBTTagCompound tag = blockEntity.c((HolderLookup.a)DedicatedServer.getServer().bc());
            return state.toBaseBlock((LinCompoundTag)this.toNativeLin(tag));
        }
        return state.toBaseBlock();
    }

    @Override
    public Set<SideEffect> getSupportedSideEffects() {
        return SUPPORTED_SIDE_EFFECTS;
    }

    @Override
    public WorldNativeAccess<?, ?, ?> createWorldNativeAccess(World world) {
        return new PaperweightFaweWorldNativeAccess(this, new WeakReference<WorldServer>(this.getServerLevel(world)));
    }

    @Override
    public BaseEntity getEntity(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        CraftEntity craftEntity = (CraftEntity)entity;
        net.minecraft.world.entity.Entity mcEntity = craftEntity.getHandle();
        String id = PaperweightFaweAdapter.getEntityId(mcEntity);
        if (id != null) {
            EntityType type = com.sk89q.worldedit.world.entity.EntityTypes.get(id);
            Supplier<LinCompoundTag> saveTag = () -> {
                NBTTagCompound minecraftTag = new NBTTagCompound();
                if (!PaperweightFaweAdapter.readEntityIntoTag(mcEntity, minecraftTag)) {
                    return null;
                }
                LinCompoundTag tag = (LinCompoundTag)this.toNativeLin(minecraftTag);
                Map<String, LinTag<?>> tags = NbtUtils.getLinCompoundTagValues(tag);
                tags.put("Id", LinStringTag.of(id));
                return LinCompoundTag.of(tags);
            };
            return new LazyBaseEntity(type, saveTag);
        }
        return null;
    }

    @Override
    public Component getRichBlockName(BlockType blockType) {
        return this.parent.getRichBlockName(blockType);
    }

    @Override
    public Component getRichItemName(ItemType itemType) {
        return this.parent.getRichItemName(itemType);
    }

    @Override
    public Component getRichItemName(BaseItemStack itemStack) {
        return this.parent.getRichItemName(itemStack);
    }

    @Override
    public OptionalInt getInternalBlockStateId(BlockState state) {
        PaperweightBlockMaterial material = (PaperweightBlockMaterial)state.getMaterial();
        IBlockData mcState = (IBlockData)material.getState();
        return OptionalInt.of(Block.q.a((Object)mcState));
    }

    @Override
    public BlockState adapt(BlockData blockData) {
        CraftBlockData cbd = (CraftBlockData)blockData;
        IBlockData ibd = cbd.getState();
        return this.adapt(ibd);
    }

    public BlockState adapt(IBlockData blockState) {
        return BlockTypesCache.states[this.adaptToChar(blockState)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char adaptToChar(IBlockData blockState) {
        int id = Block.q.a((Object)blockState);
        if (this.initialised) {
            return (char)this.ibdToOrdinal[id];
        }
        PaperweightFaweAdapter paperweightFaweAdapter = this;
        synchronized (paperweightFaweAdapter) {
            if (this.initialised) {
                return (char)this.ibdToOrdinal[id];
            }
            try {
                this.init();
                return (char)this.ibdToOrdinal[id];
            }
            catch (ArrayIndexOutOfBoundsException e1) {
                LOGGER.error("Attempted to convert {} with ID {} to char. ibdToOrdinal length: {}. Defaulting to air!", (Object)blockState.b(), (Object)Block.q.a((Object)blockState), (Object)this.ibdToOrdinal.length, (Object)e1);
                return '\u0001';
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char ibdIDToOrdinal(int id) {
        if (this.initialised) {
            return (char)this.ibdToOrdinal[id];
        }
        PaperweightFaweAdapter paperweightFaweAdapter = this;
        synchronized (paperweightFaweAdapter) {
            if (this.initialised) {
                return (char)this.ibdToOrdinal[id];
            }
            this.init();
            return (char)this.ibdToOrdinal[id];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getIbdToOrdinal() {
        if (this.initialised) {
            return this.ibdToOrdinal;
        }
        PaperweightFaweAdapter paperweightFaweAdapter = this;
        synchronized (paperweightFaweAdapter) {
            if (this.initialised) {
                return this.ibdToOrdinal;
            }
            this.init();
            return this.ibdToOrdinal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ordinalToIbdID(char ordinal) {
        if (this.initialised) {
            return this.ordinalToIbdID[ordinal];
        }
        PaperweightFaweAdapter paperweightFaweAdapter = this;
        synchronized (paperweightFaweAdapter) {
            if (this.initialised) {
                return this.ordinalToIbdID[ordinal];
            }
            this.init();
            return this.ordinalToIbdID[ordinal];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getOrdinalToIbdID() {
        if (this.initialised) {
            return this.ordinalToIbdID;
        }
        PaperweightFaweAdapter paperweightFaweAdapter = this;
        synchronized (paperweightFaweAdapter) {
            if (this.initialised) {
                return this.ordinalToIbdID;
            }
            this.init();
            return this.ordinalToIbdID;
        }
    }

    @Override
    public <B extends BlockStateHolder<B>> BlockData adapt(B state) {
        PaperweightBlockMaterial material = (PaperweightBlockMaterial)state.getMaterial();
        return material.getBlockData();
    }

    public IBlockData adapt(BlockState blockState) {
        return Block.a((int)this.getOrdinalToIbdID()[blockState.getOrdinal()]);
    }

    @Override
    public void sendFakeChunk(World world, Player player, ChunkPacket chunkPacket) {
        WorldServer nmsWorld = this.getServerLevel(world);
        PlayerChunk map = PaperweightPlatformAdapter.getPlayerChunk(nmsWorld, chunkPacket.getChunkX(), chunkPacket.getChunkZ());
        if (map != null && this.wasAccessibleSinceLastSave(map)) {
            boolean flag = false;
            Stream<EntityPlayer> stream = Stream.empty();
            EntityPlayer checkPlayer = player == null ? null : ((CraftPlayer)player).getHandle();
            stream.filter(entityPlayer -> checkPlayer == null || entityPlayer == checkPlayer).forEach(entityPlayer -> {
                ChunkPacket chunkPacket2 = chunkPacket;
                synchronized (chunkPacket2) {
                    ClientboundLevelChunkWithLightPacket nmsPacket = (ClientboundLevelChunkWithLightPacket)chunkPacket.getNativePacket();
                    if (nmsPacket == null) {
                        nmsPacket = (ClientboundLevelChunkWithLightPacket)this.mapUtil.create(this, chunkPacket);
                        chunkPacket.setNativePacket(nmsPacket);
                    }
                    try {
                        ((AtomicBoolean)FaweCache.INSTANCE.CHUNK_FLAG.get()).set(true);
                        entityPlayer.c.b((Packet)nmsPacket);
                    }
                    finally {
                        ((AtomicBoolean)FaweCache.INSTANCE.CHUNK_FLAG.get()).set(false);
                    }
                }
            });
        }
    }

    @Override
    public Map<String, ? extends Property<?>> getProperties(BlockType blockType) {
        return this.getParent().getProperties(blockType);
    }

    @Override
    public boolean canPlaceAt(World world, BlockVector3 blockVector3, BlockState blockState) {
        int internalId = BlockStateIdAccess.getBlockStateId(blockState);
        IBlockData blockState1 = Block.a((int)internalId);
        return blockState1.q((IBlockAccess)this.getServerLevel(world), new BlockPosition(blockVector3.x(), blockVector3.y(), blockVector3.z()));
    }

    @Override
    public ItemStack adapt(BaseItemStack baseItemStack) {
        IRegistryCustom.Dimension registryAccess = DedicatedServer.getServer().bc();
        net.minecraft.world.item.ItemStack stack = new net.minecraft.world.item.ItemStack((IMaterial)DedicatedServer.getServer().bc().d(Registries.K).a(MinecraftKey.c((String)baseItemStack.getType().id())), baseItemStack.getAmount());
        NBTTagCompound nbt = (NBTTagCompound)this.fromNative(baseItemStack.getNbtData());
        if (nbt != null) {
            DataComponentPatch patch = (DataComponentPatch)COMPONENTS_CODEC.parse((DynamicOps)registryAccess.a((DynamicOps)DynamicOpsNBT.a), (Object)nbt).getOrThrow();
            stack.b(patch);
        }
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)stack);
    }

    @Override
    protected void preCaptureStates(WorldServer serverLevel) {
        serverLevel.captureTreeGeneration = true;
        serverLevel.captureBlockStates = true;
    }

    @Override
    protected List<org.bukkit.block.BlockState> getCapturedBlockStatesCopy(WorldServer serverLevel) {
        return new ArrayList<org.bukkit.block.BlockState>(serverLevel.capturedBlockStates.values());
    }

    @Override
    protected void postCaptureBlockStates(WorldServer serverLevel) {
        serverLevel.captureBlockStates = false;
        serverLevel.captureTreeGeneration = false;
        serverLevel.capturedBlockStates.clear();
    }

    @Override
    protected WorldServer getServerLevel(World world) {
        return ((CraftWorld)world).getHandle();
    }

    @Override
    public boolean generateFeature(ConfiguredFeatureType feature, World world, EditSession editSession, BlockVector3 pt) {
        WorldServer serverLevel = this.getServerLevel(world);
        ChunkGenerator generator = serverLevel.getMinecraftWorld().l().g();
        WorldGenFeatureConfigured configuredFeature = (WorldGenFeatureConfigured)serverLevel.H_().d(Registries.aI).a(MinecraftKey.c((String)feature.id()));
        FaweBlockStateListPopulator populator = new FaweBlockStateListPopulator(serverLevel);
        List placed = TaskManager.taskManager().sync(() -> {
            this.preCaptureStates(serverLevel);
            try {
                if (!configuredFeature.a((GeneratorAccessSeed)populator, generator, serverLevel.z, new BlockPosition(pt.x(), pt.y(), pt.z()))) {
                    List list = null;
                    return list;
                }
                ArrayList placedBlocks = new ArrayList(populator.getList());
                placedBlocks.addAll(serverLevel.capturedBlockStates.values());
                ArrayList arrayList = placedBlocks;
                return arrayList;
            }
            finally {
                this.postCaptureBlockStates(serverLevel);
            }
        });
        return this.placeFeatureIntoSession(editSession, populator, placed);
    }

    @Override
    public boolean generateStructure(StructureType type, World world, EditSession editSession, BlockVector3 pt) {
        WorldServer serverLevel = this.getServerLevel(world);
        Structure k = (Structure)serverLevel.H_().d(Registries.aR).a(MinecraftKey.c((String)type.id()));
        if (k == null) {
            return false;
        }
        ChunkProviderServer chunkManager = serverLevel.l();
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(new BlockPosition(pt.x(), pt.y(), pt.z()));
        FaweBlockStateListPopulator populator = new FaweBlockStateListPopulator(serverLevel);
        List placed = TaskManager.taskManager().sync(() -> {
            this.preCaptureStates(serverLevel);
            try {
                StructureStart structureStart = k.a(serverLevel.H_(), chunkManager.g(), chunkManager.g().d(), chunkManager.i(), serverLevel.q(), serverLevel.C(), chunkPos, 0, (LevelHeightAccessor)populator, biome -> true);
                if (!structureStart.b()) {
                    List list = null;
                    return list;
                }
                StructureBoundingBox boundingBox = structureStart.a();
                ChunkCoordIntPair min = new ChunkCoordIntPair(SectionPosition.a((int)boundingBox.h()), SectionPosition.a((int)boundingBox.j()));
                ChunkCoordIntPair max = new ChunkCoordIntPair(SectionPosition.a((int)boundingBox.k()), SectionPosition.a((int)boundingBox.m()));
                ChunkCoordIntPair.a((ChunkCoordIntPair)min, (ChunkCoordIntPair)max).forEach(chunkPosx -> structureStart.a((GeneratorAccessSeed)populator, serverLevel.a(), chunkManager.g(), serverLevel.E_(), new StructureBoundingBox(chunkPosx.d(), serverLevel.I_(), chunkPosx.e(), chunkPosx.f(), serverLevel.am(), chunkPosx.g()), chunkPosx));
                ArrayList placedBlocks = new ArrayList(populator.getList());
                placedBlocks.addAll(serverLevel.capturedBlockStates.values());
                ArrayList arrayList = placedBlocks;
                return arrayList;
            }
            finally {
                this.postCaptureBlockStates(serverLevel);
            }
        });
        return this.placeFeatureIntoSession(editSession, populator, placed);
    }

    private boolean placeFeatureIntoSession(EditSession editSession, FaweBlockStateListPopulator populator, List<CraftBlockState> placed) {
        if (placed == null || placed.isEmpty()) {
            return false;
        }
        for (CraftBlockState craftBlockState : placed) {
            if (craftBlockState == null) continue;
            BlockPosition pos = craftBlockState.getPosition();
            editSession.setBlock(pos.u(), pos.v(), pos.w(), BukkitAdapter.adapt(craftBlockState.getBlockData()));
            TileEntity blockEntity = populator.c_(pos);
            if (blockEntity == null) continue;
            NBTTagCompound tag = blockEntity.c((HolderLookup.a)DedicatedServer.getServer().bc());
            editSession.setTile(pos.u(), pos.v(), pos.w(), (CompoundTag)this.toNative((NBTBase)tag));
        }
        return true;
    }

    @Override
    public void setupFeatures() {
        DedicatedServer server = ((CraftServer)Bukkit.getServer()).getServer();
        Set face_features = Arrays.stream(new Class[]{AquaticFeatures.class, PileFeatures.class, TreeFeatures.class, VegetationFeatures.class}).flatMap(c2 -> Arrays.stream(c2.getFields())).filter(f -> {
            int modifiers = f.getModifiers();
            return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
        }).filter(f -> f.getType().equals(ResourceKey.class)).map(f -> {
            try {
                Object val = f.get(null);
                return val;
            }
            catch (IllegalAccessException e) {
                LOGGER.error((Object)e);
                return null;
            }
        }).filter(Objects::nonNull).map(o -> (ResourceKey)o).map(k -> k.a().toString()).collect(Collectors.toCollection(HashSet::new));
        face_features.add(CaveFeatures.d.a().toString());
        face_features.add(CaveFeatures.e.a().toString());
        face_features.add(CaveFeatures.f.a().toString());
        face_features.add(CaveFeatures.h.a().toString());
        face_features.add(CaveFeatures.j.a().toString());
        face_features.add(CaveFeatures.k.a().toString());
        face_features.add(CaveFeatures.l.a().toString());
        face_features.add(CaveFeatures.o.a().toString());
        face_features.add(EndFeatures.e.a().toString());
        face_features.add(EndFeatures.a.a().toString());
        face_features.add(NetherFeatures.b.a().toString());
        face_features.add(NetherFeatures.c.a().toString());
        face_features.add(NetherFeatures.f.a().toString());
        for (MinecraftKey name : server.bc().d(Registries.aI).f()) {
            String id = name.toString();
            if (ConfiguredFeatureType.REGISTRY.get(id) != null) continue;
            ConfiguredFeatureType.REGISTRY.register(id, new ConfiguredFeatureType(id, face_features.contains(id)));
        }
        for (MinecraftKey name : server.bc().d(Registries.aR).f()) {
            if (StructureType.REGISTRY.get(name.toString()) != null) continue;
            StructureType.REGISTRY.register(name.toString(), new StructureType(name.toString()));
        }
    }

    @Override
    public BaseItemStack adapt(ItemStack itemStack) {
        IRegistryCustom.Dimension registryAccess = DedicatedServer.getServer().bc();
        net.minecraft.world.item.ItemStack nmsStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        Supplier<NBTBase> tag = () -> (NBTBase)COMPONENTS_CODEC.encodeStart((DynamicOps)registryAccess.a((DynamicOps)DynamicOpsNBT.a), (Object)nmsStack.d()).getOrThrow();
        return new BaseItemStack(BukkitAdapter.asItemType(itemStack.getType()), LazyReference.from(() -> (LinCompoundTag)this.toNativeLin((NBTBase)tag.get())), itemStack.getAmount());
    }

    @Override
    public Tag toNative(NBTBase foreign) {
        return this.parent.toNative(foreign);
    }

    @Override
    public NBTBase fromNative(Tag foreign) {
        if (foreign instanceof PaperweightLazyCompoundTag) {
            return ((PaperweightLazyCompoundTag)foreign).get();
        }
        return (NBTBase)this.parent.fromNative(foreign);
    }

    @Override
    public boolean regenerate(World bukkitWorld, Region region, Extent target, RegenOptions options) throws Exception {
        return new PaperweightRegen(bukkitWorld, region, target, options).regenerate();
    }

    @Override
    public IChunkGet get(World world, int chunkX, int chunkZ) {
        return new PaperweightGetBlocks(world, chunkX, chunkZ);
    }

    @Override
    public int getInternalBiomeId(BiomeType biomeType) {
        IRegistry registry = MinecraftServer.getServer().bc().d(Registries.aF);
        MinecraftKey resourceLocation = MinecraftKey.c((String)biomeType.id());
        BiomeBase biome = (BiomeBase)registry.a(resourceLocation);
        return registry.a((Object)biome);
    }

    @Override
    public Iterable<NamespacedKey> getRegisteredBiomes() {
        IRegistryWritable biomeRegistry = (IRegistryWritable)((CraftServer)Bukkit.getServer()).getServer().bc().d(Registries.aF);
        List<MinecraftKey> keys = biomeRegistry.t().map(arg_0 -> ((IRegistryWritable)biomeRegistry).b(arg_0)).filter(Objects::nonNull).toList();
        ArrayList<NamespacedKey> namespacedKeys = new ArrayList<NamespacedKey>();
        for (MinecraftKey key : keys) {
            try {
                namespacedKeys.add(CraftNamespacedKey.fromMinecraft((MinecraftKey)key));
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Error converting biome key {}", (Object)key.toString(), (Object)e);
            }
        }
        return namespacedKeys;
    }

    @Override
    public RelighterFactory getRelighterFactory() {
        if (PaperLib.isPaper()) {
            return new PaperweightStarlightRelighterFactory();
        }
        return new NMSRelighterFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<Property<?>>> getAllProperties() {
        if (this.initialised) {
            return this.allBlockProperties;
        }
        PaperweightFaweAdapter paperweightFaweAdapter = this;
        synchronized (paperweightFaweAdapter) {
            if (this.initialised) {
                return this.allBlockProperties;
            }
            this.init();
            return this.allBlockProperties;
        }
    }

    @Override
    public IBatchProcessor getTickingPostProcessor() {
        return new PaperweightPostProcessor();
    }

    @Override
    public PlacementStateProcessor getPlatformPlacementProcessor(Extent extent, BlockTypeMask mask, Region region) {
        return new PaperweightPlacementStateProcessor(extent, mask, region);
    }

    private boolean wasAccessibleSinceLastSave(PlayerChunk holder) {
        if (PaperLib.isPaper()) {
            return true;
        }
        try {
            return (Boolean)CHUNK_HOLDER_WAS_ACCESSIBLE_SINCE_LAST_SAVE.invoke((Object)holder, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException ignored) {
            return false;
        }
    }

    static {
        COMPONENTS_CODEC = DataComponentPatch.b.optionalFieldOf("components", (Object)DataComponentPatch.a).codec();
        try {
            CHUNK_HOLDER_WAS_ACCESSIBLE_SINCE_LAST_SAVE = PlayerChunk.class.getDeclaredMethod("wasAccessibleSinceLastSave", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        SUPPORTED_SIDE_EFFECTS = Sets.immutableEnumSet((Enum)SideEffect.HISTORY, (Enum[])new SideEffect[]{SideEffect.HEIGHTMAPS, SideEffect.LIGHTING, SideEffect.NEIGHBORS});
    }
}

