/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions;

import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.extent.SingleRegionExtent;
import com.fastasyncworldedit.core.extent.filter.block.ChunkFilterBlock;
import com.fastasyncworldedit.core.extent.processor.ProcessorScope;
import com.fastasyncworldedit.core.limit.FaweLimit;
import com.fastasyncworldedit.core.queue.Filter;
import com.fastasyncworldedit.core.queue.IBatchProcessor;
import com.fastasyncworldedit.core.queue.IChunk;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.internal.util.DeprecationUtil;
import com.sk89q.worldedit.internal.util.NonAbstractForCompatibility;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.world.World;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public interface Region
extends Iterable<BlockVector3>,
Cloneable,
IBatchProcessor {
    public BlockVector3 getMinimumPoint();

    public BlockVector3 getMaximumPoint();

    default public BlockVector3 getDimensions() {
        return this.getMaximumPoint().subtract(this.getMinimumPoint()).add(1, 1, 1);
    }

    default public CuboidRegion getBoundingBox() {
        return new CuboidRegion(this.getMinimumPoint(), this.getMaximumPoint());
    }

    default public Vector3 getCenter() {
        return this.getMinimumPoint().add(this.getMaximumPoint()).toVector3().divide(2.0);
    }

    @Deprecated
    default public int getArea() {
        return (int)this.getVolume();
    }

    @NonAbstractForCompatibility(delegateName="getArea", delegateParams={})
    default public long getVolume() {
        DeprecationUtil.checkDelegatingOverride(this.getClass());
        return this.getArea();
    }

    public int getWidth();

    public int getHeight();

    public int getLength();

    public void expand(BlockVector3 ... var1) throws RegionOperationException;

    public void contract(BlockVector3 ... var1) throws RegionOperationException;

    public void shift(BlockVector3 var1) throws RegionOperationException;

    public boolean contains(BlockVector3 var1);

    public Set<BlockVector2> getChunks();

    public Set<BlockVector3> getChunkCubes();

    @Nullable
    public World getWorld();

    public void setWorld(@Nullable World var1);

    public Region clone();

    public List<BlockVector2> polygonize(int var1);

    default public boolean contains(int x, int y, int z) {
        return this.contains(BlockVector3.at(x, y, z));
    }

    default public boolean contains(int x, int z) {
        return this.contains(BlockVector3.at(x, 0, z));
    }

    default public boolean isGlobal() {
        BlockVector3 pos1 = this.getMinimumPoint();
        BlockVector3 pos2 = this.getMaximumPoint();
        return pos1.x() == Integer.MIN_VALUE && pos1.z() == Integer.MIN_VALUE && pos2.x() == Integer.MAX_VALUE && pos2.z() == Integer.MAX_VALUE && pos1.y() <= WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.WORLD_EDITING).versionMinY() && pos2.y() >= WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.WORLD_EDITING).versionMaxY();
    }

    default public int getMinimumY() {
        return this.getMinimumPoint().y();
    }

    default public int getMaximumY() {
        return this.getMaximumPoint().y();
    }

    default public void filter(IChunk chunk, Filter filter, ChunkFilterBlock block, IChunkGet get, IChunkSet set, boolean full) {
        int minSection = Math.max(get.getMinSectionPosition(), this.getMinimumY() >> 4);
        int maxSection = Math.min(get.getMaxSectionPosition(), this.getMaximumY() >> 4);
        for (int layer = minSection; layer <= maxSection; ++layer) {
            if (!full && !get.hasSection(layer)) {
                return;
            }
            block = block.initLayer(get, set, layer);
            block.filter(filter, this);
        }
    }

    default public void filter(IChunk chunk, Filter filter, ChunkFilterBlock block, IChunkGet get, IChunkSet set, int minY, int maxY, boolean full) {
        int minSection = minY >> 4;
        int maxSection = maxY >> 4;
        int yStart = minY & 0xF;
        int yEnd = maxY & 0xF;
        if (minSection == maxSection) {
            this.filter(chunk, filter, block, get, set, minSection, yStart, yEnd, full);
            return;
        }
        if (yStart != 0) {
            this.filter(chunk, filter, block, get, set, minSection, yStart, 15, full);
            ++minSection;
        }
        if (yEnd != 15) {
            this.filter(chunk, filter, block, get, set, maxSection, 0, yEnd, full);
            --maxSection;
        }
        for (int layer = minSection; layer <= maxSection; ++layer) {
            this.filter(chunk, filter, block, get, set, layer, full);
        }
    }

    default public void filter(IChunk chunk, Filter filter, ChunkFilterBlock block, IChunkGet get, IChunkSet set, int layer, boolean full) {
        if (!full && !get.hasSection(layer)) {
            return;
        }
        block = block.initLayer(get, set, layer);
        block.filter(filter);
    }

    default public void filter(IChunk chunk, Filter filter, ChunkFilterBlock block, IChunkGet get, IChunkSet set, int layer, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean full) {
        if (!full && !get.hasSection(layer)) {
            return;
        }
        block = block.initLayer(get, set, layer);
        block.filter(filter, minX, minY, minZ, maxX, maxY, maxZ);
    }

    default public void filter(IChunk chunk, Filter filter, ChunkFilterBlock block, IChunkGet get, IChunkSet set, int layer, int yStart, int yEnd, boolean full) {
        if (!full && !get.hasSection(layer)) {
            return;
        }
        block = block.initLayer(get, set, layer);
        block.filter(filter, yStart, yEnd);
    }

    default public boolean containsEntireCuboid(int bx, int tx, int by, int ty, int bz, int tz) {
        return this.contains(bx, by, bz) && this.contains(bx, by, tz) && this.contains(tx, by, bz) && this.contains(tx, by, tz) && this.contains(bx, ty, bz) && this.contains(bx, ty, tz) && this.contains(tx, ty, bz) && this.contains(tx, ty, tz);
    }

    default public boolean containsChunk(int chunkX, int chunkZ) {
        int bx = chunkX << 4;
        int bz = chunkZ << 4;
        int tx = bx + 15;
        int tz = bz + 15;
        BlockVector3 min = this.getMinimumPoint();
        BlockVector3 max = this.getMaximumPoint();
        return tx >= min.x() && bx <= max.x() && tz >= min.z() && bz <= max.z();
    }

    @Override
    default public IChunkSet processSet(IChunk chunk, IChunkGet get, IChunkSet set) {
        int bx = chunk.getX() << 4;
        int bz = chunk.getZ() << 4;
        int tx = bx + 15;
        int tz = bz + 15;
        BlockVector3 min = this.getMinimumPoint();
        BlockVector3 max = this.getMaximumPoint();
        if (tx >= min.x() && bx <= max.x() && tz >= min.z() && bz <= max.z()) {
            boolean processExtra = false;
            int minLayer = Math.max(this.getMinimumY(), chunk.getMinY()) >> 4;
            int maxLayer = Math.min(this.getMaximumY(), chunk.getMaxY()) >> 4;
            for (int layer = minLayer; layer <= maxLayer; ++layer) {
                int ty;
                int by;
                if (!set.hasSection(layer) || this.containsEntireCuboid(bx, tx, by = layer << 4, ty = by + 15, bz, tz)) continue;
                processExtra = true;
                char[] arr = set.loadIfPresent(layer);
                if (arr == null) continue;
                int index = 0;
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        int x = 0;
                        while (x < 16) {
                            if (arr[index] != '\u0000' && !this.contains(bx + x, by + y, bz + z)) {
                                arr[index] = '\u0000';
                            }
                            ++x;
                            ++index;
                        }
                    }
                }
                set.setBlocks(layer, arr);
            }
            if (processExtra) {
                BlockVector3 chunkPos = chunk.getChunkBlockCoord().withY(0);
                this.trimNBT(set, this::contains, pos -> this.contains(pos.add(chunkPos)));
            }
            return set;
        }
        return null;
    }

    default public IChunkSet processSet(IChunk chunk, IChunkGet get, IChunkSet set, boolean asBlacklist) {
        if (!asBlacklist) {
            return this.processSet(chunk, get, set);
        }
        int bx = chunk.getX() << 4;
        int bz = chunk.getZ() << 4;
        int tx = bx + 15;
        int tz = bz + 15;
        BlockVector3 min = this.getMinimumPoint();
        BlockVector3 max = this.getMaximumPoint();
        if (tx >= min.x() && bx <= max.x() && tz >= min.z() && bz <= max.z()) {
            boolean processExtra = false;
            int minLayer = Math.max(this.getMinimumY(), chunk.getMinY()) >> 4;
            int maxLayer = Math.min(this.getMaximumY(), chunk.getMaxY()) >> 4;
            for (int layer = minLayer; layer <= maxLayer; ++layer) {
                int by = layer << 4;
                int ty = by + 15;
                if (this.containsEntireCuboid(bx, tx, by, ty, bz, tz)) {
                    set.setBlocks(layer, FaweCache.INSTANCE.EMPTY_CHAR_4096);
                    processExtra = true;
                    continue;
                }
                char[] arr = set.load(layer);
                int index = 0;
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        int x = 0;
                        while (x < 16) {
                            if (arr[index] != '\u0000' && this.contains(x, y, z)) {
                                arr[index] = '\u0000';
                                processExtra = true;
                            }
                            ++x;
                            ++index;
                        }
                    }
                }
                if (!processExtra) continue;
                set.setBlocks(layer, arr);
            }
            if (processExtra) {
                BlockVector3 chunkPos = chunk.getChunkBlockCoord().withY(0);
                this.trimNBT(set, bv3 -> !this.contains((BlockVector3)bv3), bv3 -> !this.contains(bv3.add(chunkPos)));
            }
            return set;
        }
        return set;
    }

    @Override
    default public Extent construct(Extent child) {
        if (this.isGlobal()) {
            return child;
        }
        return new SingleRegionExtent(child, FaweLimit.MAX, this);
    }

    @Override
    default public ProcessorScope getScope() {
        return ProcessorScope.REMOVING_BLOCKS;
    }
}

