/*
 * Decompiled with CFR 0.152.
 */
package lightningitemsmod.item;

import com.google.common.collect.Iterables;
import java.util.Map;
import lightningitemsmod.init.LightningItemsModModItems;
import lightningitemsmod.procedures.EntityArmorBootsTickEventProcedure;
import lightningitemsmod.procedures.EntityArmorChestplateTickEventProcedure;
import lightningitemsmod.procedures.EntityArmorHelmetTickEventProcedure;
import lightningitemsmod.procedures.EntityArmorLeggingsTickEventProcedure;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public abstract class EntityArmorItem
extends Item {
    public static ArmorMaterial ARMOR_MATERIAL = new ArmorMaterial(47, Map.of(ArmorType.BOOTS, 7, ArmorType.LEGGINGS, 6, ArmorType.CHESTPLATE, 7, ArmorType.HELMET, 8, ArmorType.BODY, 7), 9, (Holder)DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)ResourceLocation.parse((String)"item.armor.equip_diamond")), 3.7f, 0.2f, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"lightning_items_mod:entity_armor_repair_items")), ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.parse((String)"lightning_items_mod:entity_armor")));

    @SubscribeEvent
    public static void registerItemExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"lightning_items_mod:textures/models/armor/op_armor_reimagined_layer_1.png");
            }
        }, new Item[]{(Item)LightningItemsModModItems.ENTITY_ARMOR_HELMET.get()});
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"lightning_items_mod:textures/models/armor/op_armor_reimagined_layer_1.png");
            }
        }, new Item[]{(Item)LightningItemsModModItems.ENTITY_ARMOR_CHESTPLATE.get()});
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"lightning_items_mod:textures/models/armor/op_armor_reimagined_layer_2.png");
            }
        }, new Item[]{(Item)LightningItemsModModItems.ENTITY_ARMOR_LEGGINGS.get()});
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"lightning_items_mod:textures/models/armor/op_armor_reimagined_layer_1.png");
            }
        }, new Item[]{(Item)LightningItemsModModItems.ENTITY_ARMOR_BOOTS.get()});
    }

    private EntityArmorItem(Item.Properties properties) {
        super(properties);
    }

    public static class Boots
    extends EntityArmorItem {
        public Boots(Item.Properties properties) {
            super(properties.humanoidArmor(ARMOR_MATERIAL, ArmorType.BOOTS));
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, EquipmentSlot slot) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot);
            if (entity instanceof Player && !Iterables.contains((Iterable)(player = (Player)entity).getInventory().getNonEquipmentItems(), (Object)itemstack)) {
                EntityArmorBootsTickEventProcedure.execute(entity);
            }
        }
    }

    public static class Leggings
    extends EntityArmorItem {
        public Leggings(Item.Properties properties) {
            super(properties.humanoidArmor(ARMOR_MATERIAL, ArmorType.LEGGINGS));
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, EquipmentSlot slot) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot);
            if (entity instanceof Player && !Iterables.contains((Iterable)(player = (Player)entity).getInventory().getNonEquipmentItems(), (Object)itemstack)) {
                EntityArmorLeggingsTickEventProcedure.execute(entity);
            }
        }
    }

    public static class Chestplate
    extends EntityArmorItem {
        public Chestplate(Item.Properties properties) {
            super(properties.humanoidArmor(ARMOR_MATERIAL, ArmorType.CHESTPLATE));
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, EquipmentSlot slot) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot);
            if (entity instanceof Player && !Iterables.contains((Iterable)(player = (Player)entity).getInventory().getNonEquipmentItems(), (Object)itemstack)) {
                EntityArmorChestplateTickEventProcedure.execute(entity);
            }
        }
    }

    public static class Helmet
    extends EntityArmorItem {
        public Helmet(Item.Properties properties) {
            super(properties.humanoidArmor(ARMOR_MATERIAL, ArmorType.HELMET));
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, EquipmentSlot slot) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot);
            if (entity instanceof Player && !Iterables.contains((Iterable)(player = (Player)entity).getInventory().getNonEquipmentItems(), (Object)itemstack)) {
                EntityArmorHelmetTickEventProcedure.execute(entity);
            }
        }
    }
}

