/*
 * Decompiled with CFR 0.152.
 */
package lightningitemsmod.item;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import lightningitemsmod.entity.LightningArrowProjectileEntity;
import lightningitemsmod.procedures.LightningBowItemInInventoryTickProcedure;
import lightningitemsmod.procedures.LightningBowOnPlayerStoppedUsingProcedure;
import lightningitemsmod.procedures.LightningBowPropertyValueProviderProcedure;
import lightningitemsmod.procedures.LightningBowRightclickedProcedure;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;

public class LightningBowItem
extends Item {
    public LightningBowItem(Item.Properties properties) {
        super(properties.rarity(Rarity.COMMON).durability(100).enchantable(2));
    }

    public ItemUseAnimation getUseAnimation(ItemStack itemstack) {
        return ItemUseAnimation.BOW;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 72000;
    }

    public InteractionResult use(Level world, Player entity, InteractionHand hand) {
        InteractionResult.Fail ar = InteractionResult.FAIL;
        if (entity.getAbilities().instabuild || this.findAmmo(entity) != ItemStack.EMPTY) {
            ar = InteractionResult.SUCCESS;
            entity.startUsingItem(hand);
        }
        LightningBowRightclickedProcedure.execute((Entity)entity, entity.getItemInHand(hand));
        return ar;
    }

    public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, EquipmentSlot slot) {
        super.inventoryTick(itemstack, world, entity, slot);
        LightningBowItemInInventoryTickProcedure.execute(entity, itemstack);
    }

    public boolean releaseUsing(ItemStack itemstack, Level world, LivingEntity entity, int time) {
        LightningBowOnPlayerStoppedUsingProcedure.execute((Entity)entity, itemstack);
        if (!world.isClientSide() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            float pullingPower = BowItem.getPowerForTime((int)(this.getUseDuration(itemstack, (LivingEntity)player) - time));
            if ((double)pullingPower < 0.1) {
                return false;
            }
            ItemStack stack = this.findAmmo((Player)player);
            if (player.getAbilities().instabuild || stack != ItemStack.EMPTY) {
                LightningArrowProjectileEntity projectile = LightningArrowProjectileEntity.shoot(world, entity, world.getRandom(), pullingPower);
                itemstack.hurtAndBreak(1, entity, LivingEntity.getSlotForHand((InteractionHand)entity.getUsedItemHand()));
                if (player.getAbilities().instabuild) {
                    projectile.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                } else if (stack.isDamageableItem()) {
                    if (world instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)world;
                        stack.hurtAndBreak(1, serverLevel, player, _stkprov -> {});
                    }
                } else {
                    stack.shrink(1);
                }
            }
        }
        return super.releaseUsing(itemstack, world, entity, time);
    }

    private ItemStack findAmmo(Player player) {
        ItemStack stack = ProjectileWeaponItem.getHeldProjectile((LivingEntity)player, e -> e.getItem() == LightningArrowProjectileEntity.PROJECTILE_ITEM.getItem());
        if (stack.isEmpty()) {
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStack teststack = player.getInventory().getItem(i);
                if (teststack.isEmpty() || teststack.getItem() != LightningArrowProjectileEntity.PROJECTILE_ITEM.getItem()) continue;
                stack = teststack;
                break;
            }
        }
        return stack;
    }

    public record PullingProperty() implements RangeSelectItemModelProperty
    {
        public static final MapCodec<PullingProperty> MAP_CODEC = MapCodec.unit((Object)new PullingProperty());

        public float get(ItemStack itemStackToRender, @Nullable ClientLevel clientWorld, @Nullable LivingEntity entity, int seed) {
            return (float)LightningBowPropertyValueProviderProcedure.execute((Entity)entity);
        }

        public MapCodec<PullingProperty> type() {
            return MAP_CODEC;
        }
    }
}

