/*
 * Decompiled with CFR 0.152.
 */
package lightningitemsmod.network;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.RecordBuilder;
import lightningitemsmod.LightningItemsModMod;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class LightningItemsModModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"lightning_items_mod");

    public static void registerEventHandlers() {
        NeoForge.EVENT_BUS.addListener(GameEventHandler::onWorldCreate);
        NeoForge.EVENT_BUS.addListener(GameEventHandler::onWorldLoad);
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        LightningItemsModMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"lightning_items_mod", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                CompoundTag tag = switch (message.dataType) {
                    case 0 -> (CompoundTag)MapVariables.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)((MapVariables)message.data)).getOrThrow();
                    case 1 -> (CompoundTag)WorldVariables.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)((WorldVariables)message.data)).getOrThrow();
                    default -> throw new IllegalArgumentException("Unknown data type");
                };
                buffer.writeNbt((Tag)tag);
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            MapVariables data = switch (dataType) {
                case 0 -> (MapVariables)((Object)((Object)MapVariables.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt).getOrThrow()));
                case 1 -> (WorldVariables)((Object)((Object)WorldVariables.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt).getOrThrow()));
                default -> null;
            };
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "lightning_items_mod_mapvars";
        public String empty_string = "";
        public static final Codec<MapVariables> CODEC = new Codec<MapVariables>(){

            public <T> DataResult<Pair<MapVariables, T>> decode(DynamicOps<T> ops, T input) {
                return ops.getMap(input).flatMap(map -> {
                    Builder builder = new Builder();
                    DataResult emptyStringResult = ops.getStringValue(map.get("empty_string"));
                    if (emptyStringResult.result().isEmpty()) {
                        return DataResult.error(() -> "Missing or invalid 'empty_string' field");
                    }
                    builder.empty_string = (String)emptyStringResult.result().get();
                    return DataResult.success((Object)Pair.of((Object)((Object)builder.build()), (Object)ops.empty()));
                });
            }

            public <T> DataResult<T> encode(MapVariables input, DynamicOps<T> ops, T prefix) {
                RecordBuilder recordBuilder = ops.mapBuilder();
                recordBuilder.add("empty_string", ops.createString(input.empty_string));
                return recordBuilder.build(prefix);
            }
        };
        public static final SavedDataType<MapVariables> TYPE = new SavedDataType("lightning_items_mod_mapvars", ctx -> new MapVariables(""), ctx -> CODEC, DataFixTypes.LEVEL);
        static MapVariables clientSide = new MapVariables("");

        public MapVariables(String empty_string) {
            this.empty_string = empty_string;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(TYPE);
            }
            return clientSide;
        }

        private static class Builder {
            String empty_string = "";

            private Builder() {
            }

            MapVariables build() {
                return new MapVariables(this.empty_string);
            }
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "lightning_items_mod_worldvars";
        public double DimensionNameSoundLockTimer;
        public boolean DimensionNameSoundLock;
        public static final Codec<WorldVariables> CODEC = new Codec<WorldVariables>(){

            public <T> DataResult<Pair<WorldVariables, T>> decode(DynamicOps<T> ops, T input) {
                return ops.getMap(input).flatMap(map -> {
                    Builder builder = new Builder();
                    Codec.DOUBLE.decode(ops, map.get("DimensionNameSoundLockTimer")).result().ifPresent(v -> {
                        builder.DimensionNameSoundLockTimer = (Double)v.getFirst();
                    });
                    Codec.BOOL.decode(ops, map.get("DimensionNameSoundLock")).result().ifPresent(v -> {
                        builder.DimensionNameSoundLock = (Boolean)v.getFirst();
                    });
                    return DataResult.success((Object)Pair.of((Object)((Object)builder.build()), (Object)ops.empty()));
                });
            }

            public <T> DataResult<T> encode(WorldVariables input, DynamicOps<T> ops, T prefix) {
                RecordBuilder recordBuilder = ops.mapBuilder();
                recordBuilder.add("DimensionNameSoundLockTimer", Codec.DOUBLE.encode((Object)input.DimensionNameSoundLockTimer, ops, ops.empty()));
                recordBuilder.add("DimensionNameSoundLock", Codec.BOOL.encode((Object)input.DimensionNameSoundLock, ops, ops.empty()));
                return recordBuilder.build(prefix);
            }
        };
        public static final SavedDataType<WorldVariables> TYPE = new SavedDataType("lightning_items_mod_worldvars", ctx -> new WorldVariables(0.0, false), ctx -> CODEC, DataFixTypes.LEVEL);
        static WorldVariables clientSide = new WorldVariables(0.0, false);

        public WorldVariables(double DimensionNameSoundLockTimer, boolean DimensionNameSoundLock) {
            this.DimensionNameSoundLockTimer = DimensionNameSoundLockTimer;
            this.DimensionNameSoundLock = DimensionNameSoundLock;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(TYPE);
            }
            return clientSide;
        }

        private static class Builder {
            double DimensionNameSoundLockTimer = 0.0;
            boolean DimensionNameSoundLock = false;

            private Builder() {
            }

            WorldVariables build() {
                return new WorldVariables(this.DimensionNameSoundLockTimer, this.DimensionNameSoundLock);
            }
        }
    }

    public static class GameEventHandler {
        @SubscribeEvent
        public static void onWorldCreate(LevelEvent.CreateSpawnPosition event) {
            LevelAccessor levelAccessor;
            if (!event.getLevel().isClientSide() && (levelAccessor = event.getLevel()) instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)levelAccessor;
                WorldVariables worldVariables = WorldVariables.get((LevelAccessor)level);
                worldVariables.DimensionNameSoundLockTimer = 0.0;
                worldVariables.DimensionNameSoundLock = false;
                worldVariables.setDirty();
                MapVariables mapVariables = MapVariables.get((LevelAccessor)level);
                mapVariables.setDirty();
            }
        }

        @SubscribeEvent
        public static void onWorldLoad(LevelEvent.Load event) {
            LevelAccessor levelAccessor;
            if (!event.getLevel().isClientSide() && (levelAccessor = event.getLevel()) instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)levelAccessor;
                WorldVariables.get((LevelAccessor)level).setDirty();
                MapVariables.get((LevelAccessor)level).setDirty();
            }
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

