/*
 * Decompiled with CFR 0.152.
 */
package lightningitemsmod.procedures;

import lightningitemsmod.entity.LightningArrowProjectileEntity;
import lightningitemsmod.init.LightningItemsModModEntities;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class LightningBowOnPlayerStoppedUsingProcedure {
    public static void execute(Entity entity, ItemStack itemstack) {
        Entity _shootFrom;
        Level projectileLevel;
        if (entity == null) {
            return;
        }
        if (entity.getPersistentData().getBooleanOr("BowLoading", false) && entity.getPersistentData().getDoubleOr("BowPull", 0.0) > 3.0 && !(projectileLevel = (_shootFrom = entity).level()).isClientSide()) {
            AbstractArrow _entityToSpawn = LightningBowOnPlayerStoppedUsingProcedure.initArrowProjectile(new LightningArrowProjectileEntity((EntityType<? extends LightningArrowProjectileEntity>)((EntityType)LightningItemsModModEntities.LIGHTNING_ARROW_PROJECTILE.get()), 0.0, 0.0, 0.0, projectileLevel, LightningBowOnPlayerStoppedUsingProcedure.createArrowWeaponItemStack(projectileLevel, 1, (byte)0)), null, (float)(2.0 * (entity.getPersistentData().getDoubleOr("BowPull", 0.0) / ((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDoubleOr("BowMaxPull", 0.0))), true, false, false, AbstractArrow.Pickup.DISALLOWED);
            _entityToSpawn.setPos(_shootFrom.getX(), _shootFrom.getEyeY() - 0.1, _shootFrom.getZ());
            _entityToSpawn.shoot(_shootFrom.getLookAngle().x, _shootFrom.getLookAngle().y, _shootFrom.getLookAngle().z, (float)(2.0 * (entity.getPersistentData().getDoubleOr("BowPull", 0.0) / ((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDoubleOr("BowMaxPull", 0.0))), 0.0f);
            projectileLevel.addFreshEntity((Entity)_entityToSpawn);
        }
        entity.getPersistentData().putBoolean("BowLoading", true);
        entity.getPersistentData().putDouble("BowPull", 0.0);
    }

    private static AbstractArrow initArrowProjectile(AbstractArrow entityToSpawn, Entity shooter, float damage, boolean silent, boolean fire, boolean particles, AbstractArrow.Pickup pickup) {
        entityToSpawn.setOwner(shooter);
        entityToSpawn.setBaseDamage((double)damage);
        if (silent) {
            entityToSpawn.setSilent(true);
        }
        if (fire) {
            entityToSpawn.igniteForSeconds(100.0f);
        }
        if (particles) {
            entityToSpawn.setCritArrow(true);
        }
        entityToSpawn.pickup = pickup;
        return entityToSpawn;
    }

    private static ItemStack createArrowWeaponItemStack(Level level, int knockback, byte piercing) {
        ItemStack weapon = new ItemStack((ItemLike)Items.ARROW);
        if (knockback > 0) {
            weapon.enchant((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.KNOCKBACK), knockback);
        }
        if (piercing > 0) {
            weapon.enchant((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.PIERCING), (int)piercing);
        }
        return weapon;
    }
}

