StartupEvents.registry("palladium:abilities", event => {
    event.create("foi1ys_lanterns:telekinesis")
        .icon(palladium.createItemIcon("minecraft:player_head"))

        .documentationDescription("It's telekinesis does it even need an explanation? (Entities only for now, sorry)")

        .addProperty("range", "float", 15, "The range of the ability.")
        .addProperty("superpower", "string", 'null', "Superpower to apply when grabbed")

        .firstTick((entity, entry, holder, enabled) => {
            if (enabled) {
            const superpower = entry.getPropertyByName("superpower")

                entity.runCommandSilent("tag @s add caster")

                const range = entry.getPropertyByName("range")
                const target = entity.rayTrace(range).entity;

                if (target !== null) {
                    target.addTag("grabbed")
                    entity.runCommandSilent("superpower add " + superpower + " @e[distance=0.." + range + ",tag=grabbed]")
                    console.log(superpower);
                }
            }
        })

        .tick((entity, entry, holder, enabled) => {
            if (enabled) {
                const range = entry.getPropertyByName("range")

                entity.runCommandSilent("execute as @s at @s run tp @e[distance=.." + range + ",limit=1,sort=nearest,type=!palladium:suit_stand,type=!palladium:trail_segment,tag=!caster,tag=grabbed] ^ ^0.5 ^8")
            }
        })

        .lastTick((entity, entry, holder, enabled) => {
        const superpower = entry.getPropertyByName("superpower")
        const range = entry.getPropertyByName("range")

            if (enabled) {
                entity.runCommandSilent("superpower remove " + superpower + " @e[distance=0.." + range + ",tag=grabbed]")
                entity.runCommandSilent("tag @e[distance=..15] remove grabbed")
                entity.runCommandSilent("tag @s remove caster")
                console.log(superpower);
            }
        });
});