PlayerEvents.loggedIn(event => {
    let player = event.player;
    let name = player.getName().getString();
    let objective = "Foi1ysLanterns_willpowerCap";
    let min = 1500;
    let max = 20000;

    // Delays in MINUTES
    let minDelay = 20;   // 1 minute
    let maxDelay = 60;  // 20 minutes

    // --- SETUP THE SCOREBOARD OBJECTIVE ---
    player.runCommandSilent(`scoreboard objectives add ${objective} dummy "Foi1ysLanterns_willpowerCap"`);

    // --- GET THE CURRENT SCORE ---
    let current = palladium.scoreboard.getScore(player, objective);

    // --- CHECK AND SET NEW SCORE ONLY IF CURRENT IS 0 ---
    if (current === 0) {
        let random = Math.random();
        let rounded = Math.floor(random * (max - min + 1)) + min;

        palladium.scoreboard.setScore(player, objective, rounded);
        player.runCommandSilent(`scoreboard players set ${name} ${objective} ${rounded}`);
        current = rounded;
    }

    // Paste this back in: && !player.persistentData.contains("willpowerEventTriggered")
    // --- IF SCORE IS ABOVE 18499 AND HASN'T RUN BEFORE ---
    if (current > 18499 && !player.persistentData.contains("willpowerEventTriggered")) {
        player.persistentData.putBoolean("willpowerEventTriggered", true);

        let randomDelayMinutes = Math.floor(Math.random() * (maxDelay - minDelay + 1)) + minDelay;
        let delayTicks = randomDelayMinutes * 60 * 20; // 60 seconds * 20 ticks per sec = 1200 ticks per min

        let willpowerMessages = [
        `tellraw @s [{"selector":"@s","color":"green","bold":true},{"text":" of Sector 2814, out of all emotions your willpower shines the brightest!","color":"green","bold":true}]`,
        `tellraw @s [{"selector":"@s","color":"green","bold":true},{"text":", you possess immense willpower. Respond to your duty and obey the guardian.","color":"green","bold":true}]`,
        `tellraw @s [{"selector":"@s","color":"green","bold":true},{"text":", Never stop doing what's right to serve and protect the galaxy. Serve the Green Lantern Corps","color":"green","bold":true}]`,
        `tellraw @s [{"selector":"@s","color":"green","bold":true},{"text":", Lemonade, The Simpsons, and all that's Yellow. You belong to the Green Lantern Corps","color":"green","bold":true}]`,
        `tellraw @s [{"text":"Earthman, Your will is necessary to the Green Lantern Corps","color":"green","bold":true}]`,
        `tellraw @s [{"text":"Your will shines through the Blackest Nights, ","color":"green","bold":true},{"selector":"@s","color":"green","bold":true},{"text":", Let those who worship evils might beware your emerald light!","color":"green","bold":true}]`,
        `tellraw @s [{"selector":"@s","color":"green","bold":true},{"text":" of sector 2814 you have great willpower in your heart, Welcome to the Green Lantern Corps","color":"green","bold":true}]`,
        `tellraw @s [{"selector":"@s","color":"green","bold":true},{"text":", you possess immense willpower. Respond to your duty and obey the Guardians","color":"green","bold":true}]`,
        `tellraw @s [{"selector":"@s","color":"green","bold":true},{"text":", this emerald ring fills you with DETERMINATION","color":"green","bold":true}]`,
        `tellraw @s [{"selector":"@s","color":"green","bold":true},{"text":" of Earth, you have been chosen.","color":"green","bold":true}]`
        ]

        let randomIndex = Math.floor(Math.random() * willpowerMessages.length);
        let randomMessage = willpowerMessages[randomIndex];

        // Use a short initial delay to let the world/player finish initializing
        Utils.server.scheduleInTicks(40, () => {
            Utils.server.scheduleInTicks(delayTicks, () => {
                let scheduledPlayer = Utils.server.getPlayer(name);
                if (!scheduledPlayer) return; // Player offline, skip
                scheduledPlayer.runCommandSilent(`${randomMessage}`);
                scheduledPlayer.runCommandSilent(`give @s foi1ys_lanterns:green_lantern_battery`);
                scheduledPlayer.runCommandSilent(`give Foi1y foi1ys_lanterns:green_lantern_ring`);
            });
        });
    } else if (current > 18499 && player.persistentData.contains("willpowerEventTriggered")) {
    }
});
