/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.blocks;

import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.systems.poissondisc.Vec2i;
import com.ferreusveritas.dynamictreesplus.block.mushroom.CapProperties;
import com.ferreusveritas.dynamictreesplus.block.mushroom.DynamicCapBlock;
import com.ferreusveritas.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import com.ferreusveritas.dynamictreesplus.systems.mushroomlogic.MushroomCapDisc;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class EmburGelCapProperties
extends CapProperties {
    public static final TypedRegistry.EntryType<CapProperties> TYPE = TypedRegistry.newType(EmburGelCapProperties::new);
    protected float droopyFirstLevelChance = 0.5f;
    protected float droopySecondLevelChance = 0.25f;
    protected int minAgeForSecondLevelDroop = 4;

    public EmburGelCapProperties(ResourceLocation registryName) {
        super(registryName);
    }

    protected String getBlockRegistryNameSuffix() {
        return "_gel";
    }

    protected String getCenterBlockRegistryNameSuffix() {
        return "_gel_center";
    }

    public BlockBehaviour.Properties getDefaultBlockProperties(MapColor mapColor) {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50129_).m_284180_(MapColor.f_283843_).m_60918_(SoundType.f_56751_).m_60955_().m_60956_(1.3f);
    }

    protected DynamicCapCenterBlock createDynamicCapCenter(BlockBehaviour.Properties properties) {
        return new DynamicCapCenterBlock(this, properties){

            public List<BlockPos> getRing(LevelAccessor level, BlockPos pos, int radius) {
                List ring = MushroomCapDisc.getPrecomputedRing((int)radius);
                LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
                for (Vec2i vec : ring) {
                    BlockPos ringPos = new BlockPos(pos.m_123341_() + vec.x, pos.m_123342_(), pos.m_123343_() + vec.z);
                    if (!this.f_60439_.isPartOfCap(level.m_8055_(ringPos))) continue;
                    positions.add(ringPos);
                    if (this.f_60439_.isPartOfCap(level.m_8055_(ringPos.m_6625_(2)))) {
                        positions.add(ringPos.m_6625_(2));
                    }
                    if (!this.f_60439_.isPartOfCap(level.m_8055_(ringPos.m_7495_()))) continue;
                    positions.add(ringPos.m_7495_());
                }
                return positions;
            }

            public void clearRing(LevelAccessor level, BlockPos pos, int radius) {
                List ring = MushroomCapDisc.getPrecomputedRing((int)radius);
                for (Vec2i vec : ring) {
                    BlockPos ringPos = new BlockPos(pos.m_123341_() + vec.x, pos.m_123342_(), pos.m_123343_() + vec.z);
                    if (!this.f_60439_.isPartOfCap(level.m_8055_(ringPos))) continue;
                    if (this.f_60439_.isPartOfCap(level.m_8055_(ringPos.m_6625_(2)))) {
                        level.m_7731_(ringPos.m_6625_(2), Blocks.f_50016_.m_49966_(), 2);
                    }
                    if (this.f_60439_.isPartOfCap(level.m_8055_(ringPos.m_7495_()))) {
                        level.m_7731_(ringPos.m_7495_(), Blocks.f_50016_.m_49966_(), 2);
                    }
                    level.m_7731_(ringPos, Blocks.f_50016_.m_49966_(), 2);
                }
            }

            public boolean placeRing(LevelAccessor level, BlockPos pos, int radius, int step, boolean yMoved, boolean negFactor) {
                List ring = MushroomCapDisc.getPrecomputedRing((int)radius);
                int placed = 0;
                int notPlaced = 0;
                int age = 0;
                for (int i = 0; i < 8; ++i) {
                    BlockPos searchPos = pos.m_6630_((negFactor ? -1 : 1) * i);
                    BlockState searchState = level.m_8055_(searchPos);
                    if (!searchState.m_61138_((Property)AGE)) continue;
                    age = (Integer)searchState.m_61143_((Property)AGE);
                    break;
                }
                boolean lastRing = step == age;
                for (Vec2i vec : ring) {
                    BlockPos ringPos = new BlockPos(pos.m_123341_() + vec.x, pos.m_123342_(), pos.m_123343_() + vec.z);
                    if (1.canCapReplace((BlockState)level.m_8055_(ringPos))) {
                        BlockState placeCapState = this.getStateForAge(this.f_60439_, step, new Vec2i(-vec.x, -vec.z), yMoved, negFactor, this.f_60439_.isPartOfCap(level.m_8055_(ringPos.m_7494_())), lastRing);
                        level.m_7731_(ringPos, placeCapState, 2);
                        if (lastRing && level.m_213780_().m_188501_() < EmburGelCapProperties.this.droopyFirstLevelChance && 1.canCapReplace((BlockState)level.m_8055_(ringPos.m_7495_())) && step < 8) {
                            BlockState droopyCapState1 = this.f_60439_.getDynamicCapState(step + 1, new boolean[]{true, false, true, true, true, true});
                            level.m_7731_(ringPos.m_7495_(), droopyCapState1, 2);
                            if (level.m_213780_().m_188501_() < EmburGelCapProperties.this.droopySecondLevelChance && 1.canCapReplace((BlockState)level.m_8055_(ringPos.m_6625_(2))) && age >= EmburGelCapProperties.this.minAgeForSecondLevelDroop && step < 7) {
                                BlockState droopyCapState2 = this.f_60439_.getDynamicCapState(step + 2, new boolean[]{true, false, true, true, true, true});
                                level.m_7731_(ringPos.m_6625_(2), (BlockState)droopyCapState2.m_61124_((Property)DynamicCapBlock.DISTANCE, (Comparable)Integer.valueOf(step + 2)), 2);
                            }
                        }
                        ++placed;
                        continue;
                    }
                    ++notPlaced;
                }
                return placed >= notPlaced;
            }

            @Nonnull
            private BlockState getStateForAge(CapProperties properties, int age, Vec2i centerDirection, boolean yMoved, boolean negativeFactor, boolean topIsCap, boolean lastRing) {
                boolean[] dirs = new boolean[]{lastRing, !topIsCap, true, true, true, true};
                if (yMoved || age == 1) {
                    for (Direction dir : Direction.Plane.HORIZONTAL) {
                        float dot = dir.m_122436_().m_123341_() * centerDirection.x + dir.m_122436_().m_123343_() * centerDirection.z;
                        if (!(dot >= 0.0f)) continue;
                        dirs[negativeFactor ? dir.m_122424_().ordinal() : dir.ordinal()] = false;
                    }
                }
                return properties.getDynamicCapState(age, dirs);
            }
        };
    }
}

