/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.blocks;

import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.systems.poissondisc.Vec2i;
import com.ferreusveritas.dynamictreesplus.block.mushroom.CapProperties;
import com.ferreusveritas.dynamictreesplus.block.mushroom.DynamicCapBlock;
import com.ferreusveritas.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import com.ferreusveritas.dynamictreesplus.systems.mushroomlogic.MushroomCapDisc;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class WartyCapProperties
extends CapProperties {
    public static final TypedRegistry.EntryType<CapProperties> TYPE = TypedRegistry.newType(WartyCapProperties::new);
    protected Block shroomlightBlock = Blocks.f_50701_;
    protected float extraWartChance = 0.5f;
    protected float shroomlightUpChance = 0.02f;
    protected float shroomlightDownChance = 0.2f;
    protected boolean shroomlightRequireSupport = true;

    public WartyCapProperties(ResourceLocation registryName) {
        super(registryName);
    }

    protected String getBlockRegistryNameSuffix() {
        return "_wart";
    }

    protected String getCenterBlockRegistryNameSuffix() {
        return "_wart_center";
    }

    public void setShroomlightBlock(Block shroomlightBlock) {
        this.shroomlightBlock = shroomlightBlock;
    }

    public Block getShroomlightBlock() {
        return this.shroomlightBlock;
    }

    public void setShroomlightUpChance(float shroomlightUpChance) {
        this.shroomlightUpChance = shroomlightUpChance;
    }

    public void setShroomlightDownChance(float shroomlightDownChance) {
        this.shroomlightDownChance = shroomlightDownChance;
    }

    public void setShroomlightRequireSupport(boolean shroomlightRequireSupport) {
        this.shroomlightRequireSupport = shroomlightRequireSupport;
    }

    public BlockBehaviour.Properties getDefaultBlockProperties(MapColor mapColor) {
        return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283824_).m_60978_(1.0f).m_60918_(SoundType.f_56719_);
    }

    protected DynamicCapBlock createDynamicCap(BlockBehaviour.Properties properties) {
        return new DynamicCapBlock(this, properties){

            public void m_213897_(BlockState pState, ServerLevel level, BlockPos pos, RandomSource pRandom) {
                if (level.m_8055_(pos).m_60734_() == this) {
                    int dist = (Integer)pState.m_61143_((Property)DISTANCE);
                    boolean supportFound = false;
                    for (BlockPos offPos : BlockPos.m_121925_((BlockPos)pos, (int)1, (int)1, (int)1)) {
                        BlockState offsetState;
                        if (offPos == pos || (!(offsetState = level.m_8055_(offPos)).m_61138_((Property)DISTANCE) || (Integer)offsetState.m_61143_((Property)DISTANCE) != dist - 1) && (dist != 1 || offsetState.m_60734_() != this.f_60439_.getDynamicCapCenterBlock().orElse(null))) continue;
                        supportFound = true;
                        break;
                    }
                    if (!supportFound) {
                        level.m_46961_(pos, true);
                        BlockState upState = level.m_8055_(pos.m_7494_());
                        BlockState downState = level.m_8055_(pos.m_7495_());
                        if (upState.m_60713_(WartyCapProperties.this.shroomlightBlock)) {
                            level.m_46961_(pos.m_7494_(), true);
                        }
                        if (downState.m_60713_(WartyCapProperties.this.shroomlightBlock)) {
                            level.m_46961_(pos.m_7495_(), true);
                        }
                        this.updateNeighborsSurround((Level)level, pos, DynamicCapBlock.class);
                    } else {
                        super.m_213897_(pState, level, pos, pRandom);
                    }
                }
            }
        };
    }

    protected DynamicCapCenterBlock createDynamicCapCenter(BlockBehaviour.Properties properties) {
        return new DynamicCapCenterBlock(this, properties){

            public List<BlockPos> getRing(LevelAccessor level, BlockPos pos, int radius) {
                List ring = MushroomCapDisc.getPrecomputedRing((int)radius);
                LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
                for (Vec2i vec : ring) {
                    BlockPos ringPos = new BlockPos(pos.m_123341_() + vec.x, pos.m_123342_(), pos.m_123343_() + vec.z);
                    if (!this.f_60439_.isPartOfCap(level.m_8055_(ringPos))) continue;
                    positions.add(ringPos);
                    if (this.f_60439_.isPartOfCap(level.m_8055_(ringPos.m_7494_()))) {
                        positions.add(ringPos.m_7494_());
                    }
                    if (!this.f_60439_.isPartOfCap(level.m_8055_(ringPos.m_7495_()))) continue;
                    positions.add(ringPos.m_7495_());
                }
                return positions;
            }

            public void clearRing(LevelAccessor level, BlockPos pos, int radius) {
                List ring = MushroomCapDisc.getPrecomputedRing((int)radius);
                for (Vec2i vec : ring) {
                    BlockPos ringPos = new BlockPos(pos.m_123341_() + vec.x, pos.m_123342_(), pos.m_123343_() + vec.z);
                    if (!this.f_60439_.isPartOfCap(level.m_8055_(ringPos))) continue;
                    BlockState upState = level.m_8055_(ringPos.m_7494_());
                    BlockState downState = level.m_8055_(ringPos.m_7495_());
                    if (this.f_60439_.isPartOfCap(upState) || upState.m_60713_(WartyCapProperties.this.shroomlightBlock)) {
                        level.m_7731_(ringPos.m_7494_(), Blocks.f_50016_.m_49966_(), 2);
                    }
                    if (this.f_60439_.isPartOfCap(downState) || downState.m_60713_(WartyCapProperties.this.shroomlightBlock)) {
                        level.m_7731_(ringPos.m_7495_(), Blocks.f_50016_.m_49966_(), 2);
                    }
                    level.m_7731_(ringPos, Blocks.f_50016_.m_49966_(), 2);
                }
            }

            public boolean placeRing(LevelAccessor level, BlockPos pos, int radius, int step, boolean yMoved, boolean negFactor) {
                List ring = MushroomCapDisc.getPrecomputedRing((int)radius);
                int placed = 0;
                int notPlaced = 0;
                int age = 0;
                for (int i = 0; i < 8; ++i) {
                    BlockPos searchPos = pos.m_6630_((negFactor ? -1 : 1) * i);
                    BlockState searchState = level.m_8055_(searchPos);
                    if (!searchState.m_61138_((Property)AGE)) continue;
                    age = (Integer)searchState.m_61143_((Property)AGE);
                    break;
                }
                boolean lastRing = step == age;
                for (Vec2i vec : ring) {
                    BlockPos ringPos = new BlockPos(pos.m_123341_() + vec.x, pos.m_123342_(), pos.m_123343_() + vec.z);
                    if (2.canCapReplace((BlockState)level.m_8055_(ringPos))) {
                        BlockState placeCapState = this.getStateForAge(this.f_60439_, step, new Vec2i(-vec.x, -vec.z), yMoved, negFactor, this.f_60439_.isPartOfCap(level.m_8055_(ringPos.m_7494_())), lastRing);
                        level.m_7731_(ringPos, placeCapState, 2);
                        if (step <= 8 && step > 1) {
                            this.placeExtraWart(level, ringPos.m_7494_(), placeCapState, true, WartyCapProperties.this.shroomlightUpChance);
                            this.placeExtraWart(level, ringPos.m_7495_(), placeCapState, false, WartyCapProperties.this.shroomlightDownChance);
                        }
                        ++placed;
                        continue;
                    }
                    ++notPlaced;
                }
                return placed >= notPlaced;
            }

            private void placeExtraWart(LevelAccessor level, BlockPos ringPos, BlockState placeCapState, boolean checkAround, float shroomlightChance) {
                if (level.m_213780_().m_188501_() < WartyCapProperties.this.extraWartChance && 2.canCapReplace((BlockState)level.m_8055_(ringPos))) {
                    boolean canPlace;
                    if (!WartyCapProperties.this.shroomlightRequireSupport && level.m_213780_().m_188501_() < shroomlightChance) {
                        level.m_7731_(ringPos, WartyCapProperties.this.shroomlightBlock.m_49966_(), 2);
                        return;
                    }
                    boolean bl = canPlace = !checkAround;
                    if (checkAround) {
                        for (Direction dir : Direction.Plane.HORIZONTAL) {
                            if (!this.f_60439_.isPartOfCap(level.m_8055_(ringPos.m_121955_(dir.m_122436_())))) continue;
                            canPlace = true;
                            break;
                        }
                    }
                    if (canPlace) {
                        BlockState place = placeCapState;
                        if (level.m_213780_().m_188501_() < shroomlightChance) {
                            place = WartyCapProperties.this.shroomlightBlock.m_49966_();
                        }
                        level.m_7731_(ringPos, place, 2);
                    }
                }
            }

            @Nonnull
            private BlockState getStateForAge(CapProperties properties, int age, Vec2i centerDirection, boolean yMoved, boolean negativeFactor, boolean topIsCap, boolean lastRing) {
                boolean[] dirs = new boolean[]{lastRing, !topIsCap, true, true, true, true};
                if (yMoved || age == 1) {
                    for (Direction dir : Direction.Plane.HORIZONTAL) {
                        float dot = dir.m_122436_().m_123341_() * centerDirection.x + dir.m_122436_().m_123343_() * centerDirection.z;
                        if (!(dot >= 0.0f)) continue;
                        dirs[negativeFactor ? dir.m_122424_().ordinal() : dir.ordinal()] = false;
                    }
                }
                return properties.getDynamicCapState(age, dirs);
            }
        };
    }
}

