/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.cancellers;

import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.FeatureCanceller;
import com.ferreusveritas.dynamictrees.util.RandomXOR;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.registries.ForgeRegistries;

public class CactusFeatureCanceller<T extends Block>
extends FeatureCanceller {
    private static final RandomSource PLACEHOLDER_RAND = new RandomXOR();
    private final Class<T> cactusBlockClass;

    public CactusFeatureCanceller(ResourceLocation registryName, Class<T> cactusBlockClass) {
        super(registryName);
        this.cactusBlockClass = cactusBlockClass;
    }

    public boolean shouldCancel(ConfiguredFeature<?, ?> configuredFeature, BiomePropertySelectors.NormalFeatureCancellation featureCancellations) {
        ResourceLocation featureRegistryName = ForgeRegistries.FEATURES.getKey((Object)configuredFeature.f_65377_());
        if (featureRegistryName == null) {
            return false;
        }
        FeatureConfiguration featureConfig = configuredFeature.f_65378_();
        if (featureConfig instanceof RandomPatchConfiguration) {
            RandomPatchConfiguration randomPatchConfiguration = (RandomPatchConfiguration)featureConfig;
            PlacedFeature placedFeature = (PlacedFeature)randomPatchConfiguration.f_191304_().m_203334_();
            featureConfig = ((ConfiguredFeature)placedFeature.f_191775_().m_203334_()).f_65378_();
        }
        if (!(featureConfig instanceof BlockColumnConfiguration)) {
            return featureCancellations.shouldCancelNamespace(featureRegistryName.m_135827_());
        }
        BlockColumnConfiguration blockColumnConfiguration = (BlockColumnConfiguration)featureConfig;
        for (BlockColumnConfiguration.Layer layer : blockColumnConfiguration.f_191207_()) {
            BlockStateProvider stateProvider = layer.f_191235_();
            if (!(stateProvider instanceof SimpleStateProvider) || !this.cactusBlockClass.isInstance(stateProvider.m_213972_(PLACEHOLDER_RAND, BlockPos.f_121853_).m_60734_())) continue;
            return true;
        }
        return false;
    }
}

