/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.cells;

import com.ferreusveritas.dynamictrees.api.cell.Cell;
import com.ferreusveritas.dynamictrees.api.cell.CellKit;
import com.ferreusveritas.dynamictrees.api.cell.CellNull;
import com.ferreusveritas.dynamictrees.api.cell.CellSolver;
import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.cell.AcaciaLeafCell;
import com.ferreusveritas.dynamictrees.cell.CellKits;
import com.ferreusveritas.dynamictrees.cell.ConiferTopBranchCell;
import com.ferreusveritas.dynamictrees.cell.LeafClusters;
import com.ferreusveritas.dynamictrees.cell.NormalCell;
import com.ferreusveritas.dynamictrees.cell.PalmFrondCell;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import maxhyper.dtbwg.DynamicTreesBWG;
import maxhyper.dtbwg.cells.DTBWGLeafClusters;
import maxhyper.dtbwg.cells.cell.AlliumLeafCell;
import maxhyper.dtbwg.cells.cell.BushyBranchCell;
import maxhyper.dtbwg.cells.cell.BushyLeafCell;
import maxhyper.dtbwg.cells.cell.ConiferLeafCell2;
import maxhyper.dtbwg.cells.cell.LamentLeafCell;
import maxhyper.dtbwg.cells.cell.PoplarBranchCell;
import maxhyper.dtbwg.cells.cell.PoplarLeafCell;
import maxhyper.dtbwg.cells.cell.PoplarTopBranchCell;
import maxhyper.dtbwg.cells.cell.RoseLeafCell;
import maxhyper.dtbwg.cells.cell.SparseBranchCell;
import maxhyper.dtbwg.cells.cell.SythianWartCell;
import maxhyper.dtbwg.cells.cell.WillowBranchCell;
import maxhyper.dtbwg.cells.cell.WillowLeafCell;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class DTBWGCellKits {
    public static final CellKit PALM = new CellKit(new ResourceLocation("dtbwg", "palm")){
        private final Cell palmBranch = new Cell(){

            public int getValue() {
                return 5;
            }

            public int getValueFromSide(Direction side) {
                return side == Direction.UP ? this.getValue() : 0;
            }
        };
        private final Cell[] palmFrondCells = new Cell[]{CellNull.NULL_CELL, new PalmFrondCell(1), new PalmFrondCell(2), new PalmFrondCell(3), new PalmFrondCell(4), new PalmFrondCell(5), new PalmFrondCell(6), new PalmFrondCell(7)};
        private final CellKits.BasicSolver palmSolver = new CellKits.BasicSolver(new short[]{1300, 1043, 786, 545});

        public Cell getCellForLeaves(int hydro) {
            return this.palmFrondCells[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            return radius == 3 ? this.palmBranch : CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return LeafClusters.PALM;
        }

        public CellSolver getCellSolver() {
            return this.palmSolver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit SPARSE = new CellKit(new ResourceLocation("dtbwg", "sparse")){
        private final Cell sparseBranch = new SparseBranchCell();
        private final Cell sparseLeaves = new NormalCell(1);
        private final CellSolver solver = new CellKits.BasicSolver(new short[]{529});

        public Cell getCellForLeaves(int hydro) {
            return hydro > 0 ? this.sparseLeaves : CellNull.NULL_CELL;
        }

        public Cell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.sparseBranch : CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBWGLeafClusters.SPARSE;
        }

        public CellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 1;
        }
    };
    public static final CellKit POPLAR = new CellKit(new ResourceLocation("dtbwg", "poplar")){
        private final Cell poplarBranch = new PoplarBranchCell();
        private final Cell poplarTopBranch = new PoplarTopBranchCell();
        private final Cell poplarUpperTrunk = new NormalCell(4);
        private final Cell[] poplarLeaves = new Cell[]{CellNull.NULL_CELL, new PoplarLeafCell(1), new PoplarLeafCell(2), new PoplarLeafCell(3), new PoplarLeafCell(4)};
        private final CellSolver solver = new CellKits.BasicSolver(new short[]{1042, 785, 529});

        public Cell getCellForLeaves(int hydro) {
            return this.poplarLeaves[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            if (meta == 1) {
                return this.poplarTopBranch;
            }
            if (radius == 1) {
                return this.poplarBranch;
            }
            if (radius < 4) {
                return this.poplarUpperTrunk;
            }
            return CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBWGLeafClusters.POPLAR;
        }

        public CellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit SMALL_DECIDUOUS = new CellKit(new ResourceLocation("dtbwg", "small_deciduous")){
        private final Cell sparseBranch = new NormalCell(4);
        private final Cell sparseLeaves = new NormalCell(1);
        private final CellSolver solver = new CellKits.BasicSolver(new short[]{529});

        public Cell getCellForLeaves(int hydro) {
            return hydro > 0 ? this.sparseLeaves : CellNull.NULL_CELL;
        }

        public Cell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.sparseBranch : CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBWGLeafClusters.SPARSE;
        }

        public CellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 1;
        }
    };
    public static final CellKit WILLOW = new CellKit(DynamicTreesBWG.location("willow")){
        private final Cell branch = new WillowBranchCell();
        private final Cell[] willowLeafCells = new Cell[]{CellNull.NULL_CELL, new WillowLeafCell(1), new WillowLeafCell(2), new WillowLeafCell(3), new WillowLeafCell(4), new WillowLeafCell(5), new WillowLeafCell(6), new WillowLeafCell(7)};
        private final CellKits.BasicSolver solver = new CellKits.BasicSolver(new short[]{2071, 1830, 1573, 1812, 1556, 1300, 1043, 786, 529});

        public Cell getCellForLeaves(int distance) {
            return this.willowLeafCells[distance];
        }

        public Cell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.branch : CellNull.NULL_CELL;
        }

        public CellSolver getCellSolver() {
            return this.solver;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBWGLeafClusters.WILLOW;
        }

        public int getDefaultHydration() {
            return 7;
        }
    };
    public static final CellKit ROUND_CONIFER = new CellKit(DynamicTreesBWG.location("round_conifer")){
        private final Cell coniferBranch = new NormalCell(3);
        private final Cell coniferTopBranch = new ConiferTopBranchCell();
        private final Cell[] coniferLeafCells = new Cell[]{CellNull.NULL_CELL, new ConiferLeafCell2(1), new ConiferLeafCell2(2), new ConiferLeafCell2(3), new ConiferLeafCell2(4), new ConiferLeafCell2(5), new ConiferLeafCell2(6), new ConiferLeafCell2(7)};
        private final CellKits.BasicSolver coniferSolver = new CellKits.BasicSolver(new short[]{1300, 1043, 786, 545});

        public Cell getCellForLeaves(int hydro) {
            return this.coniferLeafCells[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            if (meta == 1) {
                return this.coniferTopBranch;
            }
            if (radius == 1) {
                return this.coniferBranch;
            }
            return CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBWGLeafClusters.ROUND_CONIFER;
        }

        public CellSolver getCellSolver() {
            return this.coniferSolver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit BUSHY = new CellKit(DynamicTreesBWG.location("bushy")){
        private final Cell branchCell = new BushyBranchCell();
        private final Cell coniferTopBranch = new ConiferTopBranchCell();
        private final Cell[] coniferLeafCells = new Cell[]{CellNull.NULL_CELL, new BushyLeafCell(1), new BushyLeafCell(2), new BushyLeafCell(3), new BushyLeafCell(4), new BushyLeafCell(5), new BushyLeafCell(6), new BushyLeafCell(7)};
        private final CellKits.BasicSolver solver = new CellKits.BasicSolver(new short[]{1556, 1299, 1059, 802, 1041, 529});

        public Cell getCellForLeaves(int hydro) {
            return this.coniferLeafCells[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            if (meta == 1) {
                return this.coniferTopBranch;
            }
            if (radius == 1) {
                return this.branchCell;
            }
            return CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBWGLeafClusters.BUSHY;
        }

        public CellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit SYTHIAN_FUNGUS = new CellKit(DynamicTreesBWG.location("sythian_fungus")){
        private final Cell sythianBranch = new SythianWartCell(3);
        private final Cell sythianTopBranch = new SythianWartCell(4);
        private final Cell[] sythianLeafCells = new Cell[]{CellNull.NULL_CELL, new SythianWartCell(1), new SythianWartCell(2), new SythianWartCell(3), new SythianWartCell(4), new SythianWartCell(5), new SythianWartCell(6), new SythianWartCell(7)};
        private final CellKits.BasicSolver sythianSolver = new CellKits.BasicSolver(new short[]{1041, 786, 545});

        public Cell getCellForLeaves(int hydro) {
            return this.sythianLeafCells[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            if (meta == 1) {
                return this.sythianTopBranch;
            }
            if (radius == 3) {
                return this.sythianBranch;
            }
            return CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBWGLeafClusters.SYTHIAN_FUNGUS;
        }

        public CellSolver getCellSolver() {
            return this.sythianSolver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit LAMENT = new CellKit(DynamicTreesBWG.location("lament")){
        private final Cell lamentBranch = new Cell(){
            final int[] map = new int[]{0, 2, 4, 4, 4, 4};

            public int getValue() {
                return 5;
            }

            public int getValueFromSide(Direction side) {
                return this.map[side.ordinal()];
            }
        };
        private final Cell[] lamentLeafCells = new Cell[]{CellNull.NULL_CELL, new LamentLeafCell(1), new LamentLeafCell(2), new LamentLeafCell(3), new LamentLeafCell(4), new LamentLeafCell(5), new LamentLeafCell(6), new LamentLeafCell(7)};
        private final CellKits.BasicSolver lamentSolver = new CellKits.BasicSolver(new short[]{1043, 802, 785, 529});

        public Cell getCellForLeaves(int hydro) {
            return this.lamentLeafCells[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.lamentBranch : CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBWGLeafClusters.LAMENT;
        }

        public CellSolver getCellSolver() {
            return this.lamentSolver;
        }

        public int getDefaultHydration() {
            return 3;
        }
    };
    public static final CellKit SKYRIS = new CellKit(DynamicTreesBWG.location("skyris")){
        private final Cell skyrisBranch = new Cell(){
            final int[] map = new int[]{0, 3, 5, 5, 5, 5};

            public int getValue() {
                return 5;
            }

            public int getValueFromSide(Direction side) {
                return this.map[side.ordinal()];
            }
        };
        private final Cell coniferTopBranch = new ConiferTopBranchCell();
        private final Cell[] skyrisLeafCells = new Cell[]{CellNull.NULL_CELL, new AcaciaLeafCell(1), new AcaciaLeafCell(2), new AcaciaLeafCell(3), new AcaciaLeafCell(4), new AcaciaLeafCell(5), new AcaciaLeafCell(6), new AcaciaLeafCell(7)};
        private final CellKits.BasicSolver skyrisSolver = new CellKits.BasicSolver(new short[]{1300, 1059, 1042, 786, 529});

        public Cell getCellForLeaves(int hydro) {
            return this.skyrisLeafCells[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            if (meta == 1) {
                return this.coniferTopBranch;
            }
            return radius == 1 ? this.skyrisBranch : CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return LeafClusters.ACACIA;
        }

        public CellSolver getCellSolver() {
            return this.skyrisSolver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit ALLIUM = new CellKit(DynamicTreesBWG.location("allium")){
        private final Cell alliumBranch = new NormalCell(4);
        private final Cell[] alliumLeafCells = new Cell[]{CellNull.NULL_CELL, new AlliumLeafCell(1), new AlliumLeafCell(2), new AlliumLeafCell(3), new AlliumLeafCell(4), new AlliumLeafCell(5), new AlliumLeafCell(6), new AlliumLeafCell(7)};
        private final CellKits.BasicSolver alliumSolver = new CellKits.BasicSolver(new short[]{1043, 802, 785, 529});

        public Cell getCellForLeaves(int hydro) {
            return this.alliumLeafCells[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            return radius == 3 ? this.alliumBranch : CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBWGLeafClusters.ALLIUM;
        }

        public CellSolver getCellSolver() {
            return this.alliumSolver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit ROSE = new CellKit(DynamicTreesBWG.location("rose")){
        private final Cell roseBranch = new Cell(){
            final int[] map = new int[]{0, 3, 8, 8, 8, 8};

            public int getValue() {
                return 8;
            }

            public int getValueFromSide(Direction side) {
                return this.map[side.ordinal()];
            }
        };
        private final Cell[] roseLeafCells = new Cell[]{CellNull.NULL_CELL, new RoseLeafCell(1), new RoseLeafCell(2), new RoseLeafCell(3), new RoseLeafCell(4), new RoseLeafCell(5), new RoseLeafCell(6), new RoseLeafCell(7)};
        private final CellKits.BasicSolver roseSolver = new CellKits.BasicSolver(new short[]{2071, 1830, 1813, 1300, 1555, 785, 1042, 529});

        public Cell getCellForLeaves(int hydro) {
            return this.roseLeafCells[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            return radius == 3 ? this.roseBranch : CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTBWGLeafClusters.ROSE;
        }

        public CellSolver getCellSolver() {
            return this.roseSolver;
        }

        public int getDefaultHydration() {
            return 7;
        }
    };

    public static void register(Registry<CellKit> registry) {
        registry.registerAll((RegistryEntry[])new CellKit[]{PALM, SPARSE, POPLAR, SMALL_DECIDUOUS, WILLOW, ROUND_CONIFER, SYTHIAN_FUNGUS, LAMENT, SKYRIS, ALLIUM, ROSE});
    }
}

