/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.branch.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.mojang.datafixers.util.Pair;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BranchSproutsGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> SPROUT_BLOCK = ConfigurationProperty.property((String)"sprout_block", Block.class);
    public static final ConfigurationProperty<Integer> MIN_RADIUS = ConfigurationProperty.integer((String)"min_radius");
    public static final ConfigurationProperty<Integer> MAX_RADIUS = ConfigurationProperty.integer((String)"max_radius");

    public BranchSproutsGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{SPROUT_BLOCK, FRUITING_RADIUS, PLACE_CHANCE, MAX_COUNT, MIN_RADIUS, MAX_RADIUS});
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(SPROUT_BLOCK, (Object)Blocks.f_50016_)).with(FRUITING_RADIUS, (Object)8)).with(PLACE_CHANCE, (Object)Float.valueOf(0.05f))).with(MAX_COUNT, (Object)16)).with(MIN_RADIUS, (Object)8)).with(MAX_RADIUS, (Object)12);
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        BlockPos rootPos;
        LevelAccessor world = context.level();
        BlockState blockState = world.m_8055_((rootPos = context.pos()).m_7494_());
        BranchBlock branch = TreeHelper.getBranch((BlockState)blockState);
        if (branch != null && branch.getRadius(blockState) >= (Integer)configuration.get(MIN_RADIUS)) {
            int count = 1 + world.m_213780_().m_188503_(((Integer)configuration.get(MAX_COUNT)).intValue());
            this.placeSprouts(count, configuration, world, rootPos);
        }
        return true;
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        BlockPos rootPos;
        if (context.fertility() == 0) {
            return false;
        }
        LevelAccessor world = context.level();
        BlockState blockState = world.m_8055_((rootPos = context.pos()).m_7494_());
        BranchBlock branch = TreeHelper.getBranch((BlockState)blockState);
        if (branch != null && branch.getRadius(blockState) >= (Integer)configuration.get(MIN_RADIUS) && context.natural() && world.m_213780_().m_188501_() < ((Float)configuration.get(PLACE_CHANCE)).floatValue()) {
            this.placeSprouts(1, configuration, world, rootPos);
        }
        return true;
    }

    private void placeSprouts(int count, GenFeatureConfiguration configuration, LevelAccessor world, BlockPos rootPos) {
        LinkedList<Pair<BlockPos, Direction>> validSpots = new LinkedList<Pair<BlockPos, Direction>>();
        FindSidedBlockNode sproutPlacer = new FindSidedBlockNode(validSpots, (Integer)configuration.get(MIN_RADIUS), (Integer)configuration.get(MAX_RADIUS));
        TreeHelper.startAnalysisFromRoot((LevelAccessor)world, (BlockPos)rootPos, (MapSignal)new MapSignal(new NodeInspector[]{sproutPlacer}));
        if (!validSpots.isEmpty()) {
            for (int i = 0; i < count; ++i) {
                Pair selection = (Pair)validSpots.get(world.m_213780_().m_188503_(validSpots.size()));
                BlockPos pos = (BlockPos)selection.getFirst();
                Block block = (Block)configuration.get(SPROUT_BLOCK);
                if (world.m_8055_(pos.m_7495_()).m_60734_() == block) {
                    return;
                }
                world.m_7731_(pos, (BlockState)block.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)((Direction)selection.getSecond())), 3);
            }
        }
    }

    public static class FindSidedBlockNode
    implements NodeInspector {
        private final List<Pair<BlockPos, Direction>> validSpots;
        private final int minRadius;
        private final int maxRadius;

        public FindSidedBlockNode(List<Pair<BlockPos, Direction>> spots, int minRadius, int maxRadius) {
            this.validSpots = spots;
            this.minRadius = minRadius;
            this.maxRadius = maxRadius;
        }

        public boolean run(BlockState blockState, LevelAccessor world, BlockPos pos, Direction fromDir) {
            int radius = TreeHelper.getRadius((BlockGetter)world, (BlockPos)pos);
            if (TreeHelper.isBranch((BlockState)blockState) && radius >= this.minRadius && radius <= this.maxRadius) {
                boolean found = false;
                for (Direction dir : CoordUtils.HORIZONTALS) {
                    BlockPos offsetPos = pos.m_121955_(dir.m_122436_());
                    BlockState offsetState = world.m_8055_(offsetPos);
                    if (!offsetState.m_60795_() && !(offsetState.m_60734_() instanceof TrunkShellBlock)) continue;
                    for (int i = 0; i < radius; ++i) {
                        this.validSpots.add((Pair<BlockPos, Direction>)new Pair((Object)offsetPos, (Object)dir));
                    }
                    found = true;
                }
                return found;
            }
            return false;
        }

        public boolean returnRun(BlockState blockState, LevelAccessor world, BlockPos pos, Direction fromDir) {
            return false;
        }
    }
}

