/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.systems.nodemapper.FindEndsNode;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class LushVinesGenFeature
extends GenFeature {
    protected final BooleanProperty[] sideVineStates = new BooleanProperty[]{null, null, VineBlock.f_57834_, VineBlock.f_57836_, VineBlock.f_57837_, VineBlock.f_57835_};
    public static final ConfigurationProperty<Integer> MAX_LENGTH = ConfigurationProperty.integer((String)"max_length");
    public static final ConfigurationProperty<Block> BLOCK = ConfigurationProperty.block((String)"block");
    public static final ConfigurationProperty<Block> TIP_BLOCK = ConfigurationProperty.block((String)"tip_block");
    public static final ConfigurationProperty<Integer> BERRIES_CHANCE = ConfigurationProperty.integer((String)"berries_chance");
    public static final BooleanProperty BERRIES = BooleanProperty.m_61465_((String)"berries");

    public LushVinesGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{QUANTITY, MAX_LENGTH, VERTICAL_SPREAD, RAY_DISTANCE, BLOCK, TIP_BLOCK, BERRIES_CHANCE, FRUITING_RADIUS});
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(QUANTITY, (Object)4)).with(MAX_LENGTH, (Object)8)).with(VERTICAL_SPREAD, (Object)Float.valueOf(60.0f))).with(RAY_DISTANCE, (Object)Float.valueOf(5.0f))).with(BLOCK, (Object)Blocks.f_50191_)).with(TIP_BLOCK, null)).with(BERRIES_CHANCE, (Object)0)).with(FRUITING_RADIUS, (Object)-1);
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (!context.isWorldGen() || context.endPoints().isEmpty()) {
            return false;
        }
        int quantity = (Integer)configuration.get(QUANTITY);
        for (int i = 0; i < quantity; ++i) {
            BlockPos endPoint = (BlockPos)context.endPoints().get(context.random().m_188503_(context.endPoints().size()));
            this.addVerticalVines(configuration, context.level(), context.species(), context.pos(), endPoint, context.bounds(), true);
        }
        return true;
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        LevelAccessor level = context.level();
        BlockPos rootPos = context.pos();
        Species species = context.species();
        int fruitingRadius = (Integer)configuration.get(FRUITING_RADIUS);
        if (fruitingRadius < 0 || context.fertility() < 1) {
            return false;
        }
        BlockState blockState = level.m_8055_(context.treePos());
        BranchBlock branch = TreeHelper.getBranch((BlockState)blockState);
        if (branch != null && branch.getRadius(blockState) >= fruitingRadius && context.natural() && species.seasonalFruitProductionFactor(context.levelContext(), rootPos) > level.m_213780_().m_188501_()) {
            FindEndsNode endFinder = new FindEndsNode();
            TreeHelper.startAnalysisFromRoot((LevelAccessor)level, (BlockPos)rootPos, (MapSignal)new MapSignal(new NodeInspector[]{endFinder}));
            List endPoints = endFinder.getEnds();
            int qty = (Integer)configuration.get(QUANTITY);
            if (!endPoints.isEmpty()) {
                for (int i = 0; i < qty; ++i) {
                    BlockPos endPoint = (BlockPos)endPoints.get(level.m_213780_().m_188503_(endPoints.size()));
                    this.addVerticalVines(configuration, level, species, rootPos, endPoint, SafeChunkBounds.ANY, false);
                }
                return true;
            }
        }
        return true;
    }

    protected void addVerticalVines(GenFeatureConfiguration configuration, LevelAccessor level, Species species, BlockPos rootPos, BlockPos branchPos, SafeChunkBounds safeBounds, boolean worldgen) {
        BlockPos vinePos = CoordUtils.getRayTraceFruitPos((LevelAccessor)level, (Species)species, (BlockPos)rootPos, (BlockPos)branchPos, (SafeChunkBounds)safeBounds);
        if (!safeBounds.inBounds(vinePos, true) || vinePos == BlockPos.f_121853_) {
            return;
        }
        this.placeVines(level, vinePos, ((Block)configuration.get(BLOCK)).m_49966_(), (Integer)configuration.get(MAX_LENGTH), configuration.getAsOptional(TIP_BLOCK).map(Block::m_49966_).orElse(null), worldgen, configuration);
    }

    protected void placeVines(LevelAccessor level, BlockPos vinePos, BlockState vinesState, int maxLength, @Nullable BlockState tipState, boolean worldGen, GenFeatureConfiguration configuration) {
        int len = worldGen ? Mth.m_14045_((int)(level.m_213780_().m_188503_(maxLength) + 3), (int)3, (int)maxLength) : 1;
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(vinePos.m_123341_(), vinePos.m_123342_(), vinePos.m_123343_());
        int berriesChance = (Integer)configuration.get(BERRIES_CHANCE);
        tipState = tipState == null ? vinesState : tipState;
        for (int i = 0; i < len; ++i) {
            BlockState currentState;
            if (level.m_46859_((BlockPos)mPos)) {
                boolean hasBerries = level.m_213780_().m_188503_(10) < berriesChance;
                BlockState blockState = currentState = i == len - 1 ? tipState : vinesState;
                if (hasBerries && currentState.m_61138_((Property)BERRIES)) {
                    currentState = (BlockState)currentState.m_61124_((Property)BERRIES, (Comparable)Boolean.valueOf(true));
                }
            } else {
                if (i <= 0) break;
                mPos.m_142448_(mPos.m_123342_() + 1);
                level.m_7731_((BlockPos)mPos, tipState, 3);
                break;
            }
            level.m_7731_((BlockPos)mPos, currentState, 3);
            mPos.m_142448_(mPos.m_123342_() - 1);
        }
    }
}

