/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.nodemapper.FindEndsNode;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import com.ferreusveritas.dynamictreesplus.systems.mushroomlogic.context.MushroomCapContext;
import com.ferreusveritas.dynamictreesplus.tree.HugeMushroomSpecies;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MushroomVinesGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Float> VINE_PLACE_CHANCE = ConfigurationProperty.floatProperty((String)"vine_place_chance");
    public static final ConfigurationProperty<Integer> MAX_LENGTH = ConfigurationProperty.integer((String)"max_length");
    public static final ConfigurationProperty<Block> BLOCK = ConfigurationProperty.block((String)"block");
    public static final ConfigurationProperty<Block> TIP_BLOCK = ConfigurationProperty.block((String)"tip_block");

    public MushroomVinesGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{VINE_PLACE_CHANCE, MAX_LENGTH, BLOCK, TIP_BLOCK});
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(VINE_PLACE_CHANCE, (Object)Float.valueOf(0.05f))).with(MAX_LENGTH, (Object)8)).with(BLOCK, (Object)Blocks.f_50703_)).with(TIP_BLOCK, (Object)Blocks.f_50702_);
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        Species species = context.species();
        if (species instanceof HugeMushroomSpecies) {
            HugeMushroomSpecies mushroomSpecies = (HugeMushroomSpecies)species;
            LevelAccessor level = context.level();
            BlockPos rootPos = context.pos();
            FindEndsNode endFinder = new FindEndsNode();
            TreeHelper.startAnalysisFromRoot((LevelAccessor)level, (BlockPos)rootPos, (MapSignal)new MapSignal(new NodeInspector[]{endFinder}));
            List endPoints = endFinder.getEnds();
            for (BlockPos endPoint : endPoints) {
                if (endPoint.equals((Object)BlockPos.f_121853_) || !(level.m_8055_(endPoint.m_7494_()).m_60734_() instanceof DynamicCapCenterBlock)) continue;
                int age = (Integer)level.m_8055_(endPoint.m_7494_()).m_61143_((Property)DynamicCapCenterBlock.AGE);
                for (BlockPos findPos : mushroomSpecies.getMushroomShapeKit().getShapeCluster(new MushroomCapContext(level, endPoint.m_7494_(), mushroomSpecies, Integer.valueOf(age)))) {
                    if (!(level.m_213780_().m_188501_() < ((Float)configuration.get(VINE_PLACE_CHANCE)).floatValue()) || !level.m_8055_(findPos.m_7495_()).m_60795_()) continue;
                    BlockPos vinePos = findPos.m_7495_();
                    this.placeVines(level, vinePos, ((Block)configuration.get(BLOCK)).m_49966_(), (Integer)configuration.get(MAX_LENGTH), configuration.getAsOptional(TIP_BLOCK).map(block -> (BlockState)block.m_49966_().m_61124_((Property)GrowingPlantHeadBlock.f_53924_, (Comparable)Integer.valueOf(context.isWorldGen() ? 25 : 0))).orElse(null), context.isWorldGen());
                }
            }
            return true;
        }
        return false;
    }

    protected void placeVines(LevelAccessor level, BlockPos vinePos, BlockState vinesState, int maxLength, @Nullable BlockState tipState, boolean worldGen) {
        int len = worldGen ? Mth.m_14045_((int)(level.m_213780_().m_188503_(maxLength) + 3), (int)3, (int)maxLength) : 1;
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(vinePos.m_123341_(), vinePos.m_123342_(), vinePos.m_123343_());
        tipState = tipState == null ? vinesState : tipState;
        for (int i = 0; i < len; ++i) {
            if (!level.m_46859_((BlockPos)mPos)) {
                if (i <= 0) break;
                mPos.m_142448_(mPos.m_123342_() + 1);
                level.m_7731_((BlockPos)mPos, tipState, 3);
                break;
            }
            level.m_7731_((BlockPos)mPos, i == len - 1 ? tipState : vinesState, 3);
            mPos.m_142448_(mPos.m_123342_() + -1);
        }
    }
}

