/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.growthlogic;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import maxhyper.dtbwg.growthlogic.VariateHeightLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class AncientLogic
extends VariateHeightLogic {
    public static final ConfigurationProperty<Float> CANOPY_ENERGY = ConfigurationProperty.floatProperty((String)"canopy_energy");

    public AncientLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(CANOPY_ENERGY, (Object)Float.valueOf(8.0f))).with(HEIGHT_VARIATION, (Object)5)).with(LOWEST_BRANCH_VARIATION, (Object)3);
    }

    @Override
    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{CANOPY_ENERGY, HEIGHT_VARIATION, LOWEST_BRANCH_VARIATION});
    }

    private void branchTwisting(Level world, BlockPos pos, GrowSignal signal, int[] probMap) {
        boolean allowUp = signal.numTurns != 1 || signal.delta.m_123331_(new Vec3i(0, signal.delta.m_123342_(), 0)) != 1.0;
        boolean found = false;
        for (Direction dir : Direction.values()) {
            if (dir == signal.dir.m_122424_() || !allowUp && dir == Direction.UP || !TreeHelper.isBranch((BlockState)world.m_8055_(pos.m_121955_(dir.m_122436_())))) continue;
            probMap[dir.ordinal()] = 1;
            found = true;
        }
        if (!found) {
            if (allowUp) {
                probMap[1] = 1;
            }
            probMap[5] = 1;
            probMap[4] = 1;
            probMap[3] = 1;
            probMap[2] = 1;
        }
    }

    private void darkOakCanopy(GrowSignal signal, int[] probMap) {
        probMap[Direction.UP.m_122411_()] = 4;
        if (!signal.isInTrunk()) {
            probMap[Direction.UP.m_122411_()] = 0;
            probMap[Direction.DOWN.m_122411_()] = 0;
            int n = signal.dir.ordinal();
            probMap[n] = (int)((double)probMap[n] * 0.35);
        }
        float spreadPush = 1.5f;
        for (Direction dir : CoordUtils.HORIZONTALS) {
            int n = dir.ordinal();
            probMap[n] = (int)((float)probMap[n] * spreadPush);
        }
        if (signal.numTurns == 1 && signal.delta.m_123331_(new Vec3i(0, signal.delta.m_123342_(), 0)) == 1.0) {
            for (Direction dir : CoordUtils.HORIZONTALS) {
                if (signal.dir == dir) continue;
                probMap[dir.ordinal()] = 0;
            }
        }
        if (signal.isInTrunk()) {
            for (Direction dir : CoordUtils.HORIZONTALS) {
                if (probMap[dir.ordinal()] < 7) continue;
                probMap[dir.ordinal()] = 2;
            }
        }
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        GrowSignal signal = context.signal();
        int[] probMap = context.probMap();
        Level world = context.level();
        BlockPos pos = context.pos();
        Species species = context.species();
        Direction originDir = signal.dir.m_122424_();
        int treeHash = CoordUtils.coordHashCode((BlockPos)signal.rootPos, (int)2);
        probMap[0] = 0;
        if (signal.energy > ((Float)configuration.get(CANOPY_ENERGY)).floatValue()) {
            probMap[1] = species.getUpProbability();
            probMap[5] = 0;
            probMap[4] = 0;
            probMap[3] = 0;
            probMap[2] = 0;
            if (signal.isInTrunk()) {
                if (signal.delta.m_123342_() <= configuration.getLowestBranchHeight((PositionalSpeciesContext)context) + 1) {
                    int sideHash = treeHash % 16;
                    probMap[2] = sideHash % 2 < 1 ? 1 : 0;
                    probMap[3] = sideHash % 4 < 2 ? 1 : 0;
                    probMap[4] = sideHash % 8 < 4 ? 1 : 0;
                    probMap[5] = sideHash < 8 ? 1 : 0;
                }
            } else {
                this.branchTwisting(world, pos, signal, probMap);
            }
        } else {
            this.darkOakCanopy(signal, probMap);
        }
        probMap[originDir.ordinal()] = 0;
        return probMap;
    }

    public Direction selectNewDirection(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context) {
        Direction newDir = super.selectNewDirection(configuration, context);
        GrowSignal signal = context.signal();
        if (signal.isInTrunk() && newDir != Direction.UP) {
            signal.energy = Math.min(signal.energy, ((Float)configuration.get(CANOPY_ENERGY)).floatValue() + 3.5f);
        }
        return newDir;
    }

    @Override
    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return super.getLowestBranchHeight(configuration, context) + AncientLogic.getHashedVariation((LevelAccessor)context.level(), context.pos(), (Integer)configuration.get(LOWEST_BRANCH_VARIATION));
    }
}

