/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.growthlogic;

import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import maxhyper.dtbwg.growthlogic.VariateHeightLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;

public class AspenLogic
extends VariateHeightLogic {
    public AspenLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(HEIGHT_VARIATION, (Object)3);
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        GrowSignal signal = context.signal();
        int[] probMap = context.probMap();
        int radius = context.radius();
        Direction originDir = signal.dir.m_122424_();
        probMap[0] = signal.isInTrunk() ? 0 : 1;
        probMap[1] = signal.isInTrunk() ? 4 : 1;
        probMap[5] = 0;
        probMap[4] = 0;
        probMap[3] = 0;
        probMap[2] = 0;
        if (signal.isInTrunk()) {
            if (radius > 1) {
                int directionSelection = Math.abs(CoordUtils.coordHashCode((BlockPos)context.pos(), (int)2)) % 4;
                probMap[2 + directionSelection] = signal.numSteps % 2 == 0 ? 3 : 0;
            }
        } else {
            if (radius < 3) {
                probMap[0] = 0;
                probMap[1] = 0;
            }
            int n = signal.dir.ordinal();
            probMap[n] = probMap[n] + (signal.numTurns == 1 ? 2 : 1);
        }
        probMap[originDir.ordinal()] = 0;
        return probMap;
    }

    public Direction selectNewDirection(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context) {
        GrowSignal signal = context.signal();
        Direction newDir = super.selectNewDirection(configuration, context);
        if (signal.isInTrunk() && newDir != Direction.UP) {
            float energyAddition = (float)(CoordUtils.coordHashCode((BlockPos)signal.rootPos.m_121955_((Vec3i)signal.delta), (int)1) % 1000) / 1000.0f * 2.0f;
            signal.energy = 1.0f + energyAddition;
        }
        return newDir;
    }
}

