/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.growthlogic;

import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.PalmGrowthLogic;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class DiagonalPalmLogic
extends PalmGrowthLogic {
    public static final ConfigurationProperty<Float> CHANCE_TO_DIVERGE = ConfigurationProperty.floatProperty((String)"chance_to_diverge");
    public static final ConfigurationProperty<Float> CHANCE_TO_SPLIT = ConfigurationProperty.floatProperty((String)"chance_to_split");
    public static final ConfigurationProperty<Float> SPLIT_MAX_ENERGY_FACTOR = ConfigurationProperty.floatProperty((String)"split_max_energy_factor");

    public DiagonalPalmLogic(ResourceLocation registryName) {
        super(registryName);
    }

    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(CHANCE_TO_DIVERGE, (Object)Float.valueOf(0.8f))).with(CHANCE_TO_SPLIT, (Object)Float.valueOf(0.06f))).with(SPLIT_MAX_ENERGY_FACTOR, (Object)Float.valueOf(0.5f));
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{CHANCE_TO_DIVERGE, CHANCE_TO_SPLIT, SPLIT_MAX_ENERGY_FACTOR});
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        Species species = context.species();
        Level world = context.level();
        GrowSignal signal = context.signal();
        int[] probMap = context.probMap();
        BlockPos pos = context.pos();
        Direction originDir = signal.dir.m_122424_();
        probMap[0] = 0;
        probMap[1] = species.getUpProbability();
        probMap[5] = 0;
        probMap[4] = 0;
        probMap[3] = 0;
        probMap[2] = 0;
        int diverge = (int)(4.0f / ((Float)configuration.get(CHANCE_TO_DIVERGE)).floatValue());
        int split = (int)(1.0f / ((Float)configuration.get(CHANCE_TO_SPLIT)).floatValue());
        int randCoordCode = Math.abs(CoordUtils.coordHashCode((BlockPos)pos, (int)2));
        int directionSelection = randCoordCode % diverge;
        int splitSelection = randCoordCode % split;
        if (directionSelection < 4 && signal.energy > 1.0f) {
            Direction selectedDir = Direction.values()[2 + directionSelection];
            if (originDir == Direction.DOWN) {
                probMap[selectedDir.ordinal()] = 10;
                if (splitSelection == 0 && signal.energy > species.getEnergy(world, signal.rootPos) * Math.max(0.0f, Math.min(1.0f, 1.0f - ((Float)configuration.get(SPLIT_MAX_ENERGY_FACTOR)).floatValue()))) {
                    probMap[selectedDir.m_122427_().ordinal()] = 10;
                }
                probMap[1] = 0;
            }
        }
        probMap[originDir.ordinal()] = 0;
        return probMap;
    }
}

