/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.growthlogic;

import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import maxhyper.dtbwg.growthlogic.TwistingTreeLogic;
import maxhyper.dtbwg.growthlogic.VariateHeightLogic;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;

public class EnchantedTreeLogic
extends TwistingTreeLogic {
    public static final ConfigurationProperty<Integer> FORCE_BRANCHING_AT_STEP = ConfigurationProperty.integer((String)"force_branching_at_step");
    public static final ConfigurationProperty<Integer> FORCE_BRANCHING_AT_STEP_VARIATION = ConfigurationProperty.integer((String)"force_branching_at_step_variation");

    public EnchantedTreeLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(FORCE_BRANCHING_AT_STEP, (Object)10)).with(FORCE_BRANCHING_AT_STEP_VARIATION, (Object)1);
    }

    @Override
    protected void registerProperties() {
        super.registerProperties();
        this.register(new ConfigurationProperty[]{FORCE_BRANCHING_AT_STEP, FORCE_BRANCHING_AT_STEP_VARIATION});
    }

    @Override
    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        GrowSignal signal = context.signal();
        int[] probMap = context.probMap();
        int branchOutStep = (Integer)configuration.get(FORCE_BRANCHING_AT_STEP) + VariateHeightLogic.getHashedVariation((LevelAccessor)context.level(), context.signal().rootPos, (Integer)configuration.get(HEIGHT_VARIATION));
        int branchOutVar = (Integer)configuration.get(FORCE_BRANCHING_AT_STEP_VARIATION);
        if (signal.numSteps >= branchOutStep && signal.numSteps <= branchOutStep + branchOutVar) {
            probMap[0] = (Integer)configuration.get(DOWN_PROBABILITY);
            probMap[1] = signal.numSteps == branchOutStep ? 0 : context.species().getUpProbability();
            probMap[5] = 1;
            probMap[4] = 1;
            probMap[3] = 1;
            probMap[2] = 1;
            probMap[signal.dir.m_122424_().ordinal()] = 0;
            return probMap;
        }
        return super.populateDirectionProbabilityMap(configuration, context);
    }

    @Override
    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return super.getLowestBranchHeight(configuration, context);
    }
}

