/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.growthlogic;

import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class MangroveLogic
extends GrowthLogicKit {
    public MangroveLogic(ResourceLocation registryName) {
        super(registryName);
    }

    public Direction selectNewDirection(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context) {
        GrowSignal signal = context.signal();
        Direction newDir = super.selectNewDirection(configuration, context);
        if (newDir != Direction.UP) {
            signal.energy += 0.75f;
        }
        if (newDir == Direction.UP && signal.dir != Direction.UP) {
            signal.energy += ((float)Math.max(Math.abs(signal.delta.m_123341_()), Math.abs(signal.delta.m_123343_())) - 2.0f) * 1.5f;
        }
        return newDir;
    }

    private float getHashedVariation(Level world, BlockPos pos, int mod) {
        long day = world.m_46467_() / 24000L;
        int month = (int)day / 30;
        return CoordUtils.coordHashCode((BlockPos)pos.m_6630_(month), (int)2) % mod;
    }

    public float getEnergy(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return context.species().getSignalEnergy() + (float)this.getLowestBranchHeight(configuration, context) * (1.5f + this.getHashedVariation(context.level(), context.pos(), 10) / 20.0f);
    }

    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return (int)((float)context.species().getLowestBranchHeight() + this.getHashedVariation(context.level(), context.pos(), 9));
    }
}

