/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.growthlogic;

import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import maxhyper.dtbwg.growthlogic.VariateHeightLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class MapleLogic
extends VariateHeightLogic {
    public static final ConfigurationProperty<Boolean> FORCE_UP_AFTER_BRANCHING = ConfigurationProperty.bool((String)"force_up_after_branching");
    public static final ConfigurationProperty<Integer> CANOPY_DEPTH = ConfigurationProperty.integer((String)"canopy_depth");
    public static final ConfigurationProperty<Integer> BRANCHING_HEIGHT = ConfigurationProperty.integer((String)"branching_height");
    public static final ConfigurationProperty<Integer> ZIGZAG_UP_CHANCE = ConfigurationProperty.integer((String)"zigzag_up_chance");

    public MapleLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(FORCE_UP_AFTER_BRANCHING, (Object)true)).with(HEIGHT_VARIATION, (Object)4)).with(CANOPY_DEPTH, (Object)3)).with(BRANCHING_HEIGHT, (Object)3)).with(ZIGZAG_UP_CHANCE, (Object)5);
    }

    @Override
    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{FORCE_UP_AFTER_BRANCHING, HEIGHT_VARIATION, CANOPY_DEPTH, BRANCHING_HEIGHT, ZIGZAG_UP_CHANCE});
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        GrowSignal signal = context.signal();
        int[] probMap = context.probMap();
        int lowestBranch = configuration.getLowestBranchHeight((PositionalSpeciesContext)context);
        int deltaYFromLowest = signal.delta.m_123342_() - lowestBranch;
        int branchingHeight = (Integer)configuration.get(BRANCHING_HEIGHT);
        probMap[0] = 0;
        if (!signal.isInTrunk() && deltaYFromLowest >= 0 && deltaYFromLowest <= branchingHeight) {
            boolean goUp = CoordUtils.coordHashCode((BlockPos)context.pos(), (int)2) % (Integer)configuration.get(ZIGZAG_UP_CHANCE) == 0 || signal.energy % 2.0f == 0.0f && (Boolean)configuration.get(FORCE_UP_AFTER_BRANCHING) != false;
            probMap[1] = goUp ? 1 : 0;
            probMap[5] = goUp ? 0 : 1;
            probMap[4] = probMap[5];
            probMap[3] = probMap[5];
            probMap[2] = probMap[5];
        } else {
            probMap[1] = signal.isInTrunk() && deltaYFromLowest >= 0 || deltaYFromLowest >= branchingHeight + (Integer)configuration.get(CANOPY_DEPTH) ? 0 : context.species().getUpProbability();
            probMap[5] = 3;
            probMap[4] = 3;
            probMap[3] = 3;
            probMap[2] = 3;
            if (!signal.isInTrunk() && signal.dir != Direction.UP) {
                int increase = signal.numTurns > 2 ? 0 : 2;
                int n = signal.dir.ordinal();
                probMap[n] = probMap[n] + increase;
            }
        }
        Direction originDir = signal.dir.m_122424_();
        probMap[originDir.ordinal()] = 0;
        return probMap;
    }
}

