/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.growthlogic;

import com.ferreusveritas.dynamictrees.growthlogic.ConiferLogic;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class SmallRedwoodLogic
extends ConiferLogic {
    public SmallRedwoodLogic(ResourceLocation registryName) {
        super(registryName);
    }

    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(HEIGHT_VARIATION, (Object)6);
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        Species species = context.species();
        GrowSignal signal = context.signal();
        int[] probMap = context.probMap();
        Direction originDir = signal.dir.m_122424_();
        int treeHash = CoordUtils.coordHashCode((BlockPos)signal.rootPos, (int)2);
        probMap[0] = 0;
        probMap[1] = signal.isInTrunk() ? species.getUpProbability() : 0;
        int canopyHeight = species.getLowestBranchHeight() + 4;
        if (signal.delta.m_123342_() == species.getLowestBranchHeight()) {
            int sideHash = treeHash % 16;
            probMap[2] = sideHash % 2 < 1 ? 1 : 0;
            probMap[3] = sideHash % 4 < 2 ? 1 : 0;
            probMap[4] = sideHash % 8 < 4 ? 1 : 0;
            probMap[5] = sideHash < 8 ? 1 : 0;
        } else if (signal.delta.m_123342_() < canopyHeight) {
            probMap[5] = 0;
            probMap[4] = 0;
            probMap[3] = 0;
            probMap[2] = 0;
        } else {
            probMap[5] = !signal.isInTrunk() || signal.isInTrunk() && signal.numSteps % 2 == 1 && context.radius() > 1 ? 2 : 0;
            probMap[4] = probMap[5];
            probMap[3] = probMap[5];
            probMap[2] = probMap[5];
        }
        probMap[originDir.ordinal()] = 0;
        int n = signal.dir.ordinal();
        probMap[n] = probMap[n] + (signal.isInTrunk() ? 0 : (signal.numTurns == 1 ? 2 : 1));
        return probMap;
    }

    public Direction selectNewDirection(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context) {
        GrowSignal signal = context.signal();
        Direction newDir = super.selectNewDirection(configuration, context);
        if (signal.isInTrunk() && newDir != Direction.UP && signal.delta.m_123342_() < configuration.getLowestBranchHeight((PositionalSpeciesContext)context) + 3) {
            signal.energy = 2.0f;
        }
        return newDir;
    }
}

