/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtbwg.growthlogic;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import java.util.function.BiConsumer;
import maxhyper.dtbwg.growthlogic.VariateHeightLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class TwistingTreeLogic
extends VariateHeightLogic {
    public static final ConfigurationProperty<Float> CHANCE_TO_SPLIT = ConfigurationProperty.floatProperty((String)"chance_to_split");
    public static final ConfigurationProperty<Integer> DOWN_PROBABILITY = ConfigurationProperty.integer((String)"down_probability");
    public static final ConfigurationProperty<Boolean> SPLIT_ENDS = ConfigurationProperty.bool((String)"split_ends");

    public TwistingTreeLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(CHANCE_TO_SPLIT, (Object)Float.valueOf(0.01f))).with(DOWN_PROBABILITY, (Object)0)).with(HEIGHT_VARIATION, (Object)3)).with(SPLIT_ENDS, (Object)true);
    }

    @Override
    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{CHANCE_TO_SPLIT, DOWN_PROBABILITY, HEIGHT_VARIATION, SPLIT_ENDS});
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        Direction originDir;
        Level level = context.level();
        GrowSignal signal = context.signal();
        int[] probMap = context.probMap();
        BlockPos pos = context.pos();
        int count = this.validSurroundingBranches((LevelAccessor)level, pos, originDir = signal.dir.m_122424_(), (arg_0, arg_1) -> TwistingTreeLogic.lambda$populateDirectionProbabilityMap$0((LevelAccessor)level, configuration, probMap, arg_0, arg_1));
        if (count == 0 || ((Boolean)configuration.get(SPLIT_ENDS)).booleanValue() && signal.energy < 3.0f) {
            probMap[0] = (Integer)configuration.get(DOWN_PROBABILITY);
            probMap[1] = context.species().getUpProbability();
            probMap[5] = 1;
            probMap[4] = 1;
            probMap[3] = 1;
            probMap[2] = 1;
        }
        probMap[originDir.ordinal()] = 0;
        return probMap;
    }

    protected int validSurroundingBranches(LevelAccessor level, BlockPos pos, Direction originDir, BiConsumer<Direction, Integer> runForValidDirs) {
        int count = 0;
        for (Direction direction : Direction.values()) {
            int rad;
            if (direction == originDir || (rad = TreeHelper.getRadius((BlockGetter)level, (BlockPos)pos.m_121955_(direction.m_122436_()))) <= 0) continue;
            ++count;
            runForValidDirs.accept(direction, rad);
        }
        return count;
    }

    private static /* synthetic */ void lambda$populateDirectionProbabilityMap$0(LevelAccessor level, GrowthLogicKitConfiguration configuration, int[] probMap, Direction dir, Integer rad) {
        boolean shouldSplit = level.m_213780_().m_188501_() < ((Float)configuration.get(CHANCE_TO_SPLIT)).floatValue();
        probMap[dir.ordinal()] = rad + (shouldSplit ? 1 : 0);
    }
}

